/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.ui.LMUIConstants;
import com.dbeaver.lm.ui.LicenseImportDialog;
import com.dbeaver.lm.ui.LicenseInfoDialog;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMSubscription;
import org.jkiss.utils.CommonUtils;

public class LicenseManagementDialog
extends Dialog {
    public static final int IMPORT_BUTTON_ID = 1000;
    public static final int DELETE_BUTTON_ID = 1001;
    private final LMLicenseManager licenseManager;
    private final LMProduct product;
    private Table licTable;

    public LicenseManagementDialog(Shell parentShell, LMLicenseManager licenseManager, LMProduct product) {
        super(parentShell);
        this.licenseManager = licenseManager;
        this.product = product;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("License Management");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite infoComposite = UIUtils.createPlaceholder((Composite)composite, (int)2);
        infoComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)infoComposite, (String)"Active Product", (String)(String.valueOf(this.product.getName()) + " (" + this.product.getVersion() + ")"), (int)2056);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)"Licenses", (int)1, (int)1808, (int)0);
        this.licTable = new Table((Composite)group, 67584);
        this.licTable.setHeaderVisible(true);
        this.licTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = this.licTable.getHeaderHeight() * 6;
        this.licTable.setLayoutData((Object)gd);
        this.licTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem[] selection = LicenseManagementDialog.this.licTable.getSelection();
                if (selection.length == 1) {
                    LMLicense license = (LMLicense)selection[0].getData();
                    LicenseInfoDialog infoDialog = new LicenseInfoDialog(LicenseManagementDialog.this.getShell(), LicenseManagementDialog.this.licenseManager, LicenseManagementDialog.this.product);
                    infoDialog.setViewLicense(license);
                    infoDialog.open();
                }
            }
        });
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"Type");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"Version");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"Subject");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"E-Mail");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"Issue time");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"Start time");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"End time");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"State");
        this.refreshLicenseTable();
        return parent;
    }

    private void refreshLicenseTable() {
        this.licTable.removeAll();
        LMLicense[] licenses = this.licenseManager.getProductLicenses(this.product);
        if (licenses != null) {
            LMLicense[] lMLicenseArray = licenses;
            int n = licenses.length;
            int n2 = 0;
            while (n2 < n) {
                LMLicense license = lMLicenseArray[n2];
                LMSubscription subscription = null;
                if (license.isSubscription()) {
                    subscription = this.licenseManager.getSubscriptionInfo(license);
                }
                TableItem item = new TableItem(this.licTable, 0);
                item.setData((Object)license);
                item.setText(0, license.getLicenseTypeFull());
                item.setText(1, license.getProductVersion());
                item.setText(2, CommonUtils.notEmpty((String)license.getOwnerFull()));
                item.setText(3, CommonUtils.notEmpty((String)license.getOwnerEmail()));
                item.setText(4, LMUIConstants.DATE_FORMAT.format(license.getLicenseIssueTime()));
                item.setText(5, LMUIConstants.DATE_FORMAT.format(license.getLicenseStartTime()));
                Date licenseEndTime = license.getLicenseEndTime();
                if (subscription != null) {
                    licenseEndTime = subscription.getExpirationDate();
                }
                item.setText(6, licenseEndTime == null ? "Perpetual" : LMUIConstants.DATE_FORMAT.format(licenseEndTime));
                ++n2;
            }
        }
        UIUtils.packColumns((Table)this.licTable);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1000, "Import", false);
        this.createButton(parent, 1001, "Delete", false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            LicenseImportDialog importDialog = new LicenseImportDialog(this.getShell(), this.licenseManager, this.product);
            if (importDialog.open() == 0) {
                this.refreshLicenseTable();
            }
            return;
        }
        if (buttonId == 1001) {
            try {
                this.deleteSelectedLicense();
            }
            catch (LMException e) {
                DBUserInterface.getInstance().showError("Delete license", "Error deleting license", (Throwable)e);
            }
            this.refreshLicenseTable();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void deleteSelectedLicense() throws LMException {
        TableItem[] tableItemArray = this.licTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LMLicense license = (LMLicense)item.getData();
            if (license.getLicenseType() == LMLicenseType.TRIAL) {
                MessageBox errorBox = new MessageBox(this.getShell(), 1);
                errorBox.setText("Delete license");
                errorBox.setMessage("You can't delete trial license.");
                errorBox.open();
            } else {
                MessageBox confirm = new MessageBox(this.getShell(), 194);
                confirm.setText("Delete license");
                confirm.setMessage("Are you sure you want to delete license '" + license.getLicenseId() + "'?\n" + "You won't be able to undo this operation although you can import this license again.");
                if (confirm.open() == 64) {
                    this.licenseManager.deleteLicense(this.product, license);
                    this.licTable.remove(this.licTable.indexOf(item));
                }
            }
            ++n2;
        }
    }
}

