/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.ui.LMUIConstants;
import com.dbeaver.lm.ui.LicenseExportDialog;
import com.dbeaver.lm.ui.LicenseManagementDialog;
import com.dbeaver.lm.ui.LicenseUIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseFormat;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMValidateException;

public class LicenseInfoDialog
extends Dialog {
    private static final int MANAGER_BUTTON_ID = 3000;
    private static final int EXPORT_BUTTON_ID = 3001;
    private final LMLicenseManager licenseManager;
    private final LMProduct product;
    private LMLicense viewLicense = null;

    public LicenseInfoDialog(Shell parentShell, LMLicenseManager licenseManager, LMProduct product) {
        super(parentShell);
        this.licenseManager = licenseManager;
        this.product = product;
    }

    void setViewLicense(LMLicense viewLicense) {
        this.viewLicense = viewLicense;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("License Information");
        LMValidateException validateException = null;
        LMLicense productLicense = this.viewLicense;
        if (productLicense == null) {
            try {
                productLicense = this.licenseManager.getValidProductLicense(LicenseUIUtils.getClientId(), this.product);
            }
            catch (LMValidateException e) {
                validateException = e;
            }
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)2, (int)1808, (int)0);
        if (productLicense == null) {
            Label naLabel = new Label((Composite)group, 0);
            GridData gd = new GridData(64);
            gd.horizontalSpan = 2;
            naLabel.setLayoutData((Object)gd);
            naLabel.setText(validateException == null ? "No Valid License Found" : validateException.getMessage());
        } else {
            LMSubscription subscription = null;
            if (productLicense.isSubscription()) {
                subscription = this.licenseManager.getSubscriptionInfo(productLicense);
            }
            UIUtils.createLabelText((Composite)group, (String)"Product", (String)this.product.getName(), (int)2056);
            UIUtils.createLabelText((Composite)group, (String)"Version", (String)productLicense.getProductVersion(), (int)2056);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.minimumWidth = 300;
            new Label((Composite)group, 258).setLayoutData((Object)gd);
            UIUtils.createLabelText((Composite)group, (String)"License ID", (String)productLicense.getLicenseId(), (int)2056);
            UIUtils.createLabelText((Composite)group, (String)"License type", (String)productLicense.getLicenseTypeFull(), (int)2056);
            UIUtils.createLabelText((Composite)group, (String)"Licensed to", (String)productLicense.getOwnerFull(), (int)2056);
            if (productLicense.getFormat() != LMLicenseFormat.STANDARD) {
                UIUtils.createLabelText((Composite)group, (String)"License e-mail", (String)productLicense.getOwnerEmail(), (int)2056);
            }
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.minimumWidth = 300;
            new Label((Composite)group, 258).setLayoutData((Object)gd);
            if (productLicense.getFormat() != LMLicenseFormat.STANDARD && subscription == null) {
                UIUtils.createLabelText((Composite)group, (String)"Users", (String)(productLicense.getLicenseType() == LMLicenseType.ULTIMATE ? "Unlimited" : (productLicense.getUsersNumber() <= 1 ? "Single user" : "Multiuser (" + productLicense.getUsersNumber() + ")")), (int)2056);
                if (productLicense.getYearsNumber() > 0) {
                    String periodStr = productLicense.getLicenseEndTime() == null ? (productLicense.getYearsNumber() == 1 ? "1 year" : String.valueOf(productLicense.getYearsNumber()) + " years") : "Until " + LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseEndTime());
                    UIUtils.createLabelText((Composite)group, (String)"Support period", (String)periodStr, (int)2056);
                }
            }
            UIUtils.createLabelText((Composite)group, (String)"Issue time", (String)LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseIssueTime()), (int)2056);
            if (subscription != null) {
                UIUtils.createLabelText((Composite)group, (String)"Renew time", (String)LMUIConstants.DATE_FORMAT.format(subscription.getLastRenewDate()), (int)2056);
                UIUtils.createLabelText((Composite)group, (String)"Expire time", (String)LMUIConstants.DATE_FORMAT.format(subscription.getExpirationDate()), (int)2056);
            } else {
                UIUtils.createLabelText((Composite)group, (String)"Start time", (String)LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseStartTime()), (int)2056);
                UIUtils.createLabelText((Composite)group, (String)"End time", (String)(productLicense.getLicenseEndTime() == null ? "N/A (Perpetual)" : LMUIConstants.DATE_FORMAT.format(productLicense.getLicenseEndTime())), (int)2056);
            }
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridData)parent.getLayoutData()).grabExcessHorizontalSpace = true;
        if (this.viewLicense == null) {
            Button lmButton = this.createButton(parent, 3000, "License Manager", false);
            ((GridData)lmButton.getLayoutData()).horizontalAlignment = 1;
            ((GridData)lmButton.getLayoutData()).grabExcessHorizontalSpace = true;
        }
        this.createButton(parent, 3001, "Export", false);
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        ((GridData)okButton.getLayoutData()).horizontalAlignment = 3;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 3000: {
                super.buttonPressed(0);
                LicenseManagementDialog dialog = new LicenseManagementDialog(this.getShell(), this.licenseManager, this.product);
                dialog.open();
                break;
            }
            case 3001: {
                try {
                    LMLicense productLicense = this.licenseManager.getValidProductLicense(LicenseUIUtils.getClientId(), this.product);
                    LicenseExportDialog dialog = new LicenseExportDialog(this.getShell(), productLicense);
                    dialog.open();
                }
                catch (LMValidateException e) {
                    DBeaverUI.getInstance().showError("Export license", "Error getting valid license", (Throwable)e);
                }
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }
}

