/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.ui.resultset;

import com.dbeaver.ee.chart.model.ChartMeasurement;
import com.dbeaver.ee.chart.model.ChartValue;
import com.dbeaver.ee.chart.ui.resultset.ResultsChartComposite;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.utils.CommonUtils;

public class ResultsChartPresentation
extends AbstractPresentation {
    private static final Log log = Log.getLog(ResultsChartPresentation.class);
    private static ChartTheme CLASSIC_THEME = StandardChartTheme.createJFreeTheme();
    private static ChartTheme DARK_THEME = StandardChartTheme.createDarknessTheme();
    protected ResultsChartComposite canvas;
    protected JFreeChart chart;
    private List<ChartMeasurement> measurements = new ArrayList<ChartMeasurement>();
    private static final Map<String, List<ChartMeasurement>> measurementCache = new HashMap<String, List<ChartMeasurement>>();

    public List<ChartMeasurement> getMeasurements() {
        ArrayList<ChartMeasurement> arrayList = new ArrayList<ChartMeasurement>(this.measurements.size());
        for (ChartMeasurement chartMeasurement : this.measurements) {
            arrayList.add(new ChartMeasurement(chartMeasurement));
        }
        return arrayList;
    }

    public void setMeasurements(List<ChartMeasurement> list) {
        this.measurements.clear();
        this.measurements.addAll(list);
        this.saveMeasurementsInfo();
    }

    public void createPresentation(@NotNull IResultSetController iResultSetController, @NotNull Composite composite) {
        super.createPresentation(iResultSetController, composite);
        this.canvas = new ResultsChartComposite(this, composite, 0);
        this.canvas.setLayoutData(new GridData(1808));
        this.canvas.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.canvas.addDisposeListener(disposeEvent -> {});
        this.registerContextMenu();
        this.trackPresentationControl();
        UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)iResultSetController.getSite(), (Control)this.canvas);
        this.applyThemeSettings();
    }

    protected void applyThemeSettings() {
        ITheme iTheme;
        boolean bl = false;
        IThemeEngine iThemeEngine = (IThemeEngine)PlatformUI.getWorkbench().getService(IThemeEngine.class);
        if (iThemeEngine != null && (iTheme = iThemeEngine.getActiveTheme()) != null) {
            bl = iTheme.getId().contains("dark");
        }
        iTheme = bl ? DARK_THEME : CLASSIC_THEME;
        if (ChartFactory.getChartTheme() != iTheme) {
            ChartFactory.setChartTheme((ChartTheme)iTheme);
            if (this.canvas.getChart() != null) {
                this.refreshData(false, false, true);
            }
        }
    }

    public Composite getControl() {
        return this.canvas;
    }

    public void formatData(boolean bl) {
    }

    public void clearMetaData() {
    }

    public void updateValueView() {
    }

    public void changeMode(boolean bl) {
    }

    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition rowPosition) {
        super.scrollToRow(rowPosition);
    }

    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.controller.getModel().getDocumentAttribute();
    }

    @Nullable
    public String copySelectionToString(ResultSetCopySettings resultSetCopySettings) {
        return null;
    }

    public ISelection getSelection() {
        return new StructuredSelection();
    }

    public void setSelection(ISelection iSelection) {
    }

    public void refreshData(boolean bl, boolean bl2, boolean bl3) {
        if (this.measurements.isEmpty() || !bl3) {
            this.loadMeasurements();
        }
        this.canvas.setRedraw(false);
        try {
            CategoryDataset categoryDataset = this.createCategoryDataSet();
            ChartMeasurement chartMeasurement = this.measurements.isEmpty() ? null : this.measurements.get(0);
            this.chart = ChartFactory.createBarChart((String)(chartMeasurement == null ? "Can not generate chart from data" : ""), (String)(chartMeasurement == null ? "N/A" : chartMeasurement.getTitleX()), (String)(chartMeasurement == null ? "N/A" : chartMeasurement.getTitleY()), (CategoryDataset)categoryDataset);
            CategoryPlot categoryPlot = this.chart.getCategoryPlot();
            this.chart.removeLegend();
            categoryPlot.setShadowGenerator(null);
            ValueAxis valueAxis = categoryPlot.getRangeAxis();
            valueAxis.setUpperMargin(0.1);
            valueAxis.setLabelInsets(new RectangleInsets(3.0, 3.0, 3.0, 10.0));
            CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            categoryAxis.setLowerMargin(0.01);
            categoryAxis.setUpperMargin(0.01);
            Font font = categoryAxis.getTickLabelFont();
            Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
            categoryAxis.setTickLabelFont(font2);
            categoryPlot.getRangeAxis().setTickLabelFont(font2);
            BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
            barRenderer.setDrawBarOutline(false);
            barRenderer.setBarPainter((BarPainter)new StandardBarPainter());
            barRenderer.setSeriesItemLabelGenerator(0, (CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            barRenderer.setSeriesItemLabelsVisible(1, true);
            barRenderer.setSeriesItemLabelFont(0, font2);
            barRenderer.setBaseItemLabelsVisible(true);
            barRenderer.setBaseSeriesVisible(true);
            this.canvas.setChart(this.chart);
            this.canvas.setDomainZoomable(false);
            this.canvas.setRangeZoomable(false);
        }
        finally {
            this.canvas.setRedraw(true);
        }
        if (!bl3 && this.measurements.isEmpty()) {
            this.canvas.showChartConfigDialog();
        }
    }

    private void loadMeasurements() {
        this.measurements.clear();
        if (this.loadMeasurementsInfo()) {
            return;
        }
        ChartMeasurement chartMeasurement = this.collectChartInfo((DBRProgressMonitor)new VoidProgressMonitor());
        if (chartMeasurement != null) {
            this.measurements.add(chartMeasurement);
        }
        this.saveMeasurementsInfo();
    }

    private ChartMeasurement collectChartInfo(DBRProgressMonitor dBRProgressMonitor) {
        Object object;
        DBDAttributeBinding dBDAttributeBinding32;
        ResultSetModel resultSetModel = this.getController().getModel();
        List list = resultSetModel.getVisibleAttributes();
        ArrayList<DBDAttributeBinding> arrayList = new ArrayList<DBDAttributeBinding>();
        ArrayList<DBDAttributeBinding> arrayList2 = new ArrayList<DBDAttributeBinding>();
        DBDAttributeBinding dBDAttributeBinding2 = null;
        for (DBDAttributeBinding dBDAttributeBinding32 : list) {
            DBSEntityAttribute dBSEntityAttribute3 = dBDAttributeBinding32.getEntityAttribute();
            if (dBSEntityAttribute3 != null && dBSEntityAttribute3.isAutoGenerated()) {
                dBDAttributeBinding2 = dBDAttributeBinding32;
                continue;
            }
            switch (dBDAttributeBinding32.getDataKind()) {
                case NUMERIC: {
                    try {
                        if (dBSEntityAttribute3 != null && !CommonUtils.isEmpty((Collection)DBUtils.getAttributeReferrers((DBRProgressMonitor)dBRProgressMonitor, (DBSEntityAttribute)dBSEntityAttribute3))) {
                            arrayList.add(dBDAttributeBinding32);
                            break;
                        }
                    }
                    catch (DBException dBException) {
                        log.debug((Object)"Error checking attribute references", (Throwable)dBException);
                    }
                    arrayList2.add(dBDAttributeBinding32);
                    break;
                }
                case STRING: 
                case DATETIME: 
                case OBJECT: 
                case ROWID: {
                    arrayList.add(dBDAttributeBinding32);
                }
            }
        }
        if (arrayList.isEmpty() && arrayList2.size() > 1) {
            arrayList.add((DBDAttributeBinding)arrayList2.remove(0));
        }
        if (arrayList2.isEmpty() && dBDAttributeBinding2 != null) {
            arrayList2.add(dBDAttributeBinding2);
        }
        if (arrayList.isEmpty() || arrayList2.isEmpty()) {
            return null;
        }
        dBDAttributeBinding32 = null;
        DBDAttributeBinding dBSEntityAttribute2 = null;
        if (arrayList.size() > 1) {
            for (DBDAttributeBinding dBDAttributeBinding : arrayList) {
                object = dBDAttributeBinding.getEntityAttribute();
                if (object == null) continue;
                try {
                    DBSTableIndex dBSTableIndex = DBUtils.findAttributeIndex((DBRProgressMonitor)dBRProgressMonitor, (DBSEntityAttribute)object);
                    if (dBSTableIndex != null) {
                        if (dBSTableIndex.isUnique()) {
                            dBDAttributeBinding32 = dBDAttributeBinding;
                            continue;
                        }
                        dBSEntityAttribute2 = dBDAttributeBinding;
                        continue;
                    }
                    DBSEntityConstraint dBSEntityConstraint = DBUtils.getConstraint((DBRProgressMonitor)dBRProgressMonitor, (DBSEntity)object.getParentObject(), (DBSAttributeBase)object);
                    if (dBSEntityConstraint == null) continue;
                    if (dBSEntityConstraint.getConstraintType().isUnique()) {
                        dBDAttributeBinding32 = dBDAttributeBinding;
                        continue;
                    }
                    dBSEntityAttribute2 = dBDAttributeBinding;
                }
                catch (DBException dBException) {
                    log.debug((Object)dBException);
                }
            }
        }
        DBDAttributeBinding dBDAttributeBinding = dBDAttributeBinding32 != null ? dBDAttributeBinding32 : (dBSEntityAttribute2 != null ? dBSEntityAttribute2 : (DBDAttributeBinding)arrayList.get(0));
        DBDAttributeBinding dBDAttributeBinding4 = (DBDAttributeBinding)arrayList2.get(0);
        object = new ChartMeasurement();
        ((ChartMeasurement)object).setTitle(this.getController().getDataContainer().getName());
        ((ChartMeasurement)object).setTitleX(dBDAttributeBinding.getName());
        ((ChartMeasurement)object).setTitleY(dBDAttributeBinding4.getName());
        ((ChartMeasurement)object).setGroupAttributes(Collections.singletonList(dBDAttributeBinding));
        ((ChartMeasurement)object).setValueAttribute(dBDAttributeBinding4);
        ((ChartMeasurement)object).loadDataFromModel(dBRProgressMonitor, this.getController());
        return object;
    }

    public ChartMeasurement createEmptyMeasurement() {
        ChartMeasurement chartMeasurement = new ChartMeasurement();
        chartMeasurement.setTitle(this.getController().getDataContainer().getName());
        return chartMeasurement;
    }

    private CategoryDataset createCategoryDataSet() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (ChartMeasurement chartMeasurement : this.measurements) {
            List list;
            LinkedHashMap<Comparable, List> linkedHashMap = new LinkedHashMap<Comparable, List>();
            for (ChartValue chartValue : chartMeasurement.getValues()) {
                list = linkedHashMap.computeIfAbsent((Comparable)((Object)chartValue.getTitle()), comparable -> new ArrayList());
                list.add(chartValue.getValue());
                if (chartMeasurement.getMaxSampleCount() > 0 && linkedHashMap.size() >= chartMeasurement.getMaxSampleCount()) break;
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                list = (List)entry.getValue();
                Number number = list.size() > 1 ? (Number)chartMeasurement.getSampleFunction().execute(list) : (Number)((Number)list.get(0));
                defaultCategoryDataset.addValue(number, (Comparable)((Object)chartMeasurement.getTitleY()), (Comparable)entry.getKey());
            }
        }
        return defaultCategoryDataset;
    }

    private String getUniqueContainerName() {
        DBSDataContainer dBSDataContainer = this.getController().getDataContainer();
        return String.valueOf(dBSDataContainer.getDataSource().getContainer().getId()) + "(" + dBSDataContainer.getName() + ")";
    }

    private boolean loadMeasurementsInfo() {
        String string = this.getUniqueContainerName();
        List<ChartMeasurement> list = measurementCache.get(string);
        if (list == null) {
            return false;
        }
        this.measurements.clear();
        for (ChartMeasurement chartMeasurement : list) {
            ChartMeasurement chartMeasurement2 = new ChartMeasurement(chartMeasurement);
            chartMeasurement2.loadDataFromModel((DBRProgressMonitor)new VoidProgressMonitor(), this.getController());
            this.measurements.add(chartMeasurement2);
        }
        return true;
    }

    private void saveMeasurementsInfo() {
        String string = this.getUniqueContainerName();
        List<ChartMeasurement> list = this.getMeasurements();
        if (!list.isEmpty()) {
            measurementCache.put(string, list);
        }
    }
}

