/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.part;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.VQBIcon;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.model.VQBJoinType;
import com.dbeaver.ee.vqb.ui.part.QueryJoinEditPolicy;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.jkiss.dbeaver.ext.erd.figures.RoundedLineBorder;
import org.jkiss.dbeaver.ext.erd.part.AssociationPart;
import org.jkiss.dbeaver.ext.erd.policy.AssociationBendEditPolicy;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class QueryJoinPart
extends AssociationPart {
    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new AssociationBendEditPolicy());
        if (this.isEditEnabled()) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new QueryJoinEditPolicy());
        }
    }

    protected void setConnectionStyles(PolylineConnection polylineConnection) {
        polylineConnection.setLineWidth(2);
        ConnectionLocator connectionLocator = new ConnectionLocator((Connection)polylineConnection, 4);
        Label label = new Label(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
        polylineConnection.add((IFigure)label, (Object)connectionLocator);
        RoundedLineBorder roundedLineBorder = new RoundedLineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground"), 2, 5);
        roundedLineBorder.setMargin(3);
        label.setBorder((Border)roundedLineBorder);
        label.setOpaque(true);
    }

    private DBIcon getJoinIcon() {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            return VQBJoinType.getByJoin(join).getIcon();
        }
        return VQBIcon.JOIN_INNER;
    }

    protected void setConnectionToolTip(PolylineConnection polylineConnection) {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            Label label = new Label(join.toString());
            label.setBorder((Border)new MarginBorder(3));
            label.setIcon(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
            label.setTextPlacement(8);
            polylineConnection.setToolTip((IFigure)label);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            VQBEditorPart vQBEditorPart = VQBUtils.getQueryBuilderEditor((EditPart)this);
            vQBEditorPart.getPresentation().getQueryPanel().editElement("joins", this.getAssociation().getUserData());
        } else {
            super.performRequest(request);
        }
    }

    public void updateJoinType() {
        List list = this.getFigure().getChildren();
        if (list.size() == 1 && list.get(0) instanceof Label) {
            Label label = (Label)list.get(0);
            label.setIcon(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
        }
    }
}

