/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.handlers;

import com.dbeaver.ee.vqb.ui.handlers.VQBAbstractHandler;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class SplitEditorHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(SplitEditorHandler.class);

    public Object execute(ExecutionEvent executionEvent) {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        if (iEditorPart instanceof SQLEditor) {
            SQLEditor sQLEditor = (SQLEditor)iEditorPart;
            switch (sQLEditor.getExtraPresentationState()) {
                case MAXIMIZED: {
                    sQLEditor.showExtraPresentation(true, false);
                    break;
                }
                case VISIBLE: {
                    sQLEditor.showExtraPresentation(true, true);
                    break;
                }
                default: {
                    sQLEditor.showExtraPresentation(true, false);
                }
            }
        }
        VQBAbstractHandler.updateEditorCommandStates();
        return null;
    }

    public void updateElement(UIElement uIElement, Map map) {
        IWorkbenchWindow iWorkbenchWindow = (IWorkbenchWindow)uIElement.getServiceLocator().getService(IWorkbenchWindow.class);
        if (iWorkbenchWindow == null || iWorkbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart iEditorPart = iWorkbenchWindow.getActivePage().getActiveEditor();
        if (iEditorPart instanceof SQLEditor) {
            uIElement.setChecked(((SQLEditor)iEditorPart).getExtraPresentationState() == SQLEditorPresentation.ActivationType.VISIBLE);
        }
    }
}

