/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditPartFactory;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.VQBSelectionTool;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.utils.CommonUtils;

public class VQBEditorDecorator
extends ERDDecoratorDefault {
    private static final Log log = Log.getLog(VQBEditorDecorator.class);
    private final VQBEditorPart editorPart;

    public VQBEditorDecorator(VQBEditorPart vQBEditorPart) {
        this.editorPart = vQBEditorPart;
    }

    public boolean showCheckboxes() {
        return true;
    }

    public boolean allowEntityDuplicates() {
        return true;
    }

    public Insets getDefaultEntityInsets() {
        return new Insets(30, 40, 20, 40);
    }

    public EditPartFactory createPartFactory() {
        return new VQBEditPartFactory();
    }

    public void fillPalette(PaletteRoot paletteRoot, boolean bl) {
        PaletteDrawer paletteDrawer = this.createToolsDrawer(paletteRoot);
        SelectionToolEntry selectionToolEntry = new SelectionToolEntry();
        selectionToolEntry.setToolClass(VQBSelectionTool.class);
        paletteDrawer.add((PaletteEntry)selectionToolEntry);
        CreationFactory creationFactory = new CreationFactory(){

            public Object getNewObject() {
                return new ERDEntity(VQBEditorDecorator.this.editorPart.getDataSource());
            }

            public Object getObjectType() {
                return "create child";
            }
        };
        CreationToolEntry creationToolEntry = new CreationToolEntry("Add Table", "Add joined table", creationFactory, DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE));
        paletteDrawer.add((PaletteEntry)creationToolEntry);
        paletteRoot.setDefaultEntry((ToolEntry)selectionToolEntry);
    }

    public void fillEntityFromObject(DBRProgressMonitor dBRProgressMonitor, EntityDiagram entityDiagram, ERDEntity eRDEntity) {
        super.fillEntityFromObject(dBRProgressMonitor, entityDiagram, eRDEntity);
        if (eRDEntity.getUserData() == null) {
            DBSEntity dBSEntity = (DBSEntity)eRDEntity.getObject();
            DBSCatalog dBSCatalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)dBSEntity);
            DBSSchema dBSSchema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)dBSEntity);
            String string = DBUtils.getObjectFullName((DBPNamedObject)dBSEntity, (DBPEvaluationContext)DBPEvaluationContext.DML);
            VQBQueryInfo vQBQueryInfo = this.editorPart.getQueryInfo();
            Table table = new Table();
            table.setName(DBUtils.getQuotedIdentifier((DBSObject)dBSEntity));
            if (dBSSchema != null && dBSCatalog != null && string.startsWith(DBUtils.getQuotedIdentifier((DBSObject)dBSCatalog))) {
                table.setDatabase(new Database(dBSCatalog.getName()));
            }
            if (dBSSchema != null) {
                table.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)dBSSchema));
            }
            String string2 = this.generateEntityAlias(entityDiagram, dBSEntity);
            eRDEntity.setAlias(string2);
            Alias alias = new Alias(string2);
            alias.setUseAs(false);
            table.setAlias(alias);
            eRDEntity.setUserData((Object)table);
            PlainSelect plainSelect = vQBQueryInfo.getPlainSelect();
            if (plainSelect != null && plainSelect.getFromItem() == null) {
                plainSelect.setFromItem((FromItem)table);
                eRDEntity.setPrimary(true);
            }
        }
    }

    public ERDAssociation createAutoAssociation(ERDContainer eRDContainer, DBSEntityAssociation dBSEntityAssociation, ERDEntity eRDEntity, ERDEntity eRDEntity2, boolean bl) {
        Join join;
        Object object;
        Object object2;
        if (eRDEntity.hasAssociationsWith(eRDEntity2) || eRDEntity2.hasAssociationsWith(eRDEntity)) {
            return null;
        }
        if (eRDEntity == eRDEntity2) {
            return null;
        }
        boolean bl2 = false;
        if (eRDEntity2.isPrimary() || !CommonUtils.isEmpty((Collection)eRDEntity2.getReferences()) || !CommonUtils.isEmpty((Collection)eRDEntity2.getAssociations())) {
            if (!CommonUtils.isEmpty((Collection)eRDEntity.getReferences())) {
                log.debug((Object)("Both entities '" + eRDEntity.getName() + "' and '" + eRDEntity2.getName() + "' already participate in statement"));
                return null;
            }
            object2 = eRDEntity;
            eRDEntity = eRDEntity2;
            eRDEntity2 = object2;
            bl2 = true;
        }
        object2 = new ERDJoin(eRDEntity, eRDEntity2, bl);
        if (dBSEntityAssociation instanceof DBSEntityReferrer) {
            try {
                object = ((DBSEntityReferrer)dBSEntityAssociation).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
                if (!CommonUtils.isEmpty((Collection)object)) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        DBSTableColumn dBSTableColumn;
                        join = (DBSEntityAttributeRef)iterator.next();
                        if (!(join instanceof DBSTableForeignKeyColumn)) continue;
                        DBSTableColumn dBSTableColumn2 = ((DBSTableForeignKeyColumn)join).getReferencedColumn();
                        DBSEntityAttribute dBSEntityAttribute = join.getAttribute();
                        if (bl2) {
                            dBSTableColumn = dBSTableColumn2;
                            dBSTableColumn2 = dBSEntityAttribute;
                            dBSEntityAttribute = dBSTableColumn;
                        }
                        if (dBSEntityAttribute == null || dBSTableColumn2 == null) continue;
                        dBSTableColumn = ERDUtils.getAttributeByModel((ERDEntity)eRDEntity, (DBSEntityAttribute)dBSEntityAttribute);
                        ERDEntityAttribute eRDEntityAttribute = ERDUtils.getAttributeByModel((ERDEntity)eRDEntity2, (DBSEntityAttribute)dBSTableColumn2);
                        if (dBSTableColumn == null || eRDEntityAttribute == null) continue;
                        object2.addCondition((ERDEntityAttribute)dBSTableColumn, eRDEntityAttribute);
                    }
                }
            }
            catch (DBException dBException) {
                log.error((Object)"Error resolving ERD association attributes", (Throwable)dBException);
            }
        }
        if ((object = this.editorPart.getQueryInfo().getPlainSelect()) != null) {
            join = VQBUtils.findEntityJoin(this.editorPart.getDiagram(), (PlainSelect)object, null, eRDEntity2);
            if (join == null) {
                join = ((ERDJoin)((Object)object2)).createStatementJoin();
                VQBUtils.getQueryJoins((PlainSelect)object).add(join);
            } else {
                ((ERDJoin)((Object)object2)).updateStatementJoin(join);
            }
        }
        return object2;
    }

    private String generateEntityAlias(EntityDiagram entityDiagram, DBSEntity dBSEntity) {
        String string;
        String string2 = dBSEntity.getName();
        if (CommonUtils.isEmpty((String)string2)) {
            return dBSEntity.getName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (!Character.isLetter(c)) {
                bl = true;
            } else {
                if (bl) {
                    stringBuilder.append(c);
                }
                bl = false;
            }
            ++n;
        }
        String string3 = string = stringBuilder.toString().toLowerCase(Locale.ENGLISH);
        int n2 = 2;
        while (n2 < 500) {
            if (!this.aliasExist(entityDiagram, string3)) {
                return string3;
            }
            string3 = String.valueOf(string) + n2;
            ++n2;
        }
        return string3;
    }

    private boolean aliasExist(EntityDiagram entityDiagram, String string) {
        for (ERDEntity eRDEntity : entityDiagram.getEntities()) {
            if (!string.equals(eRDEntity.getAlias()) && !string.equals(eRDEntity.getName())) continue;
            return true;
        }
        return false;
    }
}

