/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.builder;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class VQBQueryInfo {
    private static final Log log = Log.getLog(VQBQueryInfo.class);
    private final SQLQuery query;
    private final Select parsedQuery;
    private List<Expression> excludedWhereConditions = new ArrayList<Expression>();

    public VQBQueryInfo(SQLQuery sQLQuery, Select select) {
        this.query = sQLQuery;
        this.parsedQuery = select;
    }

    public SQLQuery getQuery() {
        return this.query;
    }

    public Select getParsedQuery() {
        return this.parsedQuery;
    }

    public PlainSelect getPlainSelect() {
        if (this.parsedQuery != null && this.parsedQuery.getSelectBody() instanceof PlainSelect) {
            return (PlainSelect)this.parsedQuery.getSelectBody();
        }
        return null;
    }

    public boolean isConditionExcluded(Expression expression) {
        return this.excludedWhereConditions.contains(expression);
    }

    public void excludeWhereCondition(Expression expression) {
        this.excludedWhereConditions.add(expression);
    }

    public void refreshStatement(boolean bl) {
        if (this.parsedQuery != null) {
            String string = this.parsedQuery.toString();
            if (bl && this.query.getDataSource() instanceof SQLDataSource) {
                string = SQLUtils.formatSQL((SQLDataSource)((SQLDataSource)this.query.getDataSource()), (String)string);
            }
            this.query.setText(string);
        }
    }
}

