/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNode;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class MySQLPlanAnalyser
implements DBCPlan {
    private MySQLDataSource dataSource;
    private String query;
    private List<DBCPlanNode> rootNodes;

    public MySQLPlanAnalyser(MySQLDataSource dataSource, String query) {
        this.dataSource = dataSource;
        this.query = query;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN EXTENDED " + this.query;
    }

    public Collection<DBCPlanNode> getPlanNodes() {
        return this.rootNodes;
    }

    public void explain(DBCSession session) throws DBCException {
        String plainQuery = SQLUtils.stripComments((SQLDialect)SQLUtils.getDialectFromObject((DBPObject)session.getDataSource()), (String)this.query).toUpperCase();
        if (!plainQuery.startsWith("SELECT")) {
            throw new DBCException("Only SELECT statements could produce execution plan");
        }
        JDBCSession connection = (JDBCSession)session;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = connection.prepareStatement(this.getPlanQueryString());){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    this.rootNodes = new ArrayList<DBCPlanNode>();
                    while (dbResult.next()) {
                        MySQLPlanNode node = new MySQLPlanNode(null, (ResultSet)dbResult);
                        this.rootNodes.add(node);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, session.getDataSource());
        }
    }
}

