/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybDriver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class LoaderConnection {
    protected static final int MAX_BUFFER_SIZE = 1000;
    private Driver _driver;
    private Connection _connection;
    private String _url;
    private Properties _properties;
    private boolean _keepAlive;

    public LoaderConnection(String string, Properties properties) {
        this(new SybDriver(), string, properties);
    }

    public LoaderConnection(Driver driver, String string, Properties properties) {
        this._url = string;
        this.setProps(properties);
        this._connection = null;
        this._keepAlive = true;
        this._driver = driver;
    }

    protected byte[] fetchClass(String string) throws SQLException {
        this.open();
        byte[] byArray = null;
        SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)this._connection.getMetaData();
        ResultSet resultSet = sybDatabaseMetaData.getClassForName(string);
        if (!resultSet.next()) {
            throw new SQLException("No results returned!");
        }
        byArray = resultSet.getBytes(1);
        resultSet.close();
        this.close();
        return byArray;
    }

    protected byte[] fetchClassFromJar(String string, String string2) throws SQLException {
        this.open();
        byte[] byArray = null;
        SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)this._connection.getMetaData();
        ResultSet resultSet = sybDatabaseMetaData.getJarForClass(string);
        if (resultSet.next()) {
            InputStream inputStream = resultSet.getBinaryStream(1);
            try {
                JarInputStream jarInputStream = new JarInputStream(inputStream);
                ClassData classData = this.readJarBytes(jarInputStream, string);
                if (classData != null) {
                    byArray = classData._data;
                }
                jarInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resultSet.next()) {
                throw new SQLException("More than one row was returned for class " + string + ", jar " + string2);
            }
        }
        resultSet.close();
        this.close();
        return byArray;
    }

    protected Enumeration allClassesInJar(String string) throws SQLException {
        this.open();
        SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)this._connection.getMetaData();
        Enumeration enumeration = sybDatabaseMetaData.canReturnJars() ? new JarDataEnumeration(string) : new ClassDataEnumeration(string);
        this.close();
        return enumeration;
    }

    protected ClassData readJarBytes(JarInputStream jarInputStream, String string) throws IOException {
        JarEntry jarEntry;
        ClassData classData = null;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory()) continue;
            String string2 = jarEntry.getName();
            if (string != null && !string2.equals(string.concat(".class"))) continue;
            int n = 1000;
            if (jarEntry.getSize() > 0L && jarEntry.getSize() < 1000L) {
                n = (int)jarEntry.getSize();
            }
            classData = new ClassData();
            classData._data = this.readBytes(jarInputStream, n);
            classData._name = string2.substring(0, string2.lastIndexOf(".class")).replace('/', '.');
            jarInputStream.closeEntry();
            break;
        }
        return classData;
    }

    protected byte[] readBytes(InputStream inputStream, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    protected void kill() throws SQLException {
        this._connection.close();
        this._connection = null;
    }

    protected Connection getConnection() {
        return this._connection;
    }

    protected void open() throws SQLException {
        if (this._connection == null) {
            this._connection = this._driver.connect(this._url, this._properties);
        }
    }

    protected void close() throws SQLException {
        if (!this._keepAlive) {
            this.kill();
        }
    }

    public void setKeepAlive(boolean bl) {
        this._keepAlive = bl;
    }

    protected boolean getKeepAlive() {
        return this._keepAlive;
    }

    private void setProps(Properties properties) {
        this._properties = (Properties)properties.clone();
        Enumeration<Object> enumeration = this._properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase("class_loader") && !string.equalsIgnoreCase("preload_jars")) continue;
            this._properties.remove(string);
        }
    }

    protected class ClassData {
        protected String _name;
        protected byte[] _data;

        protected ClassData() {
        }

        public byte[] getData() {
            return this._data;
        }
    }

    protected class ClassDataEnumeration
    implements Enumeration {
        private Enumeration _enum;

        protected ClassDataEnumeration(String string) throws SQLException {
            SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)LoaderConnection.this._connection.getMetaData();
            ResultSet resultSet = sybDatabaseMetaData.getClassesInJar(string);
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                vector.addElement(string2);
            }
            resultSet.close();
            this._enum = vector.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return this._enum.hasMoreElements();
        }

        public Object nextElement() {
            ClassData classData = new ClassData();
            classData._name = (String)this._enum.nextElement();
            try {
                classData._data = LoaderConnection.this.fetchClass(classData._name);
            }
            catch (SQLException sQLException) {
                classData = null;
            }
            return classData;
        }
    }

    protected class JarDataEnumeration
    implements Enumeration {
        ResultSet _rs;
        private JarInputStream _jarStream;
        private ClassData _nextElement = null;

        protected JarDataEnumeration(String string) throws SQLException {
            SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)LoaderConnection.this._connection.getMetaData();
            this._rs = sybDatabaseMetaData.getJarByName(string);
            if (this._rs.next()) {
                InputStream inputStream = this._rs.getBinaryStream(1);
                try {
                    this._jarStream = new JarInputStream(inputStream);
                    this._nextElement = this.fetchNextElement();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            boolean bl;
            boolean bl2 = bl = this._nextElement != null;
            if (!bl) {
                try {
                    this._rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return bl;
        }

        public Object nextElement() {
            ClassData classData = this._nextElement;
            this._nextElement = this.fetchNextElement();
            return classData;
        }

        private ClassData fetchNextElement() {
            ClassData classData;
            try {
                classData = LoaderConnection.this.readJarBytes(this._jarStream, null);
            }
            catch (IOException iOException) {
                classData = null;
            }
            return classData;
        }
    }
}

