/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxBlob
extends IfxObject {
    private static final short h = 0;
    private static final short i = 1;
    private static final short j = 2;
    private static final short k = 3;
    protected static final short BLOBISNULL = 1;
    protected static final short BLOB_TYPE_BYTES = 0;
    protected static final short BLOB_TYPE_STREAM = 1;
    protected byte[] blobDesc = null;
    protected int tb_start = 1;
    protected int tb_end = 0;
    protected int tb_size;
    protected short tb_flags;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short ifxType = 0;

    IfxBlob() throws SQLException {
        this.blobDesc = new byte[56];
        this.nullify();
    }

    public IfxBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    protected short getBlobType() {
        return this.blobType;
    }

    protected boolean isBlobByteType() {
        return this.blobType == 0;
    }

    protected boolean isIfxTextType() {
        return this.ifxType == 1;
    }

    protected byte[] getBlobBuffer() {
        return this.blobBuffer;
    }

    protected void setBlobBuffer(byte[] byArray) {
        this.blobBuffer = byArray;
    }

    protected int getBlobLength() {
        return this.tb_end - this.tb_start + 1;
    }

    protected void setBlobLength(int n, int n2, int n3) {
        this.tb_size = n;
        this.tb_start = n2;
        this.tb_end = n3;
    }

    protected void setBlobLength(int n) {
        this.setBlobLength(n, 1, n);
    }

    protected InputStream getBlobInputStream() {
        return this.BlobInputStream;
    }

    protected String getBlobFileName() {
        if (this.tempBlobFile != null) {
            return this.tempBlobFile.getFileName();
        }
        return null;
    }

    protected void setBlobFileName() {
        if (this.tempBlobFile != null) {
            this.tempBlobFile.close();
            this.tempBlobFile = null;
        }
    }

    protected boolean isBlobLoaded() {
        return this.isBlob_loaded;
    }

    protected void setLoaded() {
        this.isBlob_loaded = true;
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, n, this.blobDesc, 0, 56);
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[2];
        System.arraycopy(byArray, 16 + n, byArray2, 0, 4);
        System.arraycopy(byArray, 8 + n, byArray3, 0, 4);
        System.arraycopy(byArray, 12 + n, byArray4, 0, 4);
        this.setBlobLength(IfxToJavaType.IfxToJavaInt(byArray2), IfxToJavaType.IfxToJavaInt(byArray3), IfxToJavaType.IfxToJavaInt(byArray4));
        boolean bl = this.conn.isXPS();
        if (bl) {
            this.tb_size = this.tb_end - this.tb_start + 1;
        }
        System.arraycopy(byArray, 38 + n, byArray5, 0, 2);
        this.tb_flags = IfxToJavaType.IfxToJavaSmallInt(byArray5);
        if (this.tb_flags != 1) {
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        byte[] byArray = new byte[4];
        byArray = JavaToIfxType.JavaToIfxInt(this.tb_size);
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, 0, this.blobDesc, 16, 4);
        return this.blobDesc;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            if (this.blobDesc == null) {
                this.blobDesc = new byte[56];
            }
            memoryUtil.byfill(this.blobDesc, (byte)0);
            this.blobDesc[39] = 1;
            return this.blobDesc;
        }
        return this.toIfx();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.b();
                return ifxInputStream;
            }
            catch (Exception exception) {
                SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                throw sQLException;
            }
        }
        if (this.blobBuffer != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
            return byteArrayInputStream;
        }
        return null;
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        block3: {
            block2: {
                this.setBlobLength(n);
                if (!(inputStream instanceof IfxLobInputStream)) break block2;
                this.BlobInputStream = ((IfxLobInputStream)inputStream).getStream();
                if (IfxStatement.t == 0) break block3;
            }
            this.BlobInputStream = inputStream;
        }
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
    }

    @Override
    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        block10: {
            block11: {
                int n2;
                block9: {
                    block8: {
                        n2 = IfxStatement.t;
                        if (n <= 0 || reader == null) break block9;
                        char[] cArray = new char[n];
                        int n3 = 0;
                        int n4 = 0;
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        try {
                            if (bufferedReader.ready()) {
                                n3 = bufferedReader.read(cArray, n4, n);
                                this.setBlobLength(n3);
                                this.blobBuffer = new String(cArray).getBytes();
                                if (n2 == 0) break block8;
                            }
                            this.setBlobLength(0);
                            this.blobBuffer = null;
                        }
                        catch (Exception exception) {
                            SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                            sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                            throw sQLException;
                        }
                    }
                    if (n2 == 0) break block10;
                }
                this.setBlobLength(0);
                if (reader == null || n != 0) break block11;
                this.blobBuffer = new byte[0];
                if (n2 == 0) break block10;
            }
            this.blobBuffer = null;
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new StringReader(this.toString());
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.ifxType = 1;
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.ifxType = 0;
    }

    @Override
    public String toString() {
        int n = IfxStatement.t;
        if (this.blobBuffer != null) {
            try {
                if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                    if (((IfxSqliConnect)this.conn).x()) {
                        return ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(this.blobBuffer, 0, this.blobBuffer.length, ((IfxSqliConnect)this.conn).getclEncoding(), ((IfxSqliConnect)this.conn).encoption);
                    }
                    return ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(this.blobBuffer, 0, this.blobBuffer.length, ((IfxSqliConnect)this.conn).returnEnc(), ((IfxSqliConnect)this.conn).encoption);
                }
                return new String(this.blobBuffer);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.tempBlobFile != null) {
            byte[] byArray;
            block19: {
                int n2;
                IfxInputStream ifxInputStream;
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    try {
                        PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    ifxInputStream = this.tempBlobFile.b();
                    n2 = ifxInputStream.available();
                }
                catch (Exception exception) {
                    return null;
                }
                IfxInputStream ifxInputStream2 = ifxInputStream;
                byArray = new byte[n2];
                int n3 = 0;
                try {
                    byte by = (byte)((InputStream)ifxInputStream2).read();
                    while (by != -1) {
                        byArray[n3] = by;
                        ++n3;
                        by = (byte)((InputStream)ifxInputStream2).read();
                        if (n == 0) {
                            if (n == 0) continue;
                        }
                        break block19;
                    }
                    ((FileInputStream)ifxInputStream).close();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                try {
                    if (((IfxSqliConnect)this.conn).x()) {
                        return ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 0, byArray.length, ((IfxSqliConnect)this.conn).getclEncoding(), ((IfxSqliConnect)this.conn).encoption);
                    }
                    return ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 0, byArray.length, ((IfxSqliConnect)this.conn).returnEnc(), ((IfxSqliConnect)this.conn).encoption);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return new String(byArray);
        }
        return null;
    }

    @Override
    public void fromString(String string) throws SQLException {
        block6: {
            int n;
            block7: {
                n = IfxStatement.t;
                if (string != null) break block7;
                this.setBlobLength(0);
                this.blobBuffer = null;
                this.nullify();
                if (n == 0) break block6;
            }
            String string2 = this.conn.getdbEncoding();
            try {
                block9: {
                    block8: {
                        if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(string, string2, ((IfxSqliConnect)this.conn).encoption);
                        }
                        if (string2 == null) break block8;
                        this.blobBuffer = string.getBytes(string2);
                        if (n == 0) break block9;
                    }
                    this.blobBuffer = string.getBytes();
                }
                this.setBlobLength(this.blobBuffer.toString().length());
                this.unnullify();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!(exception instanceof IOException)) break block6;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
    }

    @Override
    public Object toObject() throws SQLException {
        return this.toBytes();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (this.blobBuffer != null) {
            return (byte[])this.blobBuffer.clone();
        }
        if (this.tempBlobFile != null) {
            int n;
            IfxInputStream ifxInputStream;
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                ifxInputStream = this.tempBlobFile.b();
                n = ifxInputStream.available();
            }
            catch (Exception exception) {
                return null;
            }
            byte[] byArray = new byte[n];
            try {
                ifxInputStream.read(byArray, 0, n);
                ((FileInputStream)ifxInputStream).close();
            }
            catch (Exception exception) {
                return null;
            }
            return byArray;
        }
        return null;
    }

    @Override
    public void fromBytes(byte[] byArray) {
        block3: {
            block2: {
                if (byArray != null) break block2;
                this.setBlobLength(0);
                this.blobBuffer = null;
                if (IfxStatement.t == 0) break block3;
            }
            this.setBlobLength(byArray.length);
            this.blobBuffer = byArray;
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
    }

    @Override
    public Blob toBlob() throws SQLException {
        IfxBblob ifxBblob = null;
        if (this.tempBlobFile != null) {
            try {
                ifxBblob = new IfxBblob(this.tempBlobFile);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            ifxBblob = new IfxBblob(this.blobBuffer);
        } else {
            return null;
        }
        ifxBblob.setLoadFlag();
        if (ifxBblob.smb != null) {
            ((IfxSqliConnect)this.conn).addToBlobList(ifxBblob.smb);
        }
        ifxBblob.setIfxLobType((short)0);
        ifxBblob.setSize(this.getBlobLength());
        return ifxBblob;
    }

    @Override
    public Clob toClob() throws SQLException {
        IfxCblob ifxCblob = null;
        if (this.tempBlobFile != null) {
            try {
                ifxCblob = new IfxCblob(this.tempBlobFile);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            ifxCblob = new IfxCblob((Connection)this.conn, this.blobBuffer);
        } else {
            return null;
        }
        ifxCblob.setLoadFlag();
        if (ifxCblob.smb != null) {
            ((IfxSqliConnect)this.conn).addToBlobList(ifxCblob.smb);
        }
        ifxCblob.setIfxLobType((short)1);
        ifxCblob.setSize(this.getBlobLength());
        return ifxCblob;
    }

    @Override
    public void fromBlob(Blob blob) {
        IfxBblob ifxBblob = (IfxBblob)blob;
        short s = ifxBblob.getIfxLobType();
        if (s == 2 || s == 0) {
            try {
                this.fromBinaryStream(ifxBblob.getStreamImd(), (int)blob.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void fromClob(Clob clob) {
        IfxCblob ifxCblob = (IfxCblob)clob;
        short s = ifxCblob.getIfxLobType();
        if (s == 3 || s == 1) {
            try {
                this.fromAsciiStream(ifxCblob.getStreamImd(), (int)clob.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void clear() {
        this.isBlob_loaded = false;
        this.ifxType = 0;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.blobBuffer = null;
        this.tempBlobFile = null;
        super.clear();
    }

    void g() {
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

