/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.CSMspwd;
import com.informix.asf.IfxASFException;
import com.informix.asf.IfxDataInputStream;
import com.informix.util.IfxErrMsg;
import java.io.BufferedInputStream;
import java.io.IOException;

public class CSMBufferedInputStream
extends BufferedInputStream {
    static final int STREAM_BUF_SIZE = 4098;
    static final int BLOCK_SIZE = 8;
    static final int SPWD_CSM_MSG_TYPE_DATA = 3;
    private CSMspwd CSMspwd = null;
    private IfxDataInputStream IfxIs = null;
    private byte[] messageArray;
    private byte[] decryptedDataBuf;
    private int decryptedDataBufSize;
    private int decryptedDataBufPos;
    private int decryptedDataBufLen;
    private String ClientLocale = null;

    public CSMBufferedInputStream(IfxDataInputStream ifxDataInputStream, CSMspwd cSMspwd) {
        super(ifxDataInputStream);
        this.CSMspwd = cSMspwd;
        this.IfxIs = ifxDataInputStream;
        this.decryptedDataBuf = new byte[4098];
        this.decryptedDataBufSize = 4098;
        this.decryptedDataBufPos = 0;
        this.decryptedDataBufLen = 0;
    }

    public CSMBufferedInputStream(IfxDataInputStream ifxDataInputStream, int n, CSMspwd cSMspwd) {
        super(ifxDataInputStream, n);
        this.CSMspwd = cSMspwd;
        this.IfxIs = ifxDataInputStream;
        this.decryptedDataBuf = new byte[4098];
        this.decryptedDataBufSize = 4098;
        this.decryptedDataBufPos = 0;
        this.decryptedDataBufLen = 0;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n != -1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.decryptedDataBufLen < n2) {
            this.fillDecryptedDataBuf(n2);
        }
        return this.copyOutData(byArray, n, n2);
    }

    @Override
    public long skip(long l2) throws IOException {
        if (this.decryptedDataBufLen < (int)l2) {
            this.fillDecryptedDataBuf((int)l2);
        }
        int n = this.decryptedDataBufLen < (int)l2 ? this.decryptedDataBufLen : (int)l2;
        this.decryptedDataBufPos += n;
        if (this.decryptedDataBufPos >= this.decryptedDataBufSize) {
            this.decryptedDataBufPos = 0;
        }
        this.decryptedDataBufLen -= n;
        return n;
    }

    @Override
    public int available() throws IOException {
        int n = this.IfxIs.available();
        if (n > 0) {
            this.fillDecryptedDataBuf(n);
        }
        return this.decryptedDataBufLen;
    }

    private void fillDecryptedDataBuf(int n) throws IOException {
        short s = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.decryptedDataBufLen < n && (s = this.IfxIs.readShort()) != -1) {
            if (s == 3) {
                this.readInDataToken();
                continue;
            }
            throw new IOException("JCSM protocol error.");
        }
    }

    private void readInDataToken() throws IOException {
        try {
            short s = this.IfxIs.readShort();
            short s2 = this.IfxIs.readShort();
            int n = s - 2;
            this.messageArray = new byte[n];
            int n2 = this.IfxIs.readFully(this.messageArray, 0, n);
            if (n2 < n) {
                throw new IOException("JCSM protocol error.");
            }
            byte[] byArray = new byte[n];
            this.CSMspwd.processInMessage(this.messageArray, byArray);
            this.copyInData(byArray, s2);
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getLocIOException(-5030, this.ClientLocale);
        }
    }

    private void copyInData(byte[] byArray, int n) {
        int n2 = this.decryptedDataBufLen + n;
        if (n2 > this.decryptedDataBufSize) {
            byte[] byArray2 = new byte[n2];
            this.decryptedDataBufSize = n2;
            System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, byArray2, 0, this.decryptedDataBufLen);
            System.arraycopy(byArray, 0, byArray2, this.decryptedDataBufLen, n);
            this.decryptedDataBuf = byArray2;
            this.decryptedDataBufPos = 0;
            this.decryptedDataBufLen = n2;
        } else if (this.decryptedDataBufPos + n2 >= this.decryptedDataBufSize) {
            System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, this.decryptedDataBuf, 0, this.decryptedDataBufLen);
            System.arraycopy(byArray, 0, this.decryptedDataBuf, this.decryptedDataBufLen, n);
            this.decryptedDataBufPos = 0;
            this.decryptedDataBufLen = n2;
        } else {
            System.arraycopy(byArray, 0, this.decryptedDataBuf, this.decryptedDataBufPos + this.decryptedDataBufLen, n);
            this.decryptedDataBufLen = n2;
        }
    }

    private int copyOutData(byte[] byArray, int n, int n2) {
        if (this.decryptedDataBufLen == 0) {
            return -1;
        }
        int n3 = n2 > this.decryptedDataBufLen ? this.decryptedDataBufLen : n2;
        System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, byArray, n, n3);
        this.decryptedDataBufPos += n3;
        if (this.decryptedDataBufPos >= this.decryptedDataBufSize) {
            this.decryptedDataBufPos = 0;
        }
        this.decryptedDataBufLen -= n3;
        return n3;
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

