/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetMain
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset";
    private Button autoFetchNextSegmentCheck;
    private Text resultSetSize;
    private Button resultSetUseSQLCheck;
    private Button serverSideOrderingCheck;
    private Button readQueryMetadata;
    private Button readQueryReferences;
    private Text queryCancelTimeout;
    private Button filterForceSubselect;
    private Button keepStatementOpenCheck;
    private Button alwaysUseAllColumns;
    private Button newRowsAfter;
    private Button refreshAfterUpdate;
    private Button useNavigatorFilters;
    private Button advUseFetchSize;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.autofetch.next.segment") || store.contains("resultset.maxrows") || store.contains("resultset.maxrows.sql") || store.contains("resultset.read.metadata") || store.contains("resultset.cancel.timeout") || store.contains("sql.query.filter.force.subselect") || store.contains("resultset.edit.key.use_all_columns") || store.contains("resultset.edit.new.row.after") || store.contains("resultset.edit.refreshAfterUpdate") || store.contains("keep.statement.open") || store.contains("resultset.order.serverSide") || store.contains("resultset.fetch.size") || store.contains("resultset.filter.use.navigator");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group queriesGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_queries, (int)2, (int)0, (int)0);
        queriesGroup.setLayoutData((Object)new GridData(2));
        this.resultSetSize = UIUtils.createLabelText((Composite)queriesGroup, (String)CoreMessages.pref_page_database_general_label_result_set_max_size, (String)"0", (int)2048);
        this.resultSetSize.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.autoFetchNextSegmentCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_resultsets_label_auto_fetch_segment, null, (boolean)true, (int)2);
        this.resultSetUseSQLCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_resultsets_label_use_sql, null, (boolean)false, (int)2);
        this.serverSideOrderingCheck = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_resultsets_label_server_side_order, null, (boolean)false, (int)2);
        this.readQueryMetadata = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_resultsets_label_read_metadata, (String)CoreMessages.pref_page_database_resultsets_label_read_metadata_tip, (boolean)false, (int)2);
        this.readQueryReferences = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_resultsets_label_read_references, (String)CoreMessages.pref_page_database_resultsets_label_read_references_tip, (boolean)false, (int)2);
        this.queryCancelTimeout = UIUtils.createLabelText((Composite)queriesGroup, (String)CoreMessages.pref_page_database_general_label_result_set_cancel_timeout, (String)"0");
        this.queryCancelTimeout.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.queryCancelTimeout.setToolTipText(CoreMessages.pref_page_database_general_label_result_set_cancel_timeout_tip);
        this.queryCancelTimeout.setEnabled(false);
        this.filterForceSubselect = UIUtils.createCheckbox((Composite)queriesGroup, (String)CoreMessages.pref_page_database_resultsets_label_filter_force_subselect, (String)CoreMessages.pref_page_database_resultsets_label_filter_force_subselect_tip, (boolean)false, (int)2);
        this.readQueryMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetMain.this.updateOptionsEnablement();
            }
        });
        Group miscGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_sql_editor_group_misc, (int)1, (int)2, (int)0);
        this.keepStatementOpenCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.pref_page_database_general_checkbox_keep_cursor, (boolean)false);
        this.alwaysUseAllColumns = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.pref_page_content_editor_checkbox_keys_always_use_all_columns, (boolean)false);
        this.newRowsAfter = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.pref_page_content_editor_checkbox_new_rows_after, (boolean)false);
        this.refreshAfterUpdate = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.pref_page_content_editor_checkbox_refresh_after_update, (boolean)false);
        this.useNavigatorFilters = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.pref_page_content_editor_checkbox_use_navigator_filters, (String)CoreMessages.pref_page_content_editor_checkbox_use_navigator_filters_tip, (boolean)false, (int)1);
        Group advGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_results_group_advanced, (int)1, (int)2, (int)0);
        this.advUseFetchSize = UIUtils.createCheckbox((Composite)advGroup, (String)CoreMessages.pref_page_database_resultsets_label_fetch_size, (String)CoreMessages.pref_page_database_resultsets_label_fetch_size_tip, (boolean)false, (int)1);
        return composite;
    }

    private void updateOptionsEnablement() {
        this.readQueryReferences.setEnabled(this.readQueryMetadata.isEnabled() && this.readQueryMetadata.getSelection());
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.autoFetchNextSegmentCheck.setSelection(store.getBoolean("resultset.autofetch.next.segment"));
            this.resultSetSize.setText(store.getString("resultset.maxrows"));
            this.resultSetUseSQLCheck.setSelection(store.getBoolean("resultset.maxrows.sql"));
            this.serverSideOrderingCheck.setSelection(store.getBoolean("resultset.order.serverSide"));
            this.readQueryMetadata.setSelection(store.getBoolean("resultset.read.metadata"));
            this.readQueryReferences.setSelection(store.getBoolean("resultset.read.references"));
            this.queryCancelTimeout.setText(store.getString("resultset.cancel.timeout"));
            this.filterForceSubselect.setSelection(store.getBoolean("sql.query.filter.force.subselect"));
            this.keepStatementOpenCheck.setSelection(store.getBoolean("keep.statement.open"));
            this.alwaysUseAllColumns.setSelection(store.getBoolean("resultset.edit.key.use_all_columns"));
            this.newRowsAfter.setSelection(store.getBoolean("resultset.edit.new.row.after"));
            this.refreshAfterUpdate.setSelection(store.getBoolean("resultset.edit.refreshAfterUpdate"));
            this.useNavigatorFilters.setSelection(store.getBoolean("resultset.filter.use.navigator"));
            this.advUseFetchSize.setSelection(store.getBoolean("resultset.fetch.size"));
            this.updateOptionsEnablement();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.autofetch.next.segment", this.autoFetchNextSegmentCheck.getSelection());
            store.setValue("resultset.maxrows", this.resultSetSize.getText());
            store.setValue("resultset.maxrows.sql", this.resultSetUseSQLCheck.getSelection());
            store.setValue("resultset.order.serverSide", this.serverSideOrderingCheck.getSelection());
            store.setValue("resultset.read.metadata", this.readQueryMetadata.getSelection());
            store.setValue("resultset.read.references", this.readQueryReferences.getSelection());
            store.setValue("resultset.cancel.timeout", this.queryCancelTimeout.getText());
            store.setValue("sql.query.filter.force.subselect", this.filterForceSubselect.getSelection());
            store.setValue("keep.statement.open", this.keepStatementOpenCheck.getSelection());
            store.setValue("resultset.edit.key.use_all_columns", this.alwaysUseAllColumns.getSelection());
            store.setValue("resultset.edit.new.row.after", this.newRowsAfter.getSelection());
            store.setValue("resultset.edit.refreshAfterUpdate", this.refreshAfterUpdate.getSelection());
            store.setValue("resultset.filter.use.navigator", this.useNavigatorFilters.getSelection());
            store.setValue("resultset.fetch.size", this.advUseFetchSize.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.autofetch.next.segment");
        store.setToDefault("resultset.maxrows");
        store.setToDefault("resultset.maxrows.sql");
        store.setToDefault("resultset.order.serverSide");
        store.setToDefault("resultset.read.metadata");
        store.setToDefault("resultset.read.references");
        store.setToDefault("resultset.cancel.timeout");
        store.setToDefault("sql.query.filter.force.subselect");
        store.setToDefault("keep.statement.open");
        store.setToDefault("resultset.edit.key.use_all_columns");
        store.setToDefault("resultset.edit.new.row.after");
        store.setToDefault("resultset.edit.refreshAfterUpdate");
        store.setToDefault("resultset.filter.use.navigator");
        store.setToDefault("resultset.fetch.size");
        this.updateOptionsEnablement();
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

