/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.indent;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLHeuristicScanner;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLIndenter;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final Log log = Log.getLog(SQLAutoIndentStrategy.class);
    private static final int MINIMUM_SOUCE_CODE_LENGTH = 10;
    private String partitioning;
    private SQLSyntaxManager syntaxManager;
    private Map<Integer, String> autoCompletionMap = new HashMap<Integer, String>();
    private String[] delimiters;

    public SQLAutoIndentStrategy(String partitioning, SQLSyntaxManager syntaxManager) {
        this.partitioning = partitioning;
        this.syntaxManager = syntaxManager;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.offset < 0) {
            return;
        }
        if (command.text != null && command.text.length() > 10) {
            if (this.syntaxManager.getPreferenceStore().getBoolean("SQLEditor.format.extractFromSource")) {
                this.transformSourceCode(document, command);
            }
        } else if (command.length == 0 && command.text != null) {
            boolean lineDelimiter = this.isLineDelimiter(document, command.text);
            try {
                boolean isPrevLetter = command.offset > 0 && Character.isJavaIdentifierPart(document.getChar(command.offset - 1));
                boolean isQuote = this.isQuoteString(command.text);
                if (command.offset > 1 && isPrevLetter && !isQuote && (lineDelimiter || command.text.length() == 1 && !Character.isJavaIdentifierPart(command.text.charAt(0))) && this.syntaxManager.getPreferenceStore().getBoolean("SQLEditor.format.keywordCaseAuto")) {
                    this.updateKeywordCase(document, command);
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
            if (lineDelimiter) {
                this.smartIndentAfterNewLine(document, command);
            }
        }
    }

    private boolean isQuoteString(String str) {
        String[][] stringArray = this.syntaxManager.getQuoteStrings();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] qs = stringArray[n2];
            if (str.equals(qs[0]) || str.equals(qs[0])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean transformSourceCode(IDocument document, DocumentCommand command) {
        char ch;
        String sourceCode = command.text;
        int quoteStart = -1;
        int quoteEnd = -1;
        int i = 0;
        while (i < sourceCode.length()) {
            ch = sourceCode.charAt(i);
            if (ch == '\"') {
                quoteStart = i;
                break;
            }
            if (Character.isUnicodeIdentifierPart(ch) || ch == '{' || ch == '<' || ch == '[') {
                return false;
            }
            ++i;
        }
        i = sourceCode.length() - 1;
        while (i >= 0) {
            ch = sourceCode.charAt(i);
            if (ch == '\"') {
                quoteEnd = i;
                break;
            }
            if (Character.isUnicodeIdentifierPart(ch)) {
                return false;
            }
            --i;
        }
        if (quoteStart == -1 || quoteEnd == -1) {
            return false;
        }
        boolean hasWhitespaces = false;
        int i2 = quoteStart + 1;
        while (i2 < quoteEnd) {
            if (Character.isWhitespace(sourceCode.charAt(i2))) {
                hasWhitespaces = true;
                break;
            }
            ++i2;
        }
        if (!hasWhitespaces) {
            return false;
        }
        StringBuilder result = new StringBuilder(sourceCode.length());
        int prevChar = 65535;
        char escapeChar = '\\';
        boolean inString = false;
        boolean inComment = false;
        CommentType commentType = CommentType.Unknown;
        int i3 = quoteStart;
        while (i3 < quoteEnd) {
            char ch2;
            block42: {
                block40: {
                    block41: {
                        ch2 = sourceCode.charAt(i3);
                        if (!inString) break block40;
                        if (prevChar != escapeChar) break block41;
                        switch (ch2) {
                            case 'n': {
                                if (!this.endsWithLF(result)) {
                                    result.append("\n");
                                    break;
                                }
                                break block42;
                            }
                            case 'r': {
                                if (!this.endsWithLF(result)) {
                                    result.append("\r");
                                    break;
                                }
                                break block42;
                            }
                            case 't': {
                                result.append("\t");
                                break;
                            }
                            default: {
                                result.append(ch2);
                                break;
                            }
                        }
                        break block42;
                    }
                    switch (ch2) {
                        case '\"': {
                            inString = false;
                            break;
                        }
                        default: {
                            if (ch2 != escapeChar) {
                                if (inString) {
                                    result.append(ch2);
                                    break;
                                }
                                if (ch2 == '\n' && result.length() > 0 && !this.endsWithLF(result)) {
                                    result.append(ch2);
                                    break;
                                }
                            }
                            break block42;
                        }
                    }
                    break block42;
                }
                if (inComment) {
                    if (commentType == CommentType.Unknown && prevChar == 47 && ch2 == '*') {
                        commentType = CommentType.Block;
                    } else if (commentType == CommentType.Unknown && prevChar == 47 && ch2 == '/') {
                        commentType = CommentType.EndOfLine;
                    } else if (commentType == CommentType.Block && prevChar == 42 && ch2 == '/') {
                        inComment = false;
                    } else if (commentType == CommentType.EndOfLine && ch2 == '\n') {
                        inComment = false;
                    }
                } else {
                    switch (ch2) {
                        case '/': {
                            inComment = true;
                            commentType = CommentType.Unknown;
                            break;
                        }
                        case '\"': {
                            inString = true;
                            break;
                        }
                        case '\n': {
                            if (result.length() <= 0 || result.charAt(result.length() - 1) == '\n') break;
                            result.append("\n");
                        }
                    }
                }
            }
            prevChar = ch2;
            ++i3;
        }
        try {
            document.replace(command.offset, command.length, command.text);
            document.replace(command.offset, command.text.length(), result.toString());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        command.caretOffset = command.offset + result.length();
        command.text = null;
        command.length = 0;
        command.doit = false;
        return true;
    }

    private boolean endsWithLF(StringBuilder result) {
        boolean endsWithLF = false;
        int k = result.length();
        while (k > 0) {
            char lch = result.charAt(k - 1);
            if (!Character.isWhitespace(lch)) break;
            if (lch == '\n' || lch == '\r') {
                endsWithLF = true;
                break;
            }
            --k;
        }
        return endsWithLF;
    }

    private boolean updateKeywordCase(IDocument document, DocumentCommand command) throws BadLocationException {
        String fixedKeyword;
        String commandPrefix = this.syntaxManager.getControlCommandPrefix();
        int pos = command.offset - 1;
        while (pos >= 0 && Character.isWhitespace(document.getChar(pos))) {
            --pos;
        }
        int endPos = pos + 1;
        while (pos >= 0) {
            char ch = document.getChar(pos);
            if (!Character.isJavaIdentifierPart(ch) && commandPrefix.indexOf(ch) == -1) break;
            --pos;
        }
        int startPos = pos + 1;
        String keyword = document.get(startPos, endPos - startPos);
        if (this.syntaxManager.getDialect().getKeywordType(keyword) == DBPKeywordType.KEYWORD && !(fixedKeyword = this.syntaxManager.getKeywordCase().transform(keyword)).equals(keyword)) {
            command.addCommand(startPos, endPos - startPos, fixedKeyword, null);
            command.doit = false;
            return true;
        }
        return false;
    }

    private void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        String indent;
        this.clearCachedValues();
        int docLength = document.getLength();
        if (docLength == 0) {
            return;
        }
        SQLHeuristicScanner scanner = new SQLHeuristicScanner(document, this.syntaxManager);
        SQLIndenter indenter = new SQLIndenter(document, scanner);
        int previousToken = scanner.previousToken(command.offset - 1, -2);
        int nextToken = scanner.nextToken(command.offset, -2);
        String beginIndentaion = "";
        if (this.isSupportedAutoCompletionToken(previousToken)) {
            indent = indenter.computeIndentation(command.offset);
            beginIndentaion = indenter.getReferenceIndentation(command.offset);
        } else {
            indent = nextToken == 1002 || nextToken == 1003 ? indenter.getReferenceIndentation(command.offset + 1) : indenter.getReferenceIndentation(command.offset);
        }
        if (indent == null) {
            indent = "";
        }
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuilder buf = new StringBuilder(String.valueOf(command.text) + indent);
            IRegion reg = document.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(document, command.offset, lineEnd);
            command.length = Math.max(contentStart - command.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)start, (boolean)true);
            if ("sql_multiline_comment".equals(region.getType())) {
                start = document.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            command.caretOffset = command.offset + buf.length();
            command.shiftsCaret = false;
            if (this.isSupportedAutoCompletionToken(previousToken) && !this.isClosed(document, command.offset, previousToken) && this.getTokenCount(start, command.offset, scanner, previousToken) > 0) {
                buf.append(SQLAutoIndentStrategy.getLineDelimiter(document));
                buf.append(beginIndentaion);
                buf.append(this.getAutoCompletionTrail(previousToken));
            }
            command.text = buf.toString();
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return GeneralUtils.getDefaultLineSeparator();
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        if (this.delimiters == null) {
            this.delimiters = document.getLegalLineDelimiters();
        }
        return this.delimiters != null && TextUtilities.equals((String[])this.delimiters, (String)text) > -1;
    }

    private void clearCachedValues() {
        this.autoCompletionMap.clear();
        DBPPreferenceStore preferenceStore = DBeaverCore.getGlobalPreferenceStore();
        boolean closeBeginEnd = preferenceStore.getBoolean("SQLEditor.closeBeginEndStatement");
        if (closeBeginEnd) {
            this.autoCompletionMap.put(1000, "end");
            this.autoCompletionMap.put(1001, "END");
        }
    }

    private boolean isSupportedAutoCompletionToken(int token) {
        return this.autoCompletionMap.containsKey(token);
    }

    private String getAutoCompletionTrail(int token) {
        return this.autoCompletionMap.get(token);
    }

    private int getTokenCount(int startOffset, int endOffset, SQLHeuristicScanner scanner, int token) {
        int tokenCount = 0;
        while (startOffset < endOffset) {
            int nextToken = scanner.nextToken(startOffset, endOffset);
            int position = scanner.getPosition();
            if (nextToken != -1 && scanner.isSameToken(nextToken, token)) {
                ++tokenCount;
            }
            startOffset = position;
        }
        return tokenCount;
    }

    private boolean isClosed(IDocument document, int offset, int token) {
        if (token == 1001 || token == 1000) {
            return this.getBlockBalance(document, offset) <= 0;
        }
        return false;
    }

    private int getBlockBalance(IDocument document, int offset) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset;
        SQLHeuristicScanner scanner = new SQLHeuristicScanner(document, this.syntaxManager);
        do {
            begin = scanner.findOpeningPeer(begin, 1001, 1003);
            end = scanner.findClosingPeer(end, 1001, 1003);
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }

    private static enum CommentType {
        Unknown,
        Block,
        EndOfLine;

    }
}

