/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.format.tokenized;

import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.format.BaseFormatterConfigurationPage;
import org.jkiss.utils.CommonUtils;

public class SQLTokenizedFormatterConfigurationPage
extends BaseFormatterConfigurationPage {
    private Spinner indentSizeSpinner;
    private Button useSpacesCheck;
    private Combo keywordCaseCombo;
    private Button lineFeedBeforeCommaCheck;
    private Button breakLineBeforeCloseBracket;

    @Override
    protected Composite createFormatSettings(Composite parent) {
        Group settings = UIUtils.createControlGroup((Composite)parent, (String)CoreMessages.pref_page_sql_format_label_settings, (int)5, (int)768, (int)0);
        this.keywordCaseCombo = UIUtils.createLabelCombo((Composite)settings, (String)CoreMessages.pref_page_sql_format_label_keyword_case, (int)12);
        this.keywordCaseCombo.setLayoutData((Object)new GridData(32));
        this.keywordCaseCombo.add("Default");
        DBPIdentifierCase[] dBPIdentifierCaseArray = DBPIdentifierCase.values();
        int n = dBPIdentifierCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPIdentifierCase c = dBPIdentifierCaseArray[n2];
            this.keywordCaseCombo.add(DBPIdentifierCase.capitalizeCaseName((String)c.name()));
            ++n2;
        }
        this.indentSizeSpinner = UIUtils.createLabelSpinner((Composite)settings, (String)CoreMessages.pref_page_sql_format_label_indent_size, (String)CoreMessages.pref_page_sql_format_label_indent_size, (int)4, (int)0, (int)100);
        this.useSpacesCheck = UIUtils.createCheckbox((Composite)settings, (String)CoreMessages.pref_page_sql_format_label_insert_spaces_for_tabs, (String)CoreMessages.pref_page_sql_format_label_insert_spaces_for_tabs, (boolean)true, (int)1);
        this.lineFeedBeforeCommaCheck = UIUtils.createCheckbox((Composite)settings, (String)CoreMessages.pref_page_sql_format_label_insert_line_feed_before_commas, (String)CoreMessages.pref_page_sql_format_label_insert_line_feed_before_commas, (boolean)true, (int)5);
        this.breakLineBeforeCloseBracket = UIUtils.createCheckbox((Composite)settings, (String)CoreMessages.pref_page_sql_format_label_add_line_feed_before_close_bracket, (String)CoreMessages.pref_page_sql_format_label_add_line_feed_before_close_bracket, (boolean)true, (int)5);
        return parent;
    }

    private IPreferenceStore getTextEditorsPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public void loadSettings(DBPPreferenceStore preferenceStore) {
        DBPIdentifierCase keywordCase;
        super.loadSettings(preferenceStore);
        String caseName = preferenceStore.getString("sql.format.keywordCase");
        DBPIdentifierCase dBPIdentifierCase = keywordCase = CommonUtils.isEmpty((String)caseName) ? null : DBPIdentifierCase.valueOf((String)caseName);
        if (keywordCase == null) {
            this.keywordCaseCombo.select(0);
        } else {
            UIUtils.setComboSelection((Combo)this.keywordCaseCombo, (String)DBPIdentifierCase.capitalizeCaseName((String)keywordCase.name()));
        }
        this.lineFeedBeforeCommaCheck.setSelection(preferenceStore.getBoolean("sql.format.lf.before.comma"));
        this.breakLineBeforeCloseBracket.setSelection(preferenceStore.getBoolean("sql.format.break.before.close.bracket"));
        IPreferenceStore textEditorPrefs = this.getTextEditorsPreferenceStore();
        this.indentSizeSpinner.setSelection(textEditorPrefs.getInt("tabWidth"));
        this.useSpacesCheck.setSelection(textEditorPrefs.getBoolean("spacesForTabs"));
    }

    @Override
    public void saveSettings(DBPPreferenceStore preferenceStore) {
        super.saveSettings(preferenceStore);
        String caseName = this.keywordCaseCombo.getSelectionIndex() == 0 ? "" : this.keywordCaseCombo.getText().toUpperCase(Locale.ENGLISH);
        preferenceStore.setValue("sql.format.keywordCase", caseName);
        preferenceStore.setValue("sql.format.lf.before.comma", this.lineFeedBeforeCommaCheck.getSelection());
        preferenceStore.setValue("sql.format.break.before.close.bracket", this.breakLineBeforeCloseBracket.getSelection());
        IPreferenceStore textEditorPrefs = this.getTextEditorsPreferenceStore();
        textEditorPrefs.setValue("tabWidth", this.indentSizeSpinner.getSelection());
        textEditorPrefs.setValue("spacesForTabs", this.useSpacesCheck.getSelection());
    }

    @Override
    public void resetSettings(DBPPreferenceStore preferenceStore) {
        super.resetSettings(preferenceStore);
        preferenceStore.setToDefault("sql.format.keywordCase");
        preferenceStore.setToDefault("sql.format.lf.before.comma");
    }
}

