/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class CreateProcedurePage
extends BaseObjectEditPage {
    private DBSObjectContainer container;
    private String name;
    private DBSProcedureType type;

    public CreateProcedurePage(DBSObjectContainer container) {
        super(CoreMessages.dialog_struct_create_procedure_title);
        this.container = container;
    }

    @Override
    protected Control createPageContents(Composite parent) {
        Composite propsGroup = new Composite(parent, 0);
        propsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        propsGroup.setLayoutData((Object)gd);
        Text containerText = UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_struct_create_procedure_container, (String)DBUtils.getObjectFullName((DBPNamedObject)this.container, (DBPEvaluationContext)DBPEvaluationContext.UI));
        containerText.setEditable(false);
        Text nameText = UIUtils.createLabelText((Composite)propsGroup, (String)CoreMessages.dialog_struct_create_procedure_label_name, null);
        nameText.addModifyListener(e -> {
            this.name = nameText.getText();
            this.updatePageState();
        });
        if (this.getPredefinedProcedureType() == null) {
            Combo typeCombo = UIUtils.createLabelCombo((Composite)propsGroup, (String)CoreMessages.dialog_struct_create_procedure_combo_type, (int)12);
            typeCombo.add(DBSProcedureType.PROCEDURE.name());
            typeCombo.add(DBSProcedureType.FUNCTION.name());
            typeCombo.addModifyListener(e -> {
                this.type = typeCombo.getSelectionIndex() == 0 ? DBSProcedureType.PROCEDURE : DBSProcedureType.FUNCTION;
            });
            typeCombo.select(0);
        }
        propsGroup.setTabList((Control[])ArrayUtils.remove(Control.class, (Object[])propsGroup.getTabList(), (Object)containerText));
        this.createExtraControls(propsGroup);
        return propsGroup;
    }

    protected void createExtraControls(Composite group) {
    }

    public DBSProcedureType getProcedureType() {
        DBSProcedureType procedureType = this.getPredefinedProcedureType();
        return procedureType == null ? this.type : procedureType;
    }

    public DBSProcedureType getPredefinedProcedureType() {
        return null;
    }

    public String getProcedureName() {
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)this.container.getDataSource(), (String)this.name);
    }

    @Override
    public boolean isPageComplete() {
        return !CommonUtils.isEmpty((String)this.name);
    }
}

