/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SaveChangesHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(SaveChangesHandler.class);

    public static boolean validateAndSave(DBRProgressMonitor monitor, ISaveablePart saveable) {
        if (!saveable.isDirty()) {
            return true;
        }
        SaveRunner saveRunner = new SaveRunner(monitor, saveable);
        UIUtils.syncExec((Runnable)saveRunner);
        return saveRunner.getResult();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final EntityEditor editor = (EntityEditor)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), EntityEditor.class);
        if (editor != null) {
            try {
                UIUtils.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SaveChangesHandler.validateAndSave(monitor, (ISaveablePart)editor);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class SaveRunner
    implements Runnable {
        private final DBRProgressMonitor monitor;
        private final ISaveablePart saveable;
        private boolean result;

        private SaveRunner(DBRProgressMonitor monitor, ISaveablePart saveable) {
            this.monitor = monitor;
            this.saveable = saveable;
        }

        public boolean getResult() {
            return this.result;
        }

        @Override
        public void run() {
            int choice = -1;
            if (this.saveable instanceof ISaveablePart2) {
                choice = ((ISaveablePart2)this.saveable).promptToSaveOnClose();
            }
            if (!this.saveable.isDirty()) {
                return;
            }
            if (choice == -1 || choice == 3) {
                String saveableName;
                Shell shell;
                if (this.saveable instanceof IWorkbenchPart) {
                    shell = ((IWorkbenchPart)this.saveable).getSite().getShell();
                    saveableName = ((IWorkbenchPart)this.saveable).getTitle();
                } else {
                    shell = UIUtils.getActiveWorkbenchShell();
                    saveableName = CommonUtils.toString((Object)this.saveable);
                }
                int confirmResult = ConfirmationDialog.showConfirmDialog(shell, "close_editor_edit", 6, saveableName);
                switch (confirmResult) {
                    case 2: {
                        choice = 0;
                        break;
                    }
                    case 3: {
                        choice = 1;
                        break;
                    }
                    default: {
                        choice = 2;
                    }
                }
            }
            switch (choice) {
                case 0: {
                    this.saveable.doSave(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)this.monitor));
                    if (this.saveable.isDirty()) {
                        log.debug((Object)("Saveable '" + this.saveable + "' is still dirty after save"));
                    }
                    this.result = true;
                    break;
                }
                case 1: {
                    this.result = true;
                    break;
                }
                default: {
                    this.result = false;
                }
            }
        }
    }
}

