/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.actions.common.ContextSearchAction;

public class EditorSearchActionsContributor
extends MultiPageEditorActionBarContributor {
    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (!(part instanceof MultiPageEditorPart)) {
            EditorSearchActionsContributor.registerSearchActions(part);
        }
    }

    public void setActivePage(IEditorPart activeEditor) {
        EditorSearchActionsContributor.registerSearchActions(activeEditor);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
    }

    public static void registerSearchActions(IEditorPart activeEditor) {
        if (activeEditor == null) {
            return;
        }
        IActionBars actionBars = activeEditor.getEditorSite().getActionBars();
        ISearchContextProvider provider = (ISearchContextProvider)DBUtils.getAdapter(ISearchContextProvider.class, (Object)activeEditor);
        if (provider != null) {
            if (provider.isSearchPossible()) {
                ContextSearchAction findAction = new ContextSearchAction(provider, ISearchContextProvider.SearchType.NONE);
                findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
                actionBars.setGlobalActionHandler("org.eclipse.ui.edit.findReplace", (IAction)findAction);
                ContextSearchAction findNextAction = new ContextSearchAction(provider, ISearchContextProvider.SearchType.NEXT);
                findNextAction.setActionDefinitionId("org.eclipse.ui.edit.findNext");
                actionBars.setGlobalActionHandler("org.eclipse.ui.edit.findNext", (IAction)findNextAction);
                ContextSearchAction findPrevAction = new ContextSearchAction(provider, ISearchContextProvider.SearchType.PREVIOUS);
                findPrevAction.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
                actionBars.setGlobalActionHandler("org.eclipse.ui.edit.findPrevious", (IAction)findPrevAction);
            }
        } else {
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.findReplace", null);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.findNext", null);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.findPrevious", null);
        }
        actionBars.updateActionBars();
    }
}

