/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class AbstractPopupPanel
extends Dialog {
    private final String title;
    private boolean modeless;

    protected AbstractPopupPanel(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isModeless() {
        return this.modeless;
    }

    public void setModeless(boolean modeless) {
        this.modeless = modeless;
        if (modeless) {
            this.setShellStyle(1264);
        } else {
            this.setShellStyle(68720);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createButtonBar(Composite parent) {
        if (this.modeless) {
            return UIUtils.createPlaceholder((Composite)parent, (int)1);
        }
        return super.createButtonBar(parent);
    }

    protected void closeOnFocusLost(Control ... controls) {
        if (this.modeless) {
            FocusAdapter focusListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    UIUtils.asyncExec(() -> {
                        if (AbstractPopupPanel.this.getShell() != null && !UIUtils.isParent((Control)AbstractPopupPanel.this.getShell(), (Control)AbstractPopupPanel.this.getShell().getDisplay().getFocusControl())) {
                            AbstractPopupPanel.this.cancelPressed();
                        }
                    });
                }
            };
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                if (ctrl != null) {
                    ctrl.addFocusListener((FocusListener)focusListener);
                }
                ++n2;
            }
        }
    }
}

