/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.utils.CommonUtils;

public class ValueManagerDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(ValueManagerDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataManager";
    public static final String TAG_MANAGER = "manager";
    public static final String TAG_SUPPORTS = "supports";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TYPE_NAME = "typeName";
    private static final String ATTR_DATA_SOURCE = "dataSource";
    private static final String ATTR_EXTENSION = "extension";
    private String id;
    private AbstractDescriptor.ObjectType implType;
    private final List<SupportInfo> supportInfos = new ArrayList<SupportInfo>();
    private IValueManager instance;

    public ValueManagerDescriptor(IConfigurationElement config) {
        super(config);
        IConfigurationElement[] typeElements;
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        IConfigurationElement[] iConfigurationElementArray = typeElements = config.getChildren(TAG_SUPPORTS);
        int n = typeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement typeElement = iConfigurationElementArray[n2];
            String kindName = typeElement.getAttribute(ATTR_KIND);
            String typeName = typeElement.getAttribute(ATTR_TYPE_NAME);
            String className = typeElement.getAttribute(ATTR_TYPE);
            String ext = typeElement.getAttribute(ATTR_EXTENSION);
            String dspId = typeElement.getAttribute(ATTR_DATA_SOURCE);
            if (!(CommonUtils.isEmpty((String)kindName) && CommonUtils.isEmpty((String)typeName) && CommonUtils.isEmpty((String)className) && CommonUtils.isEmpty((String)dspId) && CommonUtils.isEmpty((String)ext))) {
                SupportInfo info = new SupportInfo();
                if (!CommonUtils.isEmpty((String)kindName)) {
                    try {
                        info.dataKind = DBPDataKind.valueOf((String)kindName);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)("Bad data kind: " + kindName));
                    }
                }
                if (!CommonUtils.isEmpty((String)typeName)) {
                    info.typeName = typeName;
                }
                if (!CommonUtils.isEmpty((String)className)) {
                    info.valueType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, typeElement, ATTR_TYPE);
                }
                if (!CommonUtils.isEmpty((String)ext)) {
                    info.extension = ext;
                }
                if (!CommonUtils.isEmpty((String)dspId)) {
                    info.dataSource = dspId;
                }
                this.supportInfos.add(info);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public IValueManager getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (IValueManager)this.implType.createInstance(IValueManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't instantiate value manager '" + this.id + "'", e);
            }
        }
        return this.instance;
    }

    public boolean supportsType(@Nullable DBPDataSource dataSource, DBSTypedObject typedObject, Class<?> valueType, boolean checkDataSource, boolean checkType) {
        DBPDataKind dataKind = typedObject.getDataKind();
        for (SupportInfo info : this.supportInfos) {
            Object dataType;
            DriverDescriptor driver;
            if (dataSource == null || info.dataSource == null ? checkDataSource : !info.dataSource.equals((driver = (DriverDescriptor)dataSource.getContainer().getDriver()).getProviderId()) && !info.dataSource.equals(dataSource.getClass().getName())) continue;
            if (info.typeName != null && info.typeName.equalsIgnoreCase(typedObject.getTypeName())) {
                return true;
            }
            if (info.valueType != null) {
                if (info.valueType.matchesType(valueType) && info.dataKind == null || info.dataKind == dataKind) {
                    return true;
                }
            } else if (checkType) continue;
            if (info.dataKind != null && info.dataKind == dataKind) {
                return true;
            }
            if (info.extension != null && (dataType = typedObject instanceof DBSDataType ? (DBSDataType)typedObject : (typedObject instanceof DBSTypedObjectEx ? ((DBSTypedObjectEx)typedObject).getDataType() : null)) != null && CommonUtils.equalObjects((Object)info.extension, (Object)CommonUtils.toString((Object)dataType.geTypeExtension()))) {
                return true;
            }
            if (checkType || info.valueType != null || info.dataKind != null || info.typeName != null || info.extension != null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    private static class SupportInfo {
        String typeName;
        DBPDataKind dataKind;
        AbstractDescriptor.ObjectType valueType;
        String extension;
        String dataSource;

        private SupportInfo() {
        }
    }
}

