/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.stream;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.action.IContributionManager;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.controls.imageview.ImageViewer;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IValueController;

public class ImagePanelEditor
implements IStreamValueEditor<ImageViewer> {
    @Override
    public ImageViewer createControl(IValueController valueController) {
        return new ImageViewer(valueController.getEditPlaceholder(), 0);
    }

    @Override
    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, final @NotNull ImageViewer control, @NotNull DBDContent value) throws DBException {
        block13: {
            monitor.subTask("Read image value");
            DBDContentStorage data = value.getContents(monitor);
            if (data != null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (final InputStream contentStream = data.getContentStream();){
                        if (!((Boolean)new UITask<Boolean>(){

                            protected Boolean runTask() {
                                return control.loadImage(contentStream);
                            }
                        }.execute()).booleanValue()) {
                            throw new DBException("Can't load image: " + control.getLastError().getMessage());
                        }
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new DBException("Error reading stream value", (Throwable)e);
                }
            }
            control.clearImage();
        }
    }

    @Override
    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull ImageViewer control, @NotNull DBDContent value) throws DBException {
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull ImageViewer control) throws DBCException {
        control.fillToolBar(manager);
    }

    @Override
    public void contributeSettings(@NotNull IContributionManager manager, @NotNull ImageViewer control) throws DBCException {
    }
}

