/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ToolbarSeparatorContribution;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;
import org.jkiss.dbeaver.ui.controls.resultset.ActiveStatusMessage;
import org.jkiss.dbeaver.ui.controls.resultset.ColorSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.DataFilterRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.FilterSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetFilterManager;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IStatefulControl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataReceiver;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetFilterPanel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetJobDataRead;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPanelDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPersister;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPropertyTester;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetReferenceMenu;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.StatusLabel;
import org.jkiss.dbeaver.ui.controls.resultset.TransformerSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.ValidateUniqueKeyUsageDialog;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.FilterValueEditDialog;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.FilterValueEditPopup;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.view.StatisticsPresentation;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetViewer
extends Viewer
implements DBPContextProvider,
IResultSetController,
ISaveablePart2,
IAdaptable {
    private static final Log log = Log.getLog(ResultSetViewer.class);
    private static final String TOOLBAR_GROUP_NAVIGATION = "navigation";
    private static final String TOOLBAR_GROUP_PRESENTATIONS = "presentations";
    private static final String TOOLBAR_GROUP_ADDITIONS = "additions";
    private static final String SETTINGS_SECTION_PRESENTATIONS = "presentations";
    private static final String TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.controls.resultset.status";
    static final String CONTROL_ID = ResultSetViewer.class.getSimpleName();
    private static final DecimalFormat ROW_COUNT_FORMAT = new DecimalFormat("###,###,###,###,###,##0");
    private static final IResultSetListener[] EMPTY_LISTENERS = new IResultSetListener[0];
    private IResultSetFilterManager filterManager;
    @NotNull
    private final IWorkbenchPartSite site;
    private final Composite viewerPanel;
    private final IResultSetDecorator decorator;
    @Nullable
    private ResultSetFilterPanel filtersPanel;
    private SashForm viewerSash;
    private CTabFolder panelFolder;
    private ToolBarManager panelToolBar;
    private final Composite presentationPanel;
    private final List<ToolBarManager> toolbarList = new ArrayList<ToolBarManager>();
    private Composite statusBar;
    private StatusLabel statusLabel;
    private ActiveStatusMessage rowCountLabel;
    private final DynamicFindReplaceTarget findReplaceTarget;
    private IResultSetPresentation activePresentation;
    private ResultSetPresentationDescriptor activePresentationDescriptor;
    private List<ResultSetPresentationDescriptor> availablePresentations;
    private ToolBar presentationSwitchToolbar;
    private final List<ResultSetPanelDescriptor> availablePanels = new ArrayList<ResultSetPanelDescriptor>();
    private final Map<ResultSetPresentationDescriptor, PresentationSettings> presentationSettings = new HashMap<ResultSetPresentationDescriptor, PresentationSettings>();
    private final Map<String, IResultSetPanel> activePanels = new HashMap<String, IResultSetPanel>();
    private final Map<String, ToolBarManager> activeToolBars = new HashMap<String, ToolBarManager>();
    @NotNull
    private final IResultSetContainer container;
    @NotNull
    private final ResultSetDataReceiver dataReceiver;
    @Nullable
    private ResultSetRow curRow;
    private boolean recordMode;
    private final List<IResultSetListener> listeners = new ArrayList<IResultSetListener>();
    private volatile ResultSetJobDataRead dataPumpJob;
    private final ResultSetModel model = new ResultSetModel();
    private HistoryStateItem curState = null;
    private final List<HistoryStateItem> stateHistory = new ArrayList<HistoryStateItem>();
    private int historyPosition = -1;
    private AutoRefreshControl autoRefreshControl;
    private boolean actionsDisabled;
    private Color defaultBackground;
    private Color defaultForeground;

    public ResultSetViewer(@NotNull Composite parent, @NotNull IWorkbenchPartSite site, @NotNull IResultSetContainer container) {
        this.site = site;
        this.recordMode = false;
        this.container = container;
        this.decorator = container.createResultSetDecorator();
        this.dataReceiver = new ResultSetDataReceiver(this);
        this.filterManager = (IResultSetFilterManager)Adapters.adapt((Object)this, IResultSetFilterManager.class);
        if (this.filterManager == null) {
            this.filterManager = new SimpleFilterManager();
        }
        this.loadPresentationSettings();
        this.defaultBackground = EditorUtils.getDefaultTextBackground();
        this.defaultForeground = EditorUtils.getDefaultTextForeground();
        this.viewerPanel = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.viewerPanel.setData(CONTROL_ID, (Object)this);
        UIUtils.setHelp((Control)this.viewerPanel, (String)"result-set-viewer");
        this.viewerPanel.setRedraw(false);
        try {
            this.autoRefreshControl = new AutoRefreshControl((Control)this.viewerPanel, ResultSetViewer.class.getSimpleName(), monitor -> {
                boolean bl = this.refreshData(null);
            });
            if ((this.decorator.getDecoratorFeatures() & 1L) != 0L) {
                this.filtersPanel = new ResultSetFilterPanel(this);
            }
            this.findReplaceTarget = new DynamicFindReplaceTarget();
            this.viewerSash = UIUtils.createPartDivider((IWorkbenchPart)site.getPart(), (Composite)this.viewerPanel, (int)65792);
            this.viewerSash.setLayoutData((Object)new GridData(1808));
            this.presentationPanel = UIUtils.createPlaceholder((Composite)this.viewerSash, (int)1);
            this.presentationPanel.setLayoutData((Object)new GridData(1808));
            if (this.supportsPanels()) {
                this.panelFolder = new CTabFolder((Composite)this.viewerSash, 0x800080);
                this.panelFolder.marginWidth = 0;
                this.panelFolder.marginHeight = 0;
                this.panelFolder.setMinimizeVisible(true);
                this.panelFolder.setMRUVisible(true);
                this.panelFolder.setLayoutData((Object)new GridData(1808));
                this.panelToolBar = new ToolBarManager(8519936);
                ToolBar panelToolbarControl = this.panelToolBar.createControl((Composite)this.panelFolder);
                this.panelFolder.setTopRight((Control)panelToolbarControl, 131136);
                this.panelFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CTabItem activeTab = ResultSetViewer.this.panelFolder.getSelection();
                        if (activeTab != null) {
                            ResultSetViewer.this.setActivePanel((String)activeTab.getData());
                        }
                    }
                });
                this.panelFolder.addListener(11, event -> {
                    if (!this.viewerSash.isDisposed()) {
                        int[] weights = this.viewerSash.getWeights();
                        this.getPresentationSettings().panelRatio = weights[1];
                    }
                });
                this.panelFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                    public void close(CTabFolderEvent event) {
                        CTabItem item = (CTabItem)event.item;
                        String panelId = (String)item.getData();
                        ResultSetViewer.this.removePanel(panelId);
                    }

                    public void minimize(CTabFolderEvent event) {
                        ResultSetViewer.this.showPanels(false, true);
                    }

                    public void maximize(CTabFolderEvent event) {
                    }
                });
                MenuManager panelsMenuManager = new MenuManager();
                panelsMenuManager.setRemoveAllWhenShown(true);
                panelsMenuManager.addMenuListener(manager -> {
                    for (IContributionItem menuItem : this.fillPanelsMenu()) {
                        panelsMenuManager.add(menuItem);
                    }
                });
                Menu panelsMenu = panelsMenuManager.createContextMenu((Control)this.panelFolder);
                this.panelFolder.setMenu(panelsMenu);
            }
            this.setEmptyPresentation();
            if (this.supportsStatusBar()) {
                this.createStatusBar();
            }
            this.viewerPanel.addDisposeListener(e -> this.dispose());
            this.changeMode(false);
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
        this.updateFiltersText();
    }

    @Override
    @NotNull
    public IResultSetContainer getContainer() {
        return this.container;
    }

    @Override
    public IResultSetDecorator getDecorator() {
        return this.decorator;
    }

    AutoRefreshControl getAutoRefresh() {
        return this.autoRefreshControl;
    }

    private boolean supportsPanels() {
        return (this.decorator.getDecoratorFeatures() & 4L) != 0L;
    }

    private boolean supportsStatusBar() {
        return (this.decorator.getDecoratorFeatures() & 2L) != 0L;
    }

    boolean supportsDataFilter() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer != null && (dataContainer.getSupportedFeatures() & 4) == 4;
    }

    public void resetDataFilter(boolean refresh) {
        this.setDataFilter(this.model.createDataFilter(), refresh);
    }

    void saveDataFilter() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context == null) {
            log.error((Object)"Can't save data filter with null context");
            return;
        }
        DataFilterRegistry.getInstance().saveDataFilter(this.getDataContainer(), this.model.getDataFilter());
    }

    void switchFilterFocus() {
        boolean filterFocused = this.filtersPanel.getEditControl().isFocusControl();
        if (filterFocused) {
            if (this.activePresentation != null) {
                this.activePresentation.getControl().setFocus();
            }
        } else {
            this.filtersPanel.getEditControl().setFocus();
        }
    }

    private void updateFiltersText() {
        this.updateFiltersText(true);
    }

    public void updateFiltersText(boolean resetFilterValue) {
        if (this.filtersPanel == null || this.viewerPanel.isDisposed()) {
            return;
        }
        this.viewerPanel.setRedraw(false);
        try {
            boolean enableFilters = false;
            DBCExecutionContext context = this.getExecutionContext();
            if (context != null) {
                if (this.activePresentation instanceof StatisticsPresentation) {
                    enableFilters = false;
                } else {
                    StringBuilder where = new StringBuilder();
                    SQLUtils.appendConditionString((DBDDataFilter)this.model.getDataFilter(), (DBPDataSource)context.getDataSource(), null, (StringBuilder)where, (boolean)true);
                    String whereCondition = where.toString().trim();
                    if (resetFilterValue) {
                        this.filtersPanel.setFilterValue(whereCondition);
                        if (!whereCondition.isEmpty()) {
                            this.filtersPanel.addFiltersHistory(whereCondition);
                        }
                    }
                    if (this.container.isReadyToRun() && !this.model.isUpdateInProgress()) {
                        enableFilters = true;
                    }
                }
            }
            this.filtersPanel.enableFilters(enableFilters);
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
    }

    @Override
    public void setDataFilter(DBDDataFilter dataFilter, boolean refreshData) {
        if (refreshData) {
            this.refreshWithFilter(dataFilter);
        } else {
            this.model.setDataFilter(dataFilter);
            this.activePresentation.refreshData(true, false, true);
            this.updateFiltersText();
        }
    }

    @Override
    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context != null) {
            return context.getDataSource().getContainer().getPreferenceStore();
        }
        return DBeaverCore.getGlobalPreferenceStore();
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        if (this.filtersPanel == null) {
            return this.defaultBackground;
        }
        return this.filtersPanel.getEditControl().getBackground();
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        if (this.filtersPanel == null) {
            return this.defaultForeground;
        }
        return this.filtersPanel.getEditControl().getForeground();
    }

    private void persistConfig() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context != null) {
            context.getDataSource().getContainer().persistConfiguration();
        }
    }

    public List<ResultSetPresentationDescriptor> getAvailablePresentations() {
        return this.availablePresentations;
    }

    @Override
    @NotNull
    public IResultSetPresentation getActivePresentation() {
        return this.activePresentation;
    }

    @Override
    public void setEmptyPresentation() {
        this.setActivePresentation(new EmptyPresentation());
        this.activePresentationDescriptor = null;
    }

    void updatePresentation(DBCResultSet resultSet, boolean metadataChanged) {
        if (this.getControl().isDisposed()) {
            return;
        }
        boolean changed = false;
        try {
            if (resultSet instanceof StatResultSet) {
                this.availablePresentations = Collections.emptyList();
                this.setActivePresentation(new StatisticsPresentation());
                this.activePresentationDescriptor = null;
                changed = true;
            } else {
                IResultSetContext context = new IResultSetContext(){

                    @Override
                    public boolean supportsAttributes() {
                        DBDAttributeBinding[] attrs = ResultSetViewer.this.model.getAttributes();
                        return attrs.length > 0 && (attrs[0].getDataKind() != DBPDataKind.DOCUMENT || !CommonUtils.isEmpty((Collection)attrs[0].getNestedBindings()));
                    }

                    @Override
                    public boolean supportsDocument() {
                        return ResultSetViewer.this.model.getDocumentAttribute() != null;
                    }

                    @Override
                    public String getDocumentContentType() {
                        DBDAttributeBinding docAttr = ResultSetViewer.this.model.getDocumentAttribute();
                        return docAttr == null ? null : docAttr.getValueHandler().getValueContentType((DBSTypedObject)docAttr);
                    }
                };
                List<ResultSetPresentationDescriptor> newPresentations = ResultSetPresentationRegistry.getInstance().getAvailablePresentations(resultSet, context);
                changed = CommonUtils.isEmpty(this.availablePresentations) || !newPresentations.equals(this.availablePresentations);
                this.availablePresentations = newPresentations;
                if (!this.availablePresentations.isEmpty()) {
                    if (this.activePresentationDescriptor != null && (!metadataChanged || this.activePresentationDescriptor.getPresentationType().isPersistent()) && this.availablePresentations.contains((Object)this.activePresentationDescriptor)) {
                        return;
                    }
                    String defaultPresentationId = this.getPreferenceStore().getString("resultset.presentation.active");
                    ResultSetPresentationDescriptor newPresentation = null;
                    if (!CommonUtils.isEmpty((String)defaultPresentationId)) {
                        for (ResultSetPresentationDescriptor pd : this.availablePresentations) {
                            if (!pd.getId().equals(defaultPresentationId)) continue;
                            newPresentation = pd;
                            break;
                        }
                    }
                    changed = true;
                    if (newPresentation == null) {
                        newPresentation = this.availablePresentations.get(0);
                    }
                    try {
                        IResultSetPresentation instance = newPresentation.createInstance();
                        this.activePresentationDescriptor = newPresentation;
                        this.setActivePresentation(instance);
                    }
                    catch (Throwable e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        finally {
            if (changed && this.presentationSwitchToolbar != null) {
                this.updatePresentationInToolbar();
            }
        }
    }

    private void updatePresentationInToolbar() {
        this.viewerPanel.setRedraw(false);
        try {
            try {
                boolean pVisible = this.activePresentationDescriptor != null;
                ((RowData)this.presentationSwitchToolbar.getLayoutData()).exclude = !pVisible;
                this.presentationSwitchToolbar.setVisible(pVisible);
                if (!pVisible) {
                    this.presentationSwitchToolbar.setEnabled(false);
                } else {
                    this.presentationSwitchToolbar.setEnabled(true);
                    ToolItem[] toolItemArray = this.presentationSwitchToolbar.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem item = toolItemArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    for (ResultSetPresentationDescriptor pd : this.availablePresentations) {
                        ToolItem item = new ToolItem(this.presentationSwitchToolbar, 32);
                        item.setImage(DBeaverIcons.getImage((DBPImage)pd.getIcon()));
                        item.setText(pd.getLabel());
                        item.setToolTipText(pd.getDescription());
                        item.setData((Object)pd);
                        if (pd == this.activePresentationDescriptor) {
                            item.setSelection(true);
                        }
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (e.widget != null && e.widget.getData() != null) {
                                    ResultSetViewer.this.switchPresentation((ResultSetPresentationDescriptor)((Object)e.widget.getData()));
                                }
                            }
                        });
                    }
                }
                this.statusBar.layout();
                this.viewerPanel.layout();
            }
            catch (Exception e) {
                log.debug((Object)"Error updating presentation toolbar", (Throwable)e);
                this.viewerPanel.setRedraw(true);
            }
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
    }

    private void setActivePresentation(@NotNull IResultSetPresentation presentation) {
        boolean focusInPresentation = UIUtils.isParent((Control)this.presentationPanel, (Control)this.viewerPanel.getDisplay().getFocusControl());
        Control[] controlArray = this.presentationPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (this.panelFolder != null) {
            CTabItem curItem = this.panelFolder.getSelection();
            CTabItem[] cTabItemArray = this.panelFolder.getItems();
            int n3 = cTabItemArray.length;
            n = 0;
            while (n < n3) {
                CTabItem panelItem = cTabItemArray[n];
                if (panelItem != curItem) {
                    panelItem.dispose();
                }
                ++n;
            }
            if (curItem != null) {
                curItem.dispose();
            }
        }
        this.activePresentation = presentation;
        this.availablePanels.clear();
        this.activePanels.clear();
        if (this.activePresentationDescriptor != null) {
            this.availablePanels.addAll(ResultSetPresentationRegistry.getInstance().getSupportedPanels(this.getDataSource(), this.activePresentationDescriptor.getId(), this.activePresentationDescriptor.getPresentationType()));
        } else {
            this.availablePanels.addAll(ResultSetPresentationRegistry.getInstance().getSupportedPanels(this.getDataSource(), null, IResultSetPresentation.PresentationType.COLUMNS));
        }
        this.activePresentation.createPresentation(this, this.presentationPanel);
        if (this.supportsPanels()) {
            boolean panelsVisible = false;
            boolean verticalLayout = false;
            int[] panelWeights = new int[]{700, 300};
            if (this.activePresentationDescriptor != null) {
                PresentationSettings settings = this.getPresentationSettings();
                panelsVisible = settings.panelsVisible;
                verticalLayout = settings.verticalLayout;
                if (settings.panelRatio > 0) {
                    panelWeights = new int[]{1000 - settings.panelRatio, settings.panelRatio};
                }
                this.activateDefaultPanels(settings);
            }
            this.showPanels(panelsVisible, false);
            this.viewerSash.setOrientation(verticalLayout ? 512 : 256);
            this.viewerSash.setWeights(panelWeights);
        }
        this.presentationPanel.layout();
        IFindReplaceTarget nested = null;
        if (presentation instanceof IAdaptable) {
            nested = (IFindReplaceTarget)((IAdaptable)presentation).getAdapter(IFindReplaceTarget.class);
        }
        this.findReplaceTarget.setTarget(nested);
        if (!this.toolbarList.isEmpty()) {
            for (ToolBarManager tb : this.toolbarList) {
                tb.update(true);
            }
        }
        if (presentation instanceof ISelectionProvider) {
            ((ISelectionProvider)presentation).addSelectionChangedListener(this::fireResultSetSelectionChange);
        }
        if (focusInPresentation) {
            UIUtils.asyncExec(() -> {
                Control control = this.activePresentation.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setFocus();
                }
            });
        }
    }

    void switchPresentation() {
        if (this.availablePresentations.size() < 2) {
            return;
        }
        int index = this.availablePresentations.indexOf((Object)this.activePresentationDescriptor);
        index = index < this.availablePresentations.size() - 1 ? ++index : 0;
        this.switchPresentation(this.availablePresentations.get(index));
    }

    public void switchPresentation(ResultSetPresentationDescriptor selectedPresentation) {
        try {
            IResultSetPresentation instance = selectedPresentation.createInstance();
            this.activePresentationDescriptor = selectedPresentation;
            this.setActivePresentation(instance);
            instance.refreshData(true, false, false);
            if (this.presentationSwitchToolbar != null) {
                ToolItem[] toolItemArray = this.presentationSwitchToolbar.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item;
                    item.setSelection((item = toolItemArray[n2]).getData() == this.activePresentationDescriptor);
                    ++n2;
                }
            }
            if (this.activePresentationDescriptor.getPresentationType().isPersistent()) {
                DBeaverCore.getGlobalPreferenceStore().setValue("resultset.presentation.active", this.activePresentationDescriptor.getId());
            }
            this.savePresentationSettings();
        }
        catch (Throwable e1) {
            DBUserInterface.getInstance().showError("Presentation switch", "Can't switch presentation", e1);
        }
    }

    private void loadPresentationSettings() {
        IDialogSettings pSections = ResultSetUtils.getViewerSettings("presentations");
        for (IDialogSettings pSection : ArrayUtils.safeArray((Object[])pSections.getSections())) {
            String pId = pSection.getName();
            ResultSetPresentationDescriptor presentation = ResultSetPresentationRegistry.getInstance().getPresentation(pId);
            if (presentation == null) {
                log.warn((Object)("Presentation '" + pId + "' not found. "));
                continue;
            }
            PresentationSettings settings = new PresentationSettings();
            String panelIdList = pSection.get("enabledPanelIds");
            if (panelIdList != null) {
                Collections.addAll(settings.enabledPanelIds, panelIdList.split(","));
            }
            settings.activePanelId = pSection.get("activePanelId");
            settings.panelRatio = pSection.getInt("panelRatio");
            settings.panelsVisible = pSection.getBoolean("panelsVisible");
            settings.verticalLayout = pSection.getBoolean("verticalLayout");
            this.presentationSettings.put(presentation, settings);
        }
    }

    private PresentationSettings getPresentationSettings() {
        PresentationSettings settings = this.presentationSettings.get((Object)this.activePresentationDescriptor);
        if (settings == null) {
            settings = new PresentationSettings();
            settings.panelsVisible = this.activePresentationDescriptor != null && this.activePresentationDescriptor.getPresentationType() == IResultSetPresentation.PresentationType.COLUMNS;
            this.presentationSettings.put(this.activePresentationDescriptor, settings);
        }
        return settings;
    }

    private void savePresentationSettings() {
        if ((this.decorator.getDecoratorFeatures() & 4L) != 0L) {
            IDialogSettings pSections = ResultSetUtils.getViewerSettings("presentations");
            for (Map.Entry<ResultSetPresentationDescriptor, PresentationSettings> pEntry : this.presentationSettings.entrySet()) {
                if (pEntry.getKey() == null) continue;
                String pId = pEntry.getKey().getId();
                PresentationSettings settings = pEntry.getValue();
                IDialogSettings pSection = UIUtils.getSettingsSection((IDialogSettings)pSections, (String)pId);
                pSection.put("enabledPanelIds", CommonUtils.joinStrings((String)",", settings.enabledPanelIds));
                pSection.put("activePanelId", settings.activePanelId);
                pSection.put("panelRatio", settings.panelRatio);
                pSection.put("panelsVisible", settings.panelsVisible);
                pSection.put("verticalLayout", settings.verticalLayout);
            }
        }
    }

    @Override
    public IResultSetPanel getVisiblePanel() {
        return this.isPanelsVisible() ? this.activePanels.get(this.getPresentationSettings().activePanelId) : null;
    }

    String getActivePanelId() {
        return this.getPresentationSettings().activePanelId;
    }

    void closeActivePanel() {
        CTabItem activePanelItem = this.panelFolder.getSelection();
        if (activePanelItem != null) {
            activePanelItem.dispose();
        }
        if (this.panelFolder.getItemCount() <= 0) {
            this.showPanels(false, true);
        }
    }

    @Override
    public IResultSetPanel[] getActivePanels() {
        return this.activePanels.values().toArray(new IResultSetPanel[0]);
    }

    @Override
    public boolean activatePanel(String id, boolean setActive, boolean showPanels) {
        ResultSetPanelDescriptor panelDescriptor;
        if (!this.supportsPanels()) {
            return false;
        }
        if (showPanels && !this.isPanelsVisible()) {
            this.showPanels(true, false);
        }
        PresentationSettings presentationSettings = this.getPresentationSettings();
        IResultSetPanel panel = this.activePanels.get(id);
        if (panel != null) {
            CTabItem panelTab = this.getPanelTab(id);
            if (panelTab != null) {
                if (setActive) {
                    this.panelFolder.setSelection(panelTab);
                    presentationSettings.activePanelId = id;
                }
                return true;
            }
            log.debug((Object)("Panel '" + id + "' tab not found"));
        }
        if ((panelDescriptor = this.getPanelDescriptor(id)) == null) {
            log.debug((Object)("Panel '" + id + "' not found"));
            return false;
        }
        try {
            panel = panelDescriptor.createInstance();
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Can't show panel", "Can't create panel '" + id + "'", (Throwable)e);
            return false;
        }
        this.activePanels.put(id, panel);
        this.panelFolder.setRedraw(false);
        try {
            Control panelControl = panel.createContents(this.activePresentation, (Composite)this.panelFolder);
            boolean firstPanel = this.panelFolder.getItemCount() == 0;
            CTabItem panelTab = new CTabItem(this.panelFolder, 64);
            panelTab.setData((Object)id);
            panelTab.setText(panelDescriptor.getLabel());
            panelTab.setImage(DBeaverIcons.getImage((DBPImage)panelDescriptor.getIcon()));
            panelTab.setToolTipText(panelDescriptor.getDescription());
            panelTab.setControl(panelControl);
            UIUtils.disposeControlOnItemDispose((CTabItem)panelTab);
            if (setActive || firstPanel) {
                this.panelFolder.setSelection(panelTab);
            }
        }
        finally {
            this.panelFolder.setRedraw(true);
        }
        presentationSettings.enabledPanelIds.add(id);
        if (setActive) {
            this.setActivePanel(id);
        }
        return true;
    }

    private void activateDefaultPanels(PresentationSettings settings) {
        settings.enabledPanelIds.removeIf(CommonUtils::isEmpty);
        if (settings.enabledPanelIds.isEmpty()) {
            for (ResultSetPanelDescriptor pd : this.availablePanels) {
                if (!pd.isShowByDefault()) continue;
                settings.enabledPanelIds.add(pd.getId());
            }
        }
        if (!settings.enabledPanelIds.contains(settings.activePanelId)) {
            settings.activePanelId = null;
        }
        if (!settings.enabledPanelIds.isEmpty()) {
            if (settings.activePanelId == null) {
                settings.activePanelId = settings.enabledPanelIds.iterator().next();
            }
            for (String panelId : new ArrayList<String>(settings.enabledPanelIds)) {
                if (CommonUtils.isEmpty((String)panelId) || this.activatePanel(panelId, panelId.equals(settings.activePanelId), false)) continue;
                settings.enabledPanelIds.remove(panelId);
            }
        }
    }

    private void setActivePanel(String panelId) {
        PresentationSettings settings = this.getPresentationSettings();
        settings.activePanelId = panelId;
        IResultSetPanel panel = this.activePanels.get(panelId);
        if (panel != null) {
            panel.activatePanel();
            this.updatePanelActions();
            this.savePresentationSettings();
        }
    }

    private void removePanel(String panelId) {
        IResultSetPanel panel = this.activePanels.remove(panelId);
        if (panel != null) {
            panel.deactivatePanel();
        }
        this.getPresentationSettings().enabledPanelIds.remove(panelId);
        if (this.activePanels.isEmpty()) {
            this.showPanels(false, true);
        }
    }

    private ResultSetPanelDescriptor getPanelDescriptor(String id) {
        for (ResultSetPanelDescriptor panel : this.availablePanels) {
            if (!panel.getId().equals(id)) continue;
            return panel;
        }
        return null;
    }

    private CTabItem getPanelTab(String panelId) {
        if (this.panelFolder != null) {
            CTabItem[] cTabItemArray = this.panelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                if (CommonUtils.equalObjects((Object)tab.getData(), (Object)panelId)) {
                    return tab;
                }
                ++n2;
            }
        }
        return null;
    }

    boolean isPanelsVisible() {
        return this.viewerSash != null && this.viewerSash.getMaximizedControl() == null;
    }

    void showPanels(boolean show, boolean saveSettings) {
        if (!this.supportsPanels() || show == this.isPanelsVisible()) {
            return;
        }
        CTabItem activePanelTab = this.panelFolder.getSelection();
        if (!show) {
            this.viewerSash.setMaximizedControl((Control)this.presentationPanel);
            if (activePanelTab != null && !activePanelTab.getControl().isDisposed() && UIUtils.hasFocus((Control)activePanelTab.getControl())) {
                this.activePresentation.getControl().setFocus();
            }
        } else {
            this.activateDefaultPanels(this.getPresentationSettings());
            this.viewerSash.setMaximizedControl(null);
            this.updatePanelActions();
            this.updatePanelsContent(false);
            this.activePresentation.updateValueView();
            if (activePanelTab != null && !activePanelTab.getControl().isDisposed() && UIUtils.hasFocus((Control)this.activePresentation.getControl())) {
                activePanelTab.getControl().setFocus();
            }
        }
        this.getPresentationSettings().panelsVisible = show;
        if (saveSettings) {
            this.savePresentationSettings();
        }
    }

    void toggleVerticalLayout() {
        PresentationSettings settings = this.getPresentationSettings();
        settings.verticalLayout = !settings.verticalLayout;
        this.viewerSash.setOrientation(settings.verticalLayout ? 512 : 256);
        this.savePresentationSettings();
    }

    private List<IContributionItem> fillPanelsMenu() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (ResultSetPanelDescriptor panel : this.availablePanels) {
            items.add((IContributionItem)new ActionContributionItem((IAction)new PanelToggleAction(panel)));
        }
        items.add((IContributionItem)new Separator());
        items.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.toggleLayout"));
        items.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview"));
        return items;
    }

    private void addDefaultPanelActions() {
        this.panelToolBar.add((IAction)new Action("View Menu", DBeaverIcons.getViewMenuImageDescriptor()){

            public void run() {
                ToolBar tb = ResultSetViewer.this.panelToolBar.getControl();
                ToolItem[] toolItemArray = tb.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    if (item.getData() instanceof ActionContributionItem && ((ActionContributionItem)item.getData()).getAction() == this) {
                        MenuManager panelMenu = new MenuManager();
                        for (IContributionItem menuItem : ResultSetViewer.this.fillPanelsMenu()) {
                            panelMenu.add(menuItem);
                        }
                        Menu swtMenu = panelMenu.createContextMenu((Control)ResultSetViewer.this.panelToolBar.getControl());
                        Rectangle ib = item.getBounds();
                        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
                        swtMenu.setLocation(displayAt);
                        swtMenu.setVisible(true);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    boolean isActionsDisabled() {
        return this.actionsDisabled;
    }

    @Override
    public void lockActionsByControl(Control lockedBy) {
        if (this.checkDoubleLock(lockedBy)) {
            return;
        }
        this.actionsDisabled = true;
        lockedBy.addDisposeListener(e -> {
            boolean bl = this.actionsDisabled = false;
        });
    }

    @Override
    public void lockActionsByFocus(final Control lockedBy) {
        lockedBy.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ResultSetViewer.this.checkDoubleLock(lockedBy);
                ResultSetViewer.this.actionsDisabled = true;
            }

            public void focusLost(FocusEvent e) {
                ResultSetViewer.this.actionsDisabled = false;
            }
        });
        lockedBy.addDisposeListener(e -> {
            boolean bl = this.actionsDisabled = false;
        });
    }

    boolean isPresentationInFocus() {
        Control activeControl = this.getActivePresentation().getControl();
        return !activeControl.isDisposed() && activeControl.isFocusControl();
    }

    private boolean checkDoubleLock(Control lockedBy) {
        if (this.actionsDisabled) {
            log.debug((Object)new DBCException("Internal error: actions double-lock by [" + lockedBy + "]"));
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (UIUtils.isUIThread()) {
            Object adapted;
            IResultSetPanel visiblePanel;
            if (UIUtils.hasFocus((Control)this.filtersPanel)) {
                T result = this.filtersPanel.getAdapter(adapter);
                if (result != null) {
                    return result;
                }
            } else if (UIUtils.hasFocus((Control)this.panelFolder) && (visiblePanel = this.getVisiblePanel()) instanceof IAdaptable && (adapted = ((IAdaptable)visiblePanel).getAdapter(adapter)) != null) {
                return (T)adapted;
            }
        }
        if (this.activePresentation != null) {
            Object adapted;
            if (adapter.isAssignableFrom(this.activePresentation.getClass())) {
                return adapter.cast(this.activePresentation);
            }
            if (this.activePresentation instanceof IAdaptable && (adapted = ((IAdaptable)this.activePresentation).getAdapter(adapter)) != null) {
                return (T)adapted;
            }
        }
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IResultSetListener listener) {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IResultSetListener listener) {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void updateEditControls() {
        ResultSetPropertyTester.firePropertyChange("editable");
        ResultSetPropertyTester.firePropertyChange("changed");
        this.fireResultSetChange();
        this.updateToolbar();
    }

    private void updateToolbar() {
        for (ToolBarManager tb : this.toolbarList) {
            UIUtils.updateContributionItems((IContributionManager)tb);
        }
        if (this.panelToolBar != null) {
            UIUtils.updateContributionItems((IContributionManager)this.panelToolBar);
        }
    }

    @Override
    public void redrawData(boolean attributesChanged, boolean rowsChanged) {
        if (this.viewerPanel.isDisposed()) {
            return;
        }
        if (rowsChanged) {
            int rowCount = this.model.getRowCount();
            if (this.curRow == null || this.curRow.getVisualNumber() >= rowCount) {
                ResultSetRow resultSetRow = this.curRow = rowCount == 0 ? null : this.model.getRow(rowCount - 1);
            }
            if (!this.recordMode) {
                this.updateFiltersText();
            }
        }
        this.activePresentation.refreshData(attributesChanged || rowsChanged && this.recordMode, false, true);
        this.updateStatusMessage();
    }

    private void createStatusBar() {
        UIUtils.createHorizontalLine((Composite)this.viewerPanel);
        this.statusBar = new Composite(this.viewerPanel, 0);
        this.statusBar.setBackgroundMode(2);
        GridData gd = new GridData(768);
        this.statusBar.setLayoutData((Object)gd);
        RowLayout toolbarsLayout = new RowLayout(256);
        toolbarsLayout.marginTop = 0;
        toolbarsLayout.marginBottom = 0;
        toolbarsLayout.center = true;
        toolbarsLayout.wrap = true;
        toolbarsLayout.pack = true;
        this.statusBar.setLayout((Layout)toolbarsLayout);
        ToolBarManager editToolbar = new ToolBarManager(8519936);
        editToolbar.add((IContributionItem)new Separator());
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.applyChanges", (String)"Save", null, null, (boolean)true));
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.rejectChanges", (String)"Cancel", null, null, (boolean)true));
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.generateScript", (String)"Script", null, null, (boolean)true));
        editToolbar.add((IContributionItem)new Separator());
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit"));
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.add"));
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy"));
        editToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.delete"));
        editToolbar.createControl(this.statusBar);
        this.toolbarList.add(editToolbar);
        ToolBarManager navToolbar = new ToolBarManager(8519936);
        navToolbar.add((IContributionItem)new ToolbarSeparatorContribution(true));
        navToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.first"));
        navToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.previous"));
        navToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.next"));
        navToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.last"));
        navToolbar.add((IContributionItem)new Separator());
        navToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.page"));
        navToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.all"));
        navToolbar.createControl(this.statusBar);
        navToolbar.add((IContributionItem)new Separator(TOOLBAR_GROUP_NAVIGATION));
        this.toolbarList.add(navToolbar);
        ToolBarManager configToolbar = new ToolBarManager(8519936);
        configToolbar.add((IContributionItem)new ToolbarSeparatorContribution(true));
        ActionContributionItem item = new ActionContributionItem((IAction)new ToggleModeAction());
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        configToolbar.add((IContributionItem)item);
        CommandContributionItemParameter ciParam = new CommandContributionItemParameter((IServiceLocator)this.site, "org.jkiss.dbeaver.core.resultset.panels", "org.jkiss.dbeaver.core.resultset.grid.togglePreview", 4);
        ciParam.label = "Panels";
        ciParam.mode = CommandContributionItem.MODE_FORCE_TEXT;
        configToolbar.add((IContributionItem)new CommandContributionItem(ciParam));
        configToolbar.add((IContributionItem)new ToolbarSeparatorContribution(true));
        configToolbar.createControl(this.statusBar);
        this.toolbarList.add(configToolbar);
        this.presentationSwitchToolbar = new ToolBar(this.statusBar, 8519936);
        RowData rd = new RowData();
        rd.exclude = true;
        this.presentationSwitchToolbar.setLayoutData((Object)rd);
        ToolBarManager addToolbar = new ToolBarManager(8519936);
        addToolbar.add((IContributionItem)new GroupMarker("presentations"));
        addToolbar.add((IContributionItem)new Separator(TOOLBAR_GROUP_ADDITIONS));
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)addToolbar, TOOLBAR_CONTRIBUTION_ID);
        }
        addToolbar.createControl(this.statusBar);
        this.toolbarList.add(addToolbar);
        configToolbar = new ToolBarManager(8519936);
        configToolbar.add((IContributionItem)new ToolbarSeparatorContribution(true));
        configToolbar.add((IAction)new ConfigAction());
        configToolbar.update(true);
        configToolbar.createControl(this.statusBar);
        this.toolbarList.add(configToolbar);
        int fontHeight = UIUtils.getFontHeight((Control)this.statusBar);
        this.statusLabel = new StatusLabel(this.statusBar, 0, this);
        this.statusLabel.setLayoutData(new RowData(40 * fontHeight, -1));
        this.rowCountLabel = new ActiveStatusMessage(this.statusBar, DBeaverIcons.getImage((DBPImage)UIIcon.RS_REFRESH), CoreMessages.controls_resultset_viewer_calculate_row_count, this){

            @Override
            protected boolean isActionEnabled() {
                return ResultSetViewer.this.hasData();
            }

            @Override
            protected ILoadService<String> createLoadService() {
                return new DatabaseLoadService<String>("Load row count", ResultSetViewer.this.getExecutionContext()){

                    public String evaluate(DBRProgressMonitor monitor) {
                        try {
                            long rowCount = ResultSetViewer.this.readRowCount(monitor);
                            return ROW_COUNT_FORMAT.format(rowCount);
                        }
                        catch (DBException e) {
                            log.error((Object)e);
                            return e.getMessage();
                        }
                    }
                };
            }
        };
        this.rowCountLabel.setLayoutData(new RowData(10 * fontHeight, -1));
        this.rowCountLabel.setMessage("Row Count");
    }

    @Override
    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.curState != null ? this.curState.dataContainer : this.container.getDataContainer();
    }

    @Override
    public boolean isRecordMode() {
        return this.recordMode;
    }

    void toggleMode() {
        this.changeMode(!this.recordMode);
        this.updateEditControls();
    }

    private void changeMode(boolean recordMode) {
        this.recordMode = recordMode;
        this.activePresentation.refreshData(true, false, false);
        this.activePresentation.changeMode(recordMode);
        this.updateStatusMessage();
    }

    private void dispose() {
        this.clearData();
        for (ToolBarManager tb : this.toolbarList) {
            try {
                tb.dispose();
            }
            catch (Throwable e) {
                log.debug((Object)("Error disposing toolbar " + tb), e);
            }
        }
        this.toolbarList.clear();
    }

    @Override
    public boolean isAttributeReadOnly(DBDAttributeBinding attribute) {
        if (this.isReadOnly()) {
            return true;
        }
        if (!this.model.isAttributeReadOnly(attribute)) {
            return false;
        }
        boolean newRow = this.curRow != null && this.curRow.getState() == 2;
        return !newRow;
    }

    private Object savePresentationState() {
        if (this.activePresentation instanceof IStatefulControl) {
            return ((IStatefulControl)((Object)this.activePresentation)).saveState();
        }
        return null;
    }

    private void restorePresentationState(Object state) {
        if (this.activePresentation instanceof IStatefulControl) {
            ((IStatefulControl)((Object)this.activePresentation)).restoreState(state);
        }
    }

    List<HistoryStateItem> getStateHistory() {
        return this.stateHistory;
    }

    private void setNewState(DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter) {
        dataFilter = new DBDDataFilter(dataFilter == null ? this.model.getDataFilter() : dataFilter);
        int i = 0;
        while (i < this.stateHistory.size()) {
            HistoryStateItem item = this.stateHistory.get(i);
            if (item.dataContainer == dataContainer && item.filter != null && item.filter.equalFilters(dataFilter, false)) {
                item.filter = dataFilter;
                this.curState = item;
                this.historyPosition = i;
                return;
            }
            ++i;
        }
        while (this.historyPosition < this.stateHistory.size() - 1) {
            this.stateHistory.remove(this.stateHistory.size() - 1);
        }
        this.curState = new HistoryStateItem(dataContainer, dataFilter, this.curRow == null ? -1 : this.curRow.getVisualNumber());
        this.stateHistory.add(this.curState);
        this.historyPosition = this.stateHistory.size() - 1;
    }

    public void resetHistory() {
        this.curState = null;
        this.stateHistory.clear();
        this.historyPosition = -1;
    }

    @Override
    @Nullable
    public ResultSetRow getCurrentRow() {
        return this.curRow;
    }

    @Override
    public void setCurrentRow(@Nullable ResultSetRow curRow) {
        this.curRow = curRow;
        if (this.curState != null && curRow != null) {
            this.curState.rowNumber = curRow.getVisualNumber();
        }
    }

    public void setStatus(String status) {
        this.setStatus(status, DBPMessageType.INFORMATION);
    }

    @Override
    public void setStatus(String status, DBPMessageType messageType) {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        this.statusLabel.setStatus(status, messageType);
        this.rowCountLabel.updateActionState();
    }

    @Override
    public void updateStatusMessage() {
        DBPDataSource dataSource;
        DBSDataContainer dataContainer;
        boolean hasWarnings;
        String statusMessage = this.model.getRowCount() == 0 ? (this.model.getVisibleAttributeCount() == 0 ? String.valueOf(CoreMessages.controls_resultset_viewer_status_empty) + this.getExecutionTimeMessage() : String.valueOf(CoreMessages.controls_resultset_viewer_status_no_data) + this.getExecutionTimeMessage()) : (this.recordMode ? String.valueOf(CoreMessages.controls_resultset_viewer_status_row) + (this.curRow == null ? 0 : this.curRow.getVisualNumber() + 1) + "/" + this.model.getRowCount() + (this.curRow == null ? this.getExecutionTimeMessage() : "") : String.valueOf(String.valueOf(this.model.getRowCount())) + CoreMessages.controls_resultset_viewer_status_rows_fetched + this.getExecutionTimeMessage());
        boolean bl = hasWarnings = !this.dataReceiver.getErrorList().isEmpty();
        if (hasWarnings) {
            statusMessage = String.valueOf(statusMessage) + " - " + this.dataReceiver.getErrorList().size() + " warning(s)";
        }
        if (this.getPreferenceStore().getBoolean("resultset.show.connectionName") && (dataContainer = this.getDataContainer()) != null && (dataSource = dataContainer.getDataSource()) != null) {
            statusMessage = String.valueOf(statusMessage) + " [" + dataSource.getContainer().getName() + "]";
        }
        this.setStatus(statusMessage, hasWarnings ? DBPMessageType.WARNING : DBPMessageType.INFORMATION);
        if (this.rowCountLabel != null) {
            if (!this.hasData()) {
                this.rowCountLabel.setMessage("No Data");
            } else if (!this.isHasMoreData()) {
                this.rowCountLabel.setMessage(ROW_COUNT_FORMAT.format(this.model.getRowCount()));
            } else if (this.model.getTotalRowCount() == null) {
                this.rowCountLabel.setMessage(String.valueOf(ROW_COUNT_FORMAT.format(this.model.getRowCount())) + "+");
            } else {
                this.rowCountLabel.setMessage(ROW_COUNT_FORMAT.format(this.model.getTotalRowCount()));
            }
            this.rowCountLabel.updateActionState();
        }
    }

    private String getExecutionTimeMessage() {
        DBCStatistics statistics = this.model.getStatistics();
        if (statistics == null || statistics.isEmpty()) {
            return "";
        }
        long fetchTime = statistics.getFetchTime();
        long totalTime = statistics.getTotalTime();
        if (fetchTime <= 0L) {
            return " - " + RuntimeUtils.formatExecutionTime((long)totalTime);
        }
        return " - " + RuntimeUtils.formatExecutionTime((long)statistics.getExecuteTime()) + " (+" + RuntimeUtils.formatExecutionTime((long)fetchTime) + ")";
    }

    @Override
    public void toggleSortOrder(DBDAttributeBinding columnElement, boolean forceAscending, boolean forceDescending) {
        DBDDataFilter dataFilter = this.getModel().getDataFilter();
        if (forceAscending) {
            dataFilter.resetOrderBy();
        }
        DBDAttributeBinding metaColumn = columnElement;
        DBDAttributeConstraint constraint = dataFilter.getConstraint(metaColumn);
        assert (constraint != null);
        if (constraint.getOrderPosition() == 0) {
            if (ResultSetUtils.isServerSideFiltering(this) && this.supportsDataFilter() && ConfirmationDialog.showConfirmDialogNoToggle(this.viewerPanel.getShell(), "order_resultset", 3, 4, metaColumn.getName()) != 2) {
                return;
            }
            constraint.setOrderPosition(dataFilter.getMaxOrderingPosition() + 1);
            constraint.setOrderDescending(forceDescending);
        } else if (!constraint.isOrderDescending()) {
            constraint.setOrderDescending(true);
        } else {
            for (DBDAttributeConstraint con2 : dataFilter.getConstraints()) {
                if (con2.getOrderPosition() <= constraint.getOrderPosition()) continue;
                con2.setOrderPosition(con2.getOrderPosition() - 1);
            }
            constraint.setOrderPosition(0);
            constraint.setOrderDescending(false);
        }
        dataFilter.setOrder(null);
        if (!ResultSetUtils.isServerSideFiltering(this) || !this.isHasMoreData()) {
            if (!this.checkForChanges()) {
                return;
            }
            this.reorderLocally();
        } else {
            this.refreshData(null);
        }
    }

    private void reorderLocally() {
        this.rejectChanges();
        this.getModel().resetOrdering();
        this.getActivePresentation().refreshData(false, false, true);
    }

    void setMetaData(@NotNull DBCResultSet resultSet, @NotNull DBDAttributeBinding[] attributes) {
        this.model.setMetaData(resultSet, attributes);
        this.activePresentation.clearMetaData();
    }

    void setData(List<Object[]> rows, int focusRow) {
        if (this.viewerPanel.isDisposed()) {
            return;
        }
        this.curRow = null;
        this.model.setData(rows);
        ResultSetRow resultSetRow = this.curRow = this.model.getRowCount() > 0 ? this.model.getRow(0) : null;
        if (focusRow > 0 && focusRow < this.model.getRowCount()) {
            this.curRow = this.model.getRow(focusRow);
        }
        if (this.model.isMetadataChanged() && this.getPreferenceStore().getBoolean("resultset.behavior.autoSwitchMode")) {
            boolean newRecordMode;
            boolean bl = newRecordMode = rows.size() == 1;
            if (newRecordMode != this.recordMode) {
                this.toggleMode();
            }
        }
    }

    void appendData(List<Object[]> rows) {
        this.model.appendData(rows);
        this.activePresentation.refreshData(false, true, true);
        this.setStatus(String.valueOf(NLS.bind((String)CoreMessages.controls_resultset_viewer_status_rows_size, (Object)this.model.getRowCount(), (Object)rows.size())) + this.getExecutionTimeMessage());
        this.updateEditControls();
    }

    public int promptToSaveOnClose() {
        if (!this.isDirty()) {
            return 0;
        }
        int result = ConfirmationDialog.showConfirmDialog(this.viewerPanel.getShell(), "close_resultset_edit", 6, new Object[0]);
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            this.rejectChanges();
            return 1;
        }
        return 2;
    }

    public void doSave(IProgressMonitor monitor) {
        this.applyChanges(RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
    }

    public void doSave(DBRProgressMonitor monitor) {
        this.applyChanges(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.model.isDirty() || this.activePresentation != null && this.activePresentation.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    @Override
    public boolean hasData() {
        return this.model.hasData();
    }

    @Override
    public boolean isHasMoreData() {
        return this.getExecutionContext() != null && this.dataReceiver.isHasMoreData();
    }

    @Override
    public boolean isReadOnly() {
        if (this.model.isUpdateInProgress() || !(this.activePresentation instanceof IResultSetEditor) || (this.decorator.getDecoratorFeatures() & 5L) == 0L) {
            return true;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        return executionContext == null || !executionContext.isConnected() || executionContext.getDataSource().getContainer().isConnectionReadOnly() || executionContext.getDataSource().getInfo().isReadOnlyData();
    }

    boolean isInsertable() {
        return !this.isReadOnly() && this.model.isSingleSource() && this.model.getVisibleAttributeCount() > 0;
    }

    @Override
    public boolean isRefreshInProgress() {
        return this.dataPumpJob != null;
    }

    public DataSourceJob getDataReadJob() {
        return this.dataPumpJob;
    }

    @NotNull
    IResultSetFilterManager getFilterManager() {
        return this.filterManager;
    }

    void showFiltersMenu() {
        DBDAttributeBinding curAttribute = this.getActivePresentation().getCurrentAttribute();
        if (curAttribute == null) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillFiltersMenu(curAttribute, (IMenuManager)menuManager);
        this.showContextMenuAtCursor(menuManager);
    }

    @Override
    public void showDistinctFilter(DBDAttributeBinding curAttribute) {
        this.showFiltersDistinctMenu(curAttribute, false);
    }

    void showFiltersDistinctMenu(DBDAttributeBinding curAttribute, boolean atKeyboardCursor) {
        List<ResultSetRow> selectedRows = this.getSelection().getSelectedRows();
        ResultSetRow[] rows = selectedRows.toArray(new ResultSetRow[0]);
        FilterValueEditPopup menu = new FilterValueEditPopup(this.getSite().getShell(), this, curAttribute, rows);
        Point location = atKeyboardCursor ? this.getKeyboardCursorLocation() : this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().getCursorLocation();
        if (location != null) {
            menu.setLocation(location);
        }
        if (menu.open() == 0) {
            Object value = menu.getValue();
            DBDDataFilter filter = new DBDDataFilter(this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(curAttribute);
            if (constraint != null) {
                constraint.setOperator(DBCLogicalOperator.EQUALS);
                constraint.setValue(value);
                this.setDataFilter(filter, true);
            }
        }
    }

    void showReferencesMenu(boolean openInNewWindow) {
        ResultSetRow currentRow = this.getCurrentRow();
        if (currentRow == null || currentRow.getRowNumber() < 0) {
            return;
        }
        MenuManager menuManager = this.createRefTablesMenu(currentRow, openInNewWindow);
        if (menuManager != null) {
            this.showContextMenuAtCursor(menuManager);
        }
    }

    private void showContextMenuAtCursor(MenuManager menuManager) {
        Point location = this.getKeyboardCursorLocation();
        if (location != null) {
            Menu contextMenu = menuManager.createContextMenu(this.getActivePresentation().getControl());
            contextMenu.setLocation(location);
            contextMenu.setVisible(true);
        }
    }

    @Nullable
    private Point getKeyboardCursorLocation() {
        Control control = this.getActivePresentation().getControl();
        Point cursorLocation = this.getActivePresentation().getCursorLocation();
        if (cursorLocation == null) {
            return null;
        }
        return control.getDisplay().map(control, null, cursorLocation);
    }

    @Override
    public void fillContextMenu(@NotNull IMenuManager manager, @Nullable DBDAttributeBinding attr, @Nullable ResultSetRow row) {
        Object value;
        ResultSetValueController valueController;
        DBPDataSource dataSource = this.getDataSource();
        if (attr != null && row != null) {
            valueController = new ResultSetValueController(this, attr, row, IValueController.EditType.NONE, null);
            value = valueController.getValue();
        } else {
            valueController = null;
            value = null;
        }
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.cut"));
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.copy"));
        MenuManager extCopyMenu = new MenuManager(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.edit.copy.special"));
        extCopyMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.edit.copy.special"));
        extCopyMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyColumnNames"));
        if (row != null) {
            extCopyMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyRowNames"));
        }
        manager.add((IContributionItem)extCopyMenu);
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.paste"));
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.edit.paste.special"));
        manager.add((IContributionItem)new Separator());
        if (valueController != null) {
            MenuManager editMenu = new MenuManager(CoreMessages.actions_menu_edit, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_EDIT), "edit");
            editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit"));
            editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit.inline"));
            if (!valueController.isReadOnly() && !DBUtils.isNullValue((Object)value)) {
                editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.setNull"));
            }
            if (row.getState() == 3 || row.changes != null && row.changes.containsKey(attr)) {
                editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.reset"));
            }
            try {
                valueController.getValueManager().contributeActions((IContributionManager)editMenu, valueController, null);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.add"));
            editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy"));
            editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.delete"));
            manager.add((IContributionItem)editMenu);
        }
        manager.add((IContributionItem)new GroupMarker("edit"));
        MenuManager filtersMenu = new MenuManager(CoreMessages.controls_resultset_viewer_action_order_filter, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER), "filters");
        filtersMenu.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.filterMenu");
        filtersMenu.setRemoveAllWhenShown(true);
        filtersMenu.addMenuListener(manager1 -> this.fillFiltersMenu(attr, manager1));
        manager.add((IContributionItem)filtersMenu);
        if (dataSource != null && attr != null && this.model.getVisibleAttributeCount() > 0 && !this.model.isUpdateInProgress()) {
            MenuManager refTablesMenu;
            MenuManager viewMenu = new MenuManager(CoreMessages.controls_resultset_viewer_action_view_format, null, "view");
            List transformers = dataSource.getContainer().getPlatform().getValueHandlerRegistry().findTransformers(dataSource, (DBSTypedObject)attr, null);
            if (!CommonUtils.isEmpty((Collection)transformers)) {
                MenuManager transformersMenu = new MenuManager(CoreMessages.controls_resultset_viewer_action_view_as);
                transformersMenu.setRemoveAllWhenShown(true);
                transformersMenu.addMenuListener(manager12 -> this.fillAttributeTransformersMenu(manager12, attr));
                viewMenu.add((IContributionItem)transformersMenu);
            } else {
                Action customizeAction = new Action(CoreMessages.controls_resultset_viewer_action_view_as){};
                customizeAction.setEnabled(false);
                viewMenu.add((IAction)customizeAction);
            }
            viewMenu.add((IAction)new TransformComplexTypesToggleAction());
            viewMenu.add((IAction)new ColorizeDataTypesToggleAction());
            if (this.getModel().isSingleSource()) {
                if (valueController != null) {
                    viewMenu.add((IAction)new SetRowColorAction(attr, valueController.getValue()));
                    if (this.getModel().hasColorMapping(attr)) {
                        viewMenu.add((IAction)new ResetRowColorAction(attr, valueController.getValue()));
                    }
                }
                viewMenu.add((IAction)new CustomizeColorsAction(attr, row));
                if (this.getModel().getSingleSource() != null && this.getModel().hasColorMapping(this.getModel().getSingleSource())) {
                    viewMenu.add((IAction)new ResetAllColorAction());
                }
                viewMenu.add((IContributionItem)new Separator());
            }
            viewMenu.add((IAction)new Action(CoreMessages.controls_resultset_viewer_action_data_formats){

                public void run() {
                    UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.dataformat"});
                }
            });
            manager.add((IContributionItem)viewMenu);
            MenuManager navigateMenu = new MenuManager(CoreMessages.controls_resultset_viewer_action_navigate, null, "navigate");
            boolean hasNavTables = false;
            if (ActionUtils.isCommandEnabled((String)"org.jkiss.dbeaver.core.resultset.navigateLink", (IWorkbenchPartSite)this.site)) {
                navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.navigateLink"));
                hasNavTables = true;
            }
            if (this.model.isSingleSource() && (refTablesMenu = this.createRefTablesMenu(row, false)) != null) {
                navigateMenu.add((IContributionItem)refTablesMenu);
                hasNavTables = true;
            }
            if (hasNavTables) {
                navigateMenu.add((IContributionItem)new Separator());
            }
            navigateMenu.add((IContributionItem)new Separator());
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.focus.filter"));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.text.goto.line"));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.first"));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.next"));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.previous"));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.last"));
            navigateMenu.add((IContributionItem)new Separator());
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.page"));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.all"));
            if (this.isHasMoreData() && this.getDataContainer() != null && (this.getDataContainer().getSupportedFeatures() & 1) != 0) {
                navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.count"));
            }
            navigateMenu.add((IContributionItem)new Separator());
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.navigate.backwardHistory", (int)8, (DBPImage)UIIcon.RS_BACK));
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.navigate.forwardHistory", (int)8, (DBPImage)UIIcon.RS_FORWARD));
            manager.add((IContributionItem)navigateMenu);
        }
        MenuManager layoutMenu = new MenuManager(CoreMessages.controls_resultset_viewer_action_layout, null, "layout");
        layoutMenu.add((IAction)new ToggleModeAction());
        layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview"));
        layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.toggleLayout"));
        layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.switchPresentation"));
        MenuManager panelsMenu = new MenuManager(CoreMessages.controls_resultset_viewer_action_panels, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PANEL_CUSTOMIZE), "result_panels");
        layoutMenu.add((IContributionItem)panelsMenu);
        for (IContributionItem item : this.fillPanelsMenu()) {
            panelsMenu.add(item);
        }
        layoutMenu.add((IContributionItem)new GroupMarker(TOOLBAR_GROUP_ADDITIONS));
        layoutMenu.add((IContributionItem)new Separator());
        for (ResultSetPresentationDescriptor pd : this.getAvailablePresentations()) {
            Action psAction = new Action(pd.getLabel(), 2, pd){
                ResultSetPresentationDescriptor presentation;
                {
                    this.presentation = resultSetPresentationDescriptor;
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)this.presentation.getIcon()));
                }

                public boolean isChecked() {
                    return ResultSetViewer.this.activePresentationDescriptor == this.presentation;
                }

                public void run() {
                    ResultSetViewer.this.switchPresentation(this.presentation);
                }
            };
            layoutMenu.add((IAction)psAction);
        }
        manager.add((IContributionItem)layoutMenu);
        manager.add((IContributionItem)new Separator());
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && this.model.hasData()) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.export"));
        }
        manager.add((IContributionItem)new GroupMarker("results_export"));
        manager.add((IContributionItem)new GroupMarker("tools"));
        if (dataContainer != null && this.model.hasData()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.file.refresh"));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker(TOOLBAR_GROUP_ADDITIONS));
        this.decorator.fillContributions((IContributionManager)manager);
    }

    @Nullable
    private MenuManager createRefTablesMenu(ResultSetRow row, boolean openInNewWindow) {
        DBSEntity singleSource = this.model.getSingleSource();
        if (singleSource == null) {
            return null;
        }
        String menuName = ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.referencesMenu");
        MenuManager refTablesMenu = new MenuManager(menuName, null, "ref-tables");
        refTablesMenu.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.referencesMenu");
        refTablesMenu.add((IAction)ResultSetReferenceMenu.NOREFS_ACTION);
        refTablesMenu.addMenuListener(manager -> ResultSetReferenceMenu.fillRefTablesActions(this, row, singleSource, manager, openInNewWindow));
        return refTablesMenu;
    }

    @Nullable
    private DBPDataSource getDataSource() {
        return this.getDataContainer() == null ? null : this.getDataContainer().getDataSource();
    }

    private void fillAttributeTransformersMenu(IMenuManager manager, final DBDAttributeBinding attr) {
        List applicableTransformers;
        List customTransformers;
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            return;
        }
        DBPDataSource dataSource = dataContainer.getDataSource();
        DBDRegistry registry = dataSource.getContainer().getPlatform().getValueHandlerRegistry();
        final DBVTransformSettings transformSettings = DBVUtils.getTransformSettings((DBDAttributeBinding)attr, (boolean)false);
        DBDAttributeTransformerDescriptor customTransformer = null;
        if (transformSettings != null && transformSettings.getCustomTransformer() != null) {
            customTransformer = registry.getTransformer(transformSettings.getCustomTransformer());
        }
        if ((customTransformers = registry.findTransformers(dataSource, (DBSTypedObject)attr, Boolean.valueOf(true))) != null && !customTransformers.isEmpty()) {
            manager.add((IAction)new TransformerAction(this, attr, "Default", 8, transformSettings == null || CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())){

                public void run() {
                    if (this.isChecked()) {
                        this.getTransformSettings().setCustomTransformer(null);
                        this.saveTransformerSettings();
                    }
                }
            });
            for (final DBDAttributeTransformerDescriptor descriptor : customTransformers) {
                TransformerAction action = new TransformerAction(this, attr, descriptor.getName(), 8, transformSettings != null && descriptor.getId().equals(transformSettings.getCustomTransformer())){

                    public void run() {
                        if (this.isChecked()) {
                            DBVTransformSettings settings = this.getTransformSettings();
                            String oldCustomTransformer = settings.getCustomTransformer();
                            settings.setCustomTransformer(descriptor.getId());
                            TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(this, attr, settings);
                            if (settingsDialog.open() == 0) {
                                this.saveTransformerSettings();
                            } else {
                                settings.setCustomTransformer(oldCustomTransformer);
                            }
                        }
                    }
                };
                manager.add((IAction)action);
            }
        }
        if (customTransformer != null && !CommonUtils.isEmpty((Collection)customTransformer.getProperties())) {
            manager.add((IAction)new TransformerAction(this, attr, "Settings ...", 0, false){

                public void run() {
                    TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(this, attr, transformSettings);
                    if (settingsDialog.open() == 0) {
                        this.saveTransformerSettings();
                    }
                }
            });
        }
        if ((applicableTransformers = registry.findTransformers(dataSource, (DBSTypedObject)attr, Boolean.valueOf(false))) != null) {
            manager.add((IContributionItem)new Separator());
            for (final DBDAttributeTransformerDescriptor descriptor : applicableTransformers) {
                boolean checked = transformSettings != null ? (descriptor.isApplicableByDefault() ? !transformSettings.isExcluded(descriptor.getId()) : transformSettings.isIncluded(descriptor.getId())) : descriptor.isApplicableByDefault();
                manager.add((IAction)new TransformerAction(this, attr, descriptor.getName(), 2, checked){

                    public void run() {
                        this.getTransformSettings().enableTransformer(descriptor, !this.isChecked());
                        this.saveTransformerSettings();
                    }
                });
            }
        }
    }

    private void fillFiltersMenu(@Nullable DBDAttributeBinding attribute, @NotNull IMenuManager filtersMenu) {
        if (attribute != null && this.supportsDataFilter()) {
            DBCLogicalOperator operator;
            DBCLogicalOperator[] operators;
            filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterMenu.distinct"));
            Object[] objectArray = operators = attribute.getValueHandler().getSupportedOperators((DBSTypedObject)attribute);
            int n = operators.length;
            int n2 = 0;
            while (n2 < n) {
                operator = objectArray[n2];
                if (operator.getArgumentCount() < 0) {
                    filtersMenu.add((IAction)new FilterByAttributeAction(operator, FilterByAttributeType.INPUT, attribute));
                }
                ++n2;
            }
            filtersMenu.add((IContributionItem)new Separator());
            objectArray = operators;
            n = operators.length;
            n2 = 0;
            while (n2 < n) {
                operator = objectArray[n2];
                if (operator.getArgumentCount() == 0) {
                    filtersMenu.add((IAction)new FilterByAttributeAction(operator, FilterByAttributeType.NONE, attribute));
                }
                ++n2;
            }
            objectArray = FilterByAttributeType.values();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                DBCLogicalOperator type = objectArray[n2];
                if (type != FilterByAttributeType.NONE) {
                    filtersMenu.add((IContributionItem)new Separator());
                    if (type.getValue(this, attribute, DBCLogicalOperator.EQUALS, true) != null) {
                        DBCLogicalOperator[] dBCLogicalOperatorArray = operators;
                        int n3 = operators.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            DBCLogicalOperator operator2 = dBCLogicalOperatorArray[n4];
                            if (operator2.getArgumentCount() > 0) {
                                filtersMenu.add((IAction)new FilterByAttributeAction(operator2, (FilterByAttributeType)type, attribute));
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            filtersMenu.add((IContributionItem)new Separator());
            DBDAttributeConstraint constraint = this.model.getDataFilter().getConstraint(attribute);
            if (constraint != null && constraint.hasCondition()) {
                filtersMenu.add((IAction)new FilterResetAttributeAction(attribute));
            }
        }
        if (attribute != null) {
            filtersMenu.add((IContributionItem)new Separator());
            filtersMenu.add((IAction)new OrderByAttributeAction(attribute, true));
            filtersMenu.add((IAction)new OrderByAttributeAction(attribute, false));
            filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.toggleOrder"));
        }
        filtersMenu.add((IContributionItem)new Separator());
        filtersMenu.add((IAction)new ToggleServerSideOrderingAction());
        filtersMenu.add((IAction)new ShowFiltersAction(true));
    }

    @Override
    public void navigateAssociation(@NotNull DBRProgressMonitor monitor, @Nullable DBSEntityAssociation association, @Nullable DBDAttributeBinding attr, @NotNull ResultSetRow row, boolean newWindow) throws DBException {
        DBSEntityConstraint refConstraint;
        if (!this.confirmProceed()) {
            return;
        }
        if (!newWindow && !this.confirmPanelsReset()) {
            return;
        }
        if (this.getExecutionContext() == null) {
            throw new DBException("Not connected");
        }
        if (association == null) {
            List referrers = attr.getReferrers();
            if (referrers != null) {
                for (DBSEntityReferrer referrer : referrers) {
                    if (!(referrer instanceof DBSEntityAssociation)) continue;
                    association = (DBSEntityAssociation)referrer;
                    break;
                }
            }
            if (association == null) {
                throw new DBException("Association not found in attribute [" + attr.getName() + "]");
            }
        }
        if ((refConstraint = association.getReferencedConstraint()) == null) {
            throw new DBException("Broken association (referenced constraint missing)");
        }
        if (!(refConstraint instanceof DBSEntityReferrer)) {
            throw new DBException("Referenced constraint [" + refConstraint + "] is not a referrer");
        }
        DBSEntity targetEntity = refConstraint.getParentObject();
        if (targetEntity == null) {
            throw new DBException("Null constraint parent");
        }
        if (!(targetEntity instanceof DBSDataContainer)) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is not a data container");
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        int visualPosition = 0;
        List ownAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)association).getAttributeReferences(monitor));
        List refAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)refConstraint).getAttributeReferences(monitor));
        if (ownAttrs.size() != refAttrs.size()) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] association [" + association.getName() + "] columns differs from referenced constraint [" + refConstraint.getName() + "] (" + ownAttrs.size() + "<>" + refAttrs.size() + ")");
        }
        int i = 0;
        while (i < ownAttrs.size()) {
            DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownAttrs.get(i);
            DBSEntityAttributeRef refAttr = (DBSEntityAttributeRef)refAttrs.get(i);
            DBDAttributeBinding ownBinding = this.model.getAttributeBinding((DBSAttributeBase)ownAttr.getAttribute());
            if (ownBinding == null) {
                DBUserInterface.getInstance().showError("Can't navigate", "Attribute " + ownAttr.getAttribute() + " is missing in result set");
                return;
            }
            DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)refAttr.getAttribute(), visualPosition++);
            constraint.setVisible(true);
            constraints.add(constraint);
            Object keyValue = this.model.getCellValue(ownBinding, row);
            constraint.setOperator(DBCLogicalOperator.EQUALS);
            constraint.setValue(keyValue);
            ++i;
        }
        this.curState.filter = new DBDDataFilter(this.model.getDataFilter());
        this.navigateEntity(monitor, newWindow, targetEntity, constraints);
    }

    @Override
    public void navigateReference(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association, @NotNull ResultSetRow row, boolean newWindow) throws DBException {
        if (!this.confirmProceed()) {
            return;
        }
        if (this.getExecutionContext() == null) {
            throw new DBException("Not connected");
        }
        DBSEntity targetEntity = association.getParentObject();
        if (targetEntity == null) {
            throw new DBException("Null constraint parent");
        }
        if (!(targetEntity instanceof DBSDataContainer)) {
            throw new DBException("Referencing entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is not a data container");
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        int visualPosition = 0;
        DBSEntityConstraint refConstraint = association.getReferencedConstraint();
        if (refConstraint == null) {
            throw new DBException("Can't obtain association '" + DBUtils.getQuotedIdentifier((DBSObject)association) + "' target constraint (table " + (association.getAssociatedEntity() == null ? "???" : DBUtils.getQuotedIdentifier((DBSObject)association.getAssociatedEntity())) + ")");
        }
        List ownAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)association).getAttributeReferences(monitor));
        List refAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)refConstraint).getAttributeReferences(monitor));
        if (ownAttrs.size() != refAttrs.size()) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] association [" + association.getName() + "] columns differ from referenced constraint [" + refConstraint.getName() + "] (" + ownAttrs.size() + "<>" + refAttrs.size() + ")");
        }
        if (ownAttrs.isEmpty()) {
            throw new DBException("Association '" + DBUtils.getQuotedIdentifier((DBSObject)association) + "' has empty column list");
        }
        int i = 0;
        while (i < refAttrs.size()) {
            DBSEntityAttributeRef refAttr = (DBSEntityAttributeRef)refAttrs.get(i);
            DBDAttributeBinding attrBinding = this.model.getAttributeBinding((DBSAttributeBase)refAttr.getAttribute());
            if (attrBinding == null) {
                log.error((Object)("Can't find attribute binding for ref attribute '" + refAttr.getAttribute().getName() + "'"));
            } else {
                DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownAttrs.get(i);
                DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)ownAttr.getAttribute(), visualPosition++);
                constraint.setVisible(true);
                constraints.add(constraint);
                Object keyValue = this.model.getCellValue(attrBinding, row);
                constraint.setOperator(DBCLogicalOperator.EQUALS);
                constraint.setValue(keyValue);
            }
            ++i;
        }
        this.navigateEntity(monitor, newWindow, targetEntity, constraints);
    }

    private void navigateEntity(@NotNull DBRProgressMonitor monitor, boolean newWindow, DBSEntity targetEntity, List<DBDAttributeConstraint> constraints) {
        DBDDataFilter newFilter = new DBDDataFilter(constraints);
        if (newWindow) {
            this.openResultsInNewWindow(monitor, targetEntity, newFilter);
        } else {
            DBSDataContainer targetDataContainer = (DBSDataContainer)targetEntity;
            if (this.curState == null) {
                this.setNewState(targetDataContainer, this.model.getDataFilter());
            }
            this.runDataPump(targetDataContainer, newFilter, 0, this.getSegmentMaxRows(), -1, true, false, null);
        }
    }

    private boolean confirmProceed() {
        return new UIConfirmation(){

            public Boolean runTask() {
                return ResultSetViewer.this.checkForChanges();
            }
        }.confirm();
    }

    private boolean confirmPanelsReset() {
        return new UIConfirmation(){

            public Boolean runTask() {
                int result;
                boolean panelsDirty = false;
                IResultSetPanel[] iResultSetPanelArray = ResultSetViewer.this.getActivePanels();
                int n = iResultSetPanelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResultSetPanel panel = iResultSetPanelArray[n2];
                    if (panel.isDirty()) {
                        panelsDirty = true;
                        break;
                    }
                    ++n2;
                }
                if (panelsDirty && (result = ConfirmationDialog.showConfirmDialog(ResultSetViewer.this.viewerPanel.getShell(), "reset_panels_content", 5, new Object[0])) == 1) {
                    return false;
                }
                return true;
            }
        }.confirm();
    }

    private void openResultsInNewWindow(DBRProgressMonitor monitor, DBSEntity targetEntity, DBDDataFilter newFilter) {
        if (targetEntity instanceof DBSDataContainer) {
            this.getContainer().openNewContainer(monitor, (DBSDataContainer)targetEntity, newFilter);
        } else {
            UIUtils.showMessageBox(null, (String)"Open link", (String)("Target entity '" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' - is not a data container"), (int)1);
        }
    }

    @Override
    public int getHistoryPosition() {
        return this.historyPosition;
    }

    @Override
    public int getHistorySize() {
        return this.stateHistory.size();
    }

    @Override
    public void navigateHistory(int position) {
        if (position < 0 || position >= this.stateHistory.size()) {
            log.debug((Object)("Wrong history position: " + position));
            return;
        }
        HistoryStateItem state = this.stateHistory.get(position);
        int segmentSize = this.getSegmentMaxRows();
        if (state.rowNumber >= 0 && state.rowNumber >= segmentSize && segmentSize > 0) {
            segmentSize = (state.rowNumber / segmentSize + 1) * segmentSize;
        }
        this.runDataPump(state.dataContainer, state.filter, 0, segmentSize, state.rowNumber, true, false, null);
    }

    @Override
    public void updatePanelsContent(boolean forceRefresh) {
        this.updateEditControls();
        IResultSetPanel[] iResultSetPanelArray = this.getActivePanels();
        int n = iResultSetPanelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetPanel panel = iResultSetPanelArray[n2];
            panel.refresh(forceRefresh);
            ++n2;
        }
    }

    @Override
    public void updatePanelActions() {
        IResultSetPanel visiblePanel = this.getVisiblePanel();
        this.panelToolBar.removeAll();
        if (visiblePanel != null) {
            visiblePanel.contributeActions(this.panelToolBar);
        }
        this.addDefaultPanelActions();
        this.panelToolBar.update(true);
        if (this.panelFolder != null) {
            ToolBar toolBar = this.panelToolBar.getControl();
            Point toolBarSize = toolBar.computeSize(-1, -1);
            this.panelFolder.setTabHeight(toolBarSize.y);
        }
    }

    @Override
    public Composite getControl() {
        return this.viewerPanel;
    }

    @Override
    @NotNull
    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    @Override
    @NotNull
    public ResultSetModel getModel() {
        return this.model;
    }

    public ResultSetModel getInput() {
        return this.model;
    }

    public void setInput(Object input) {
        throw new IllegalArgumentException("ResultSet model can't be changed");
    }

    @Override
    @NotNull
    public IResultSetSelection getSelection() {
        if (this.activePresentation instanceof ISelectionProvider) {
            ISelection selection = ((ISelectionProvider)this.activePresentation).getSelection();
            if (selection.isEmpty()) {
                return new EmptySelection();
            }
            if (selection instanceof IResultSetSelection) {
                return (IResultSetSelection)selection;
            }
            log.debug((Object)("Bad selection type (" + selection + ") in presentation " + this.activePresentation));
        }
        return new EmptySelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.activePresentation instanceof ISelectionProvider) {
            ((ISelectionProvider)this.activePresentation).setSelection(selection);
        }
    }

    @Override
    @NotNull
    public ResultSetDataReceiver getDataReceiver() {
        return this.dataReceiver;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.container.getExecutionContext();
    }

    @Override
    public boolean checkForChanges() {
        if (this.isDirty()) {
            int checkResult = (Integer)new UITask<Integer>(){

                protected Integer runTask() {
                    return ResultSetViewer.this.promptToSaveOnClose();
                }
            }.execute();
            switch (checkResult) {
                case 2: {
                    return false;
                }
                case 0: {
                    this.applyChanges(null, success -> {
                        if (success) {
                            UIUtils.asyncExec(() -> {
                                boolean bl = this.refreshData(null);
                            });
                        }
                    });
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void refresh() {
        if (!this.checkForChanges()) {
            return;
        }
        this.autoRefreshControl.enableAutoRefresh(false);
        DBSDataContainer dataContainer = this.getDataContainer();
        DBDDataFilter dataFilter = this.restoreDataFilter(dataContainer);
        if (this.container.isReadyToRun() && dataContainer != null && this.dataPumpJob == null) {
            int segmentSize = this.getSegmentMaxRows();
            Runnable finalizer = () -> {
                if (this.activePresentation.getControl() != null && !this.activePresentation.getControl().isDisposed()) {
                    this.activePresentation.formatData(true);
                }
            };
            this.dataReceiver.setNextSegmentRead(false);
            this.runDataPump(dataContainer, dataFilter, 0, segmentSize, -1, true, false, finalizer);
        } else {
            DBUserInterface.getInstance().showError("Error executing query", dataContainer == null ? "Viewer detached from data source" : (this.dataPumpJob == null ? "Can't refresh after reconnect. Re-execute query." : "Previous query is still running"));
        }
    }

    private DBDDataFilter restoreDataFilter(DBSDataContainer dataContainer) {
        DataFilterRegistry.SavedDataFilter savedConfig = DataFilterRegistry.getInstance().getSavedConfig(dataContainer);
        if (savedConfig != null) {
            DBDDataFilter dataFilter = new DBDDataFilter();
            DBRRunnableWithProgress restoreTask = monitor -> {
                try {
                    savedConfig.restoreDataFilter(monitor, dataContainer, dataFilter);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            };
            RuntimeUtils.runTask((DBRRunnableWithProgress)restoreTask, (String)"Restore data filter", (long)60000L);
            if (dataFilter.hasFilters()) {
                return dataFilter;
            }
        }
        return null;
    }

    public void refreshWithFilter(DBDDataFilter filter) {
        if (!this.checkForChanges()) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            this.dataReceiver.setNextSegmentRead(false);
            this.runDataPump(dataContainer, filter, 0, this.getSegmentMaxRows(), this.curRow == null ? -1 : this.curRow.getRowNumber(), true, false, null);
        }
    }

    @Override
    public boolean refreshData(@Nullable Runnable onSuccess) {
        if (!this.checkForChanges()) {
            return false;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (this.container.isReadyToRun() && dataContainer != null && this.dataPumpJob == null) {
            int segmentSize = this.getSegmentMaxRows();
            if (this.curRow != null && this.curRow.getVisualNumber() >= segmentSize && segmentSize > 0) {
                segmentSize = (this.curRow.getVisualNumber() / segmentSize + 1) * segmentSize;
            }
            this.dataReceiver.setNextSegmentRead(false);
            return this.runDataPump(dataContainer, null, 0, segmentSize, this.curRow == null ? 0 : this.curRow.getRowNumber(), false, false, onSuccess);
        }
        return false;
    }

    @Override
    public synchronized void readNextSegment() {
        if (!this.dataReceiver.isHasMoreData()) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && !this.model.isUpdateInProgress() && this.dataPumpJob == null) {
            this.dataReceiver.setHasMoreData(false);
            this.dataReceiver.setNextSegmentRead(true);
            this.runDataPump(dataContainer, this.model.getDataFilter(), this.model.getRowCount(), this.getSegmentMaxRows(), -1, false, true, null);
        }
    }

    @Override
    public void readAllData() {
        if (!this.dataReceiver.isHasMoreData()) {
            return;
        }
        if (ConfirmationDialog.showConfirmDialogEx(this.viewerPanel.getShell(), "fetch_all_rows", 3, 4, new Object[0]) != 2) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && !this.model.isUpdateInProgress() && this.dataPumpJob == null) {
            this.dataReceiver.setHasMoreData(false);
            this.dataReceiver.setNextSegmentRead(true);
            this.runDataPump(dataContainer, this.model.getDataFilter(), this.model.getRowCount(), -1, this.curRow == null ? -1 : this.curRow.getRowNumber(), false, true, null);
        }
    }

    void updateRowCount() {
        this.rowCountLabel.executeAction();
    }

    private long readRowCount(DBRProgressMonitor monitor) throws DBException {
        DBCExecutionContext executionContext = this.getExecutionContext();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (executionContext == null || dataContainer == null) {
            throw new DBException("Not connected");
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.USER, "Read total row count");){
            long rowCount = dataContainer.countData((DBCExecutionSource)new AbstractExecutionSource(dataContainer, executionContext, (Object)this), session, this.model.getDataFilter(), 0L);
            this.model.setTotalRowCount(rowCount);
            return rowCount;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getSegmentMaxRows() {
        if (this.getDataContainer() == null) {
            return 0;
        }
        return this.getPreferenceStore().getInt("resultset.maxrows");
    }

    private synchronized boolean runDataPump(final @NotNull DBSDataContainer dataContainer, final @Nullable DBDDataFilter dataFilter, int offset, int maxRows, final int focusRow, final boolean saveHistory, final boolean scroll, final @Nullable Runnable finalizer) {
        if (this.dataPumpJob != null) {
            UIUtils.showMessageBox((Shell)this.viewerPanel.getShell(), (String)"Data read", (String)"Data read is in progress - can't run another", (int)8);
            return false;
        }
        if (this.viewerPanel.isDisposed()) {
            return false;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            UIUtils.showMessageBox((Shell)this.viewerPanel.getShell(), (String)"Data read", (String)"Can't read data - no active connection", (int)8);
            return false;
        }
        this.autoRefreshControl.cancelRefresh();
        DBDDataFilter useDataFilter = dataFilter != null ? dataFilter : (dataContainer == this.getDataContainer() ? this.model.getDataFilter() : null);
        Composite progressControl = this.viewerPanel;
        if (this.activePresentation.getControl() instanceof Composite) {
            progressControl = (Composite)this.activePresentation.getControl();
        }
        final Object presentationState = this.savePresentationState();
        this.dataReceiver.setFocusRow(focusRow);
        this.dataReceiver.setTargetDataContainer(dataContainer);
        this.dataPumpJob = new ResultSetJobDataRead(dataContainer, useDataFilter, this, executionContext, progressControl);
        this.dataPumpJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                ResultSetViewer.this.model.setUpdateInProgress(true);
                ResultSetViewer.this.model.setStatistics(null);
                if (ResultSetViewer.this.filtersPanel != null) {
                    UIUtils.syncExec(() -> ResultSetViewer.this.filtersPanel.enableFilters(false));
                }
            }

            public void done(IJobChangeEvent event) {
                Composite control;
                ResultSetJobDataRead job = (ResultSetJobDataRead)event.getJob();
                Throwable error = job.getError();
                if (job.getStatistics() != null) {
                    ResultSetViewer.this.model.setStatistics(job.getStatistics());
                }
                if ((control = ResultSetViewer.this.getControl()).isDisposed()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    try {
                        Composite control1 = ResultSetViewer.this.getControl();
                        if (control1.isDisposed()) {
                            return;
                        }
                        ResultSetViewer.this.model.setUpdateInProgress(false);
                        boolean metadataChanged = ResultSetViewer.this.model.isMetadataChanged();
                        if (error != null) {
                            ResultSetViewer.this.setStatus(error.getMessage(), DBPMessageType.ERROR);
                            DBUserInterface.getInstance().showError("Error executing query", "Query execution failed", error);
                        } else if (!metadataChanged && focusRow >= 0 && focusRow < ResultSetViewer.this.model.getRowCount() && ResultSetViewer.this.model.getVisibleAttributeCount() > 0) {
                            ResultSetViewer.this.restorePresentationState(presentationState);
                        }
                        if (metadataChanged) {
                            ResultSetViewer.this.activePresentation.updateValueView();
                        }
                        ResultSetViewer.this.updatePanelsContent(false);
                        if (!scroll) {
                            if (saveHistory && error == null) {
                                ResultSetViewer.this.setNewState(dataContainer, dataFilter);
                            }
                            if (dataFilter != null) {
                                ResultSetViewer.this.model.updateDataFilter(dataFilter);
                                ResultSetViewer.this.redrawData(true, false);
                            }
                        }
                        if (job.getStatistics() == null || !job.getStatistics().isEmpty()) {
                            if (error == null) {
                                ResultSetViewer.this.updateStatusMessage();
                            }
                            ResultSetViewer.this.updateFiltersText(true);
                            ResultSetViewer.this.updateToolbar();
                            ResultSetViewer.this.fireResultSetLoad();
                        }
                        ResultSetViewer.this.autoRefreshControl.scheduleAutoRefresh(error != null);
                    }
                    finally {
                        if (finalizer != null) {
                            try {
                                finalizer.run();
                            }
                            catch (Throwable e) {
                                log.error((Object)e);
                            }
                        }
                        ResultSetViewer.this.dataPumpJob = null;
                    }
                });
            }
        });
        this.dataPumpJob.setOffset(offset);
        this.dataPumpJob.setMaxRows(maxRows);
        this.dataPumpJob.schedule();
        return true;
    }

    private void clearData() {
        this.model.clearData();
        this.curRow = null;
        this.activePresentation.clearMetaData();
    }

    @Override
    public boolean applyChanges(@Nullable DBRProgressMonitor monitor) {
        return this.applyChanges(monitor, null);
    }

    private boolean applyChanges(@Nullable DBRProgressMonitor monitor, @Nullable ResultSetPersister.DataUpdateListener listener) {
        UIUtils.syncExec(() -> this.getActivePresentation().applyChanges());
        try {
            ResultSetPersister persister = this.createDataPersister(false);
            ResultSetPersister.DataUpdateListener applyListener = success -> {
                if (listener != null) {
                    listener.onUpdate(success);
                }
                if (success && this.getPreferenceStore().getBoolean("resultset.edit.refreshAfterUpdate")) {
                    try {
                        persister.refreshInsertedRows();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error refreshing rows after update", e);
                    }
                }
            };
            return persister.applyChanges(monitor, false, applyListener);
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Apply changes error", "Error saving changes in database", (Throwable)e);
            return false;
        }
    }

    @Override
    public void rejectChanges() {
        if (!this.isDirty()) {
            return;
        }
        try {
            this.createDataPersister(true).rejectChanges();
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    }

    @Override
    public List<DBEPersistAction> generateChangesScript(@NotNull DBRProgressMonitor monitor) {
        try {
            ResultSetPersister persister = this.createDataPersister(false);
            persister.applyChanges(monitor, true, null);
            return persister.getScript();
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("SQL script generate error", "Error saving changes in database", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private ResultSetPersister createDataPersister(boolean skipKeySearch) throws DBException {
        boolean needPK = false;
        if (!skipKeySearch) {
            for (ResultSetRow row : this.model.getAllRows()) {
                if (row.getState() != 3 && (row.getState() != 1 || !row.isChanged())) continue;
                needPK = true;
                break;
            }
        }
        ResultSetPersister persister = new ResultSetPersister(this);
        if (needPK) {
            this.checkEntityIdentifiers(persister);
        }
        return persister;
    }

    @Override
    @NotNull
    public ResultSetRow addNewRow(boolean copyCurrent, boolean afterCurrent, boolean updatePresentation) {
        DBCExecutionContext executionContext;
        int initRowCount;
        ArrayList<ResultSetRow> selectedRows = new ArrayList<ResultSetRow>(this.getSelection().getSelectedRows());
        int rowNum = this.curRow == null ? 0 : this.curRow.getVisualNumber();
        if (rowNum >= (initRowCount = this.model.getRowCount())) {
            rowNum = initRowCount - 1;
        }
        if (rowNum < 0) {
            rowNum = 0;
        }
        if ((executionContext = this.getExecutionContext()) == null) {
            throw new IllegalStateException("Can't add/copy rows in disconnected results");
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (DBCSession session = executionContext.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, CoreMessages.controls_resultset_viewer_add_new_row_context_name);){
            int newRowIndex;
            int[] rowsToCopy;
            DBDAttributeBinding docAttribute = this.model.getDocumentAttribute();
            DBDAttributeBinding[] attributes = this.model.getAttributes();
            if (selectedRows.size() > 1) {
                rowsToCopy = new int[selectedRows.size()];
                int i = 0;
                while (i < selectedRows.size()) {
                    rowsToCopy[i] = ((ResultSetRow)selectedRows.get(i)).getVisualNumber();
                    ++i;
                }
                rowNum = rowsToCopy[0];
            } else {
                rowsToCopy = new int[]{rowNum};
            }
            int n = newRowIndex = afterCurrent ? rowNum + rowsToCopy.length : rowNum;
            if (newRowIndex > initRowCount) {
                newRowIndex = initRowCount;
            }
            int rowIndex = rowsToCopy.length - 1;
            int rowCount = 0;
            while (rowIndex >= 0) {
                Object[] cells;
                int currentRowNumber = rowsToCopy[rowIndex];
                if (!afterCurrent) {
                    currentRowNumber += rowCount;
                }
                if (docAttribute != null) {
                    cells = new Object[1];
                    if (copyCurrent && currentRowNumber >= 0 && currentRowNumber < this.model.getRowCount()) {
                        Object[] origRow = this.model.getRowData(currentRowNumber);
                        try {
                            cells[0] = docAttribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)docAttribute, origRow[0], true);
                        }
                        catch (DBCException e) {
                            log.warn((Object)e);
                        }
                    }
                    if (cells[0] == null) {
                        try {
                            cells[0] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)docAttribute.getValueHandler(), (DBSTypedObject)docAttribute.getAttribute());
                        }
                        catch (DBCException e) {
                            log.warn((Object)e);
                        }
                    }
                } else {
                    cells = new Object[attributes.length];
                    if (copyCurrent && currentRowNumber >= 0 && currentRowNumber < this.model.getRowCount()) {
                        Object[] origRow = this.model.getRowData(currentRowNumber);
                        int i = 0;
                        while (i < attributes.length) {
                            DBDAttributeBinding metaAttr = attributes[i];
                            if (metaAttr.isPseudoAttribute() || metaAttr.isAutoGenerated()) {
                                cells[i] = null;
                            } else {
                                DBSAttributeBase attribute = metaAttr.getAttribute();
                                try {
                                    cells[i] = metaAttr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute, origRow[i], true);
                                }
                                catch (DBCException e) {
                                    log.warn((Object)e);
                                    try {
                                        cells[i] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)metaAttr.getValueHandler(), (DBSTypedObject)attribute);
                                    }
                                    catch (DBCException e1) {
                                        log.warn((Object)e1);
                                    }
                                }
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < attributes.length) {
                            DBDAttributeBinding metaAttr = attributes[i];
                            try {
                                cells[i] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)metaAttr.getValueHandler(), (DBSTypedObject)metaAttr.getAttribute());
                            }
                            catch (DBCException e) {
                                log.warn((Object)e);
                            }
                            ++i;
                        }
                    }
                }
                this.curRow = this.model.addNewRow(newRowIndex, cells);
                --rowIndex;
                ++rowCount;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (updatePresentation) {
            this.redrawData(false, true);
            this.updateEditControls();
            this.fireResultSetChange();
        }
        return this.curRow;
    }

    void deleteSelectedRows() {
        LinkedHashSet<ResultSetRow> rowsToDelete = new LinkedHashSet<ResultSetRow>();
        if (this.recordMode) {
            rowsToDelete.add(this.curRow);
        } else {
            IResultSetSelection selection = this.getSelection();
            if (!selection.isEmpty()) {
                rowsToDelete.addAll(selection.getSelectedRows());
            }
        }
        if (rowsToDelete.isEmpty()) {
            return;
        }
        int rowsRemoved = 0;
        int lastRowNum = -1;
        for (ResultSetRow row : rowsToDelete) {
            if (this.model.deleteRow(row)) {
                ++rowsRemoved;
            }
            lastRowNum = row.getVisualNumber();
        }
        this.redrawData(false, rowsRemoved > 0);
        if (!this.recordMode && lastRowNum < this.model.getRowCount() - 1 && rowsRemoved == 0) {
            this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.NEXT);
        } else {
            this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
        }
        this.updateEditControls();
        this.fireResultSetChange();
    }

    @Nullable
    DBDRowIdentifier getVirtualEntityIdentifier() {
        DBSEntityReferrer identifier;
        if (!this.model.isSingleSource() || this.model.getVisibleAttributeCount() == 0) {
            return null;
        }
        DBDRowIdentifier rowIdentifier = this.model.getVisibleAttribute(0).getRowIdentifier();
        DBSEntityReferrer dBSEntityReferrer = identifier = rowIdentifier == null ? null : rowIdentifier.getUniqueKey();
        if (identifier != null && identifier instanceof DBVEntityConstraint) {
            return rowIdentifier;
        }
        return null;
    }

    private void checkEntityIdentifiers(ResultSetPersister persister) throws DBException {
        DBDRowIdentifier identifier;
        final DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            throw new DBCException("Can't persist data - not connected to database");
        }
        boolean needsSingleEntity = persister.hasInserts() || persister.hasDeletes();
        DBSEntity entity = this.model.getSingleSource();
        if (needsSingleEntity && entity == null) {
            throw new DBCException("Can't detect source entity");
        }
        if (entity != null && (identifier = this.getVirtualEntityIdentifier()) != null && CommonUtils.isEmpty((Collection)identifier.getAttributes()) && !new UIConfirmation(){

            public Boolean runTask() {
                return ValidateUniqueKeyUsageDialog.validateUniqueKey(ResultSetViewer.this, executionContext);
            }
        }.confirm()) {
            throw new DBCException("No unique key defined");
        }
        List<DBDAttributeBinding> updatedAttributes = persister.getUpdatedAttributes();
        if (persister.hasDeletes()) {
            DBDRowIdentifier defIdentifier = persister.getDefaultRowIdentifier();
            if (defIdentifier == null) {
                throw new DBCException("No unique row identifier is result set. Cannot proceed with row(s) delete.");
            }
            if (CommonUtils.isEmpty((Collection)defIdentifier.getAttributes())) {
                throw new DBCException("Attributes of unique key '" + DBUtils.getObjectFullName((DBPNamedObject)defIdentifier.getUniqueKey(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "' are missing in result set. Cannot proceed with row(s) delete.");
            }
        }
        for (DBDAttributeBinding attr : updatedAttributes) {
            DBDRowIdentifier rowIdentifier = attr.getRowIdentifier();
            if (rowIdentifier == null) {
                throw new DBCException("Attribute " + attr.getName() + " was changed but it hasn't associated unique key");
            }
            if (!CommonUtils.isEmpty((Collection)rowIdentifier.getAttributes())) continue;
            throw new DBCException("Can't update attribute '" + attr.getName() + "' - attributes of key '" + DBUtils.getObjectFullName((DBPNamedObject)rowIdentifier.getUniqueKey(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "' are missing in result set");
        }
    }

    boolean editEntityIdentifier(DBRProgressMonitor monitor) throws DBException {
        DBDRowIdentifier virtualEntityIdentifier = this.getVirtualEntityIdentifier();
        if (virtualEntityIdentifier == null) {
            log.warn((Object)"No virtual identifier");
            return false;
        }
        DBVEntityConstraint constraint = (DBVEntityConstraint)virtualEntityIdentifier.getUniqueKey();
        EditConstraintPage page = new EditConstraintPage("Define virtual unique identifier", (DBSEntityReferrer)constraint);
        if (!page.edit()) {
            return false;
        }
        Collection<DBSEntityAttribute> uniqueAttrs = page.getSelectedAttributes();
        constraint.setAttributes(uniqueAttrs);
        virtualEntityIdentifier = this.getVirtualEntityIdentifier();
        if (virtualEntityIdentifier == null) {
            log.warn((Object)"No virtual identifier defined");
            return false;
        }
        virtualEntityIdentifier.reloadAttributes(monitor, this.model.getAttributes());
        this.persistConfig();
        return true;
    }

    private void clearEntityIdentifier(DBRProgressMonitor monitor) throws DBException {
        DBDAttributeBinding firstAttribute = this.model.getVisibleAttribute(0);
        DBDRowIdentifier rowIdentifier = firstAttribute.getRowIdentifier();
        if (rowIdentifier != null) {
            DBVEntityConstraint virtualKey = (DBVEntityConstraint)rowIdentifier.getUniqueKey();
            virtualKey.setAttributes(Collections.emptyList());
            rowIdentifier.reloadAttributes(monitor, this.model.getAttributes());
            virtualKey.getParentObject().setProperty("virtual-key-quiet", null);
        }
        this.persistConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private IResultSetListener[] getListenersCopy() {
        IResultSetListener[] listenersCopy;
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return EMPTY_LISTENERS;
            }
            listenersCopy = this.listeners.toArray(new IResultSetListener[0]);
        }
        return listenersCopy;
    }

    void fireResultSetChange() {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetChange();
            ++n2;
        }
    }

    private void fireResultSetLoad() {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetLoad();
            ++n2;
        }
    }

    private void fireResultSetSelectionChange(SelectionChangedEvent event) {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetSelectionChange(event);
            ++n2;
        }
    }

    private String translateFilterPattern(DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
        Object value = type.getValue(this, attribute, operator, true);
        DBCExecutionContext executionContext = this.getExecutionContext();
        String strValue = executionContext == null ? String.valueOf(value) : attribute.getValueHandler().getValueDisplayString((DBSTypedObject)attribute, value, DBDDisplayFormat.UI);
        strValue = strValue.trim();
        strValue = TextUtils.cutExtraLines((String)strValue, (int)1);
        strValue = CommonUtils.truncateString((String)strValue, (int)30);
        if (operator.getArgumentCount() == 0) {
            return operator.getStringValue();
        }
        return String.valueOf(operator.getStringValue()) + " " + CommonUtils.truncateString((String)strValue, (int)64);
    }

    private abstract class ColorAction
    extends Action {
        ColorAction(String name) {
            super(name);
        }

        @NotNull
        DBVEntity getVirtualEntity(DBDAttributeBinding binding) throws IllegalStateException {
            DBSEntity entity = ResultSetViewer.this.getModel().getSingleSource();
            if (entity == null) {
                throw new IllegalStateException("No virtual entity for multi-source query");
            }
            DBVEntity vEntity = DBVUtils.findVirtualEntity((DBSEntity)entity, (boolean)true);
            assert (vEntity != null);
            return vEntity;
        }

        void updateColors(DBVEntity entity) {
            ResultSetViewer.this.model.updateColorMapping();
            ResultSetViewer.this.redrawData(false, false);
            entity.getDataSource().getContainer().persistConfiguration();
        }
    }

    private class ColorizeDataTypesToggleAction
    extends Action {
        ColorizeDataTypesToggleAction() {
            super("Colorize Data Types", 2);
            this.setToolTipText("Set different foreground color for data types");
        }

        public boolean isChecked() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.show.colorizeDataTypes");
        }

        public void run() {
            DBPPreferenceStore dsStore;
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            boolean curValue = (dsStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.show.colorizeDataTypes");
            dsStore.setValue("resultset.show.colorizeDataTypes", !curValue);
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class ConfigAction
    extends Action
    implements IMenuCreator {
        ConfigAction() {
            super(CoreMessages.controls_resultset_viewer_action_options, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public void runWithEvent(Event event) {
            Menu menu = this.getMenu(ResultSetViewer.this.activePresentation.getControl());
            if (menu != null && event.widget instanceof ToolItem) {
                Rectangle bounds = ((ToolItem)event.widget).getBounds();
                Point point = ((ToolItem)event.widget).getParent().toDisplay(bounds.x, bounds.y + bounds.height);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new ShowFiltersAction(false));
            menuManager.add((IAction)new CustomizeColorsAction());
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)new VirtualKeyEditAction(true));
            menuManager.add((IAction)new VirtualKeyEditAction(false));
            menuManager.add((IAction)new DictionaryEditAction());
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)new ToggleModeAction());
            ResultSetViewer.this.activePresentation.fillMenu((IMenuManager)menuManager);
            if (!CommonUtils.isEmpty((Collection)ResultSetViewer.this.availablePresentations) && ResultSetViewer.this.availablePresentations.size() > 1) {
                menuManager.add((IContributionItem)new Separator());
                for (final ResultSetPresentationDescriptor pd : ResultSetViewer.this.availablePresentations) {
                    Action action = new Action(pd.getLabel(), 8){

                        public boolean isEnabled() {
                            return !ResultSetViewer.this.isRefreshInProgress();
                        }

                        public boolean isChecked() {
                            return pd == ResultSetViewer.this.activePresentationDescriptor;
                        }

                        public void run() {
                            ResultSetViewer.this.switchPresentation(pd);
                        }
                    };
                    pd.getIcon();
                    menuManager.add((IAction)action);
                }
            }
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)new Action("Preferences"){

                public void run() {
                    UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.common"});
                }
            });
            return menuManager.createContextMenu(parent);
        }

        @Nullable
        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    private class CustomizeColorsAction
    extends ColorAction {
        private final DBDAttributeBinding curAttribute;
        private final ResultSetRow row;

        CustomizeColorsAction() {
            this(null, null);
        }

        CustomizeColorsAction(DBDAttributeBinding curAttribute, ResultSetRow row) {
            super("Row colors ...");
            this.curAttribute = curAttribute;
            this.row = row;
        }

        public void run() {
            ColorSettingsDialog dialog = new ColorSettingsDialog(ResultSetViewer.this, this.curAttribute, this.row);
            if (dialog.open() != 0) {
                return;
            }
            DBVEntity vEntity = this.getVirtualEntity(this.curAttribute);
            this.updateColors(vEntity);
        }

        public boolean isEnabled() {
            return false;
        }
    }

    private class DictionaryEditAction
    extends Action {
        DictionaryEditAction() {
            super("Define dictionary");
        }

        public void run() {
            EditDictionaryPage page = new EditDictionaryPage(ResultSetViewer.this.model.getSingleSource());
            page.edit();
        }

        public boolean isEnabled() {
            DBSEntity singleSource = ResultSetViewer.this.model.getSingleSource();
            return singleSource != null;
        }
    }

    private class EmptySelection
    extends StructuredSelection
    implements IResultSetSelection {
        private EmptySelection() {
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return ResultSetViewer.this;
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            return Collections.emptyList();
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            return null;
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return null;
        }
    }

    private class FilterByAttributeAction
    extends Action {
        private final DBCLogicalOperator operator;
        private final FilterByAttributeType type;
        private final DBDAttributeBinding attribute;

        FilterByAttributeAction(DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
            super(String.valueOf(attribute.getName()) + " " + ResultSetViewer.this.translateFilterPattern(operator, type, attribute), type.icon);
            this.operator = operator;
            this.type = type;
            this.attribute = attribute;
        }

        public void run() {
            Object value = this.type.getValue(ResultSetViewer.this, this.attribute, this.operator, false);
            if (this.operator.getArgumentCount() != 0 && value == null) {
                return;
            }
            DBDDataFilter filter = new DBDDataFilter(ResultSetViewer.this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
            if (constraint != null) {
                constraint.setOperator(this.operator);
                constraint.setValue(value);
                ResultSetViewer.this.setDataFilter(filter, true);
            }
        }
    }

    private static enum FilterByAttributeType {
        VALUE((DBPImage)UIIcon.FILTER_VALUE){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                ResultSetRow row = viewer.getCurrentRow();
                if (attribute == null || row == null) {
                    return null;
                }
                Object cellValue = viewer.model.getCellValue(attribute, row);
                if (operator == DBCLogicalOperator.LIKE && cellValue != null) {
                    cellValue = "%" + cellValue + "%";
                }
                return cellValue;
            }
        }
        ,
        INPUT((DBPImage)UIIcon.FILTER_INPUT){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                if (useDefault) {
                    return "..";
                }
                ResultSetRow[] rows = null;
                if (operator.getArgumentCount() < 0) {
                    List<ResultSetRow> selectedRows = viewer.getSelection().getSelectedRows();
                    rows = selectedRows.toArray(new ResultSetRow[selectedRows.size()]);
                } else {
                    ResultSetRow focusRow = viewer.getCurrentRow();
                    if (focusRow != null) {
                        rows = new ResultSetRow[]{focusRow};
                    }
                }
                if (rows == null || rows.length == 0) {
                    return null;
                }
                FilterValueEditDialog dialog = new FilterValueEditDialog(viewer, attribute, rows, operator);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        }
        ,
        CLIPBOARD((DBPImage)UIIcon.FILTER_CLIPBOARD){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                try {
                    return ResultSetUtils.getAttributeValueFromClipboard(attribute);
                }
                catch (Exception e) {
                    log.debug((Object)"Error copying from clipboard", (Throwable)e);
                    return null;
                }
            }
        }
        ,
        NONE((DBPImage)UIIcon.FILTER_VALUE){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                return null;
            }
        };

        final ImageDescriptor icon;

        private FilterByAttributeType(DBPImage icon) {
            this.icon = DBeaverIcons.getImageDescriptor((DBPImage)icon);
        }

        @Nullable
        abstract Object getValue(@NotNull ResultSetViewer var1, @NotNull DBDAttributeBinding var2, @NotNull DBCLogicalOperator var3, boolean var4);
    }

    private class FilterByValueAction
    extends Action {
        private final DBCLogicalOperator operator;
        private final FilterByAttributeType type;
        private final DBDAttributeBinding attribute;
        private final Object value;

        FilterByValueAction(DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute, Object value) {
            super(String.valueOf(attribute.getName()) + " = " + CommonUtils.truncateString((String)String.valueOf(value), (int)64), null);
            this.operator = operator;
            this.type = type;
            this.attribute = attribute;
            this.value = value;
        }

        public void run() {
            if (this.operator.getArgumentCount() != 0 && this.value == null) {
                return;
            }
            DBDDataFilter filter = new DBDDataFilter(ResultSetViewer.this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
            if (constraint != null) {
                constraint.setOperator(this.operator);
                constraint.setValue(this.value);
                ResultSetViewer.this.setDataFilter(filter, true);
            }
        }
    }

    private class FilterResetAttributeAction
    extends Action {
        private final DBDAttributeBinding attribute;

        FilterResetAttributeAction(DBDAttributeBinding attribute) {
            super("Remove filter for '" + attribute.getName() + "'", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REVERT));
            this.attribute = attribute;
        }

        public void run() {
            DBDDataFilter dataFilter = new DBDDataFilter(ResultSetViewer.this.model.getDataFilter());
            DBDAttributeConstraint constraint = dataFilter.getConstraint(this.attribute);
            if (constraint != null) {
                constraint.setCriteria(null);
                ResultSetViewer.this.setDataFilter(dataFilter, true);
            }
        }
    }

    class HistoryStateItem {
        DBSDataContainer dataContainer;
        DBDDataFilter filter;
        int rowNumber;

        HistoryStateItem(@Nullable DBSDataContainer dataContainer, DBDDataFilter filter, int rowNumber) {
            this.dataContainer = dataContainer;
            this.filter = filter;
            this.rowNumber = rowNumber;
        }

        String describeState() {
            DBCExecutionContext context = ResultSetViewer.this.getExecutionContext();
            String desc = this.dataContainer.getName();
            if (context != null && this.filter != null && this.filter.hasConditions()) {
                StringBuilder condBuffer = new StringBuilder();
                SQLUtils.appendConditionString((DBDDataFilter)this.filter, (DBPDataSource)context.getDataSource(), null, (StringBuilder)condBuffer, (boolean)true);
                desc = String.valueOf(desc) + " [" + condBuffer + "]";
            }
            return desc;
        }
    }

    private class OrderByAttributeAction
    extends Action {
        private final DBDAttributeBinding attribute;
        private final boolean ascending;

        public OrderByAttributeAction(DBDAttributeBinding attribute, boolean ascending) {
            super("Order by " + attribute.getName() + " " + (ascending ? "ASC" : "DESC"));
            this.attribute = attribute;
            this.ascending = ascending;
        }

        public void run() {
            ResultSetViewer.this.toggleSortOrder(this.attribute, this.ascending, !this.ascending);
        }
    }

    private class PanelToggleAction
    extends Action {
        private final ResultSetPanelDescriptor panel;

        public PanelToggleAction(ResultSetPanelDescriptor panel) {
            super(panel.getLabel(), 2);
            this.panel = panel;
            this.setToolTipText(panel.getDescription());
        }

        public boolean isChecked() {
            return ResultSetViewer.this.activePanels.containsKey(this.panel.getId());
        }

        public void run() {
            if (ResultSetViewer.this.isPanelsVisible() && this.isChecked()) {
                CTabItem panelTab = ResultSetViewer.this.getPanelTab(this.panel.getId());
                if (panelTab != null) {
                    panelTab.dispose();
                    ResultSetViewer.this.removePanel(this.panel.getId());
                }
            } else {
                ResultSetViewer.this.activatePanel(this.panel.getId(), true, true);
            }
        }
    }

    public static class PanelsMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (rsv == null) {
                return new IContributionItem[0];
            }
            List items = rsv.fillPanelsMenu();
            return items.toArray(new IContributionItem[items.size()]);
        }
    }

    static class PresentationSettings {
        final Set<String> enabledPanelIds = new LinkedHashSet<String>();
        String activePanelId;
        int panelRatio;
        boolean panelsVisible;
        boolean verticalLayout;

        PresentationSettings() {
        }
    }

    private class ResetAllColorAction
    extends ColorAction {
        ResetAllColorAction() {
            super("Reset all colors");
        }

        public void run() {
            DBVEntity vEntity = this.getVirtualEntity(ResultSetViewer.this.getModel().getAttributes()[0]);
            if (!UIUtils.confirmAction((String)"Reset all row coloring", (String)("Are you sure you want to reset all color settings for '" + vEntity.getName() + "'?"))) {
                return;
            }
            vEntity.removeAllColorOverride();
            this.updateColors(vEntity);
        }
    }

    private class ResetRowColorAction
    extends ColorAction {
        private final DBDAttributeBinding attribute;

        ResetRowColorAction(DBDAttributeBinding attr, Object value) {
            super("Reset color by " + attr.getName());
            this.attribute = attr;
        }

        public void run() {
            DBVEntity vEntity = this.getVirtualEntity(this.attribute);
            vEntity.removeColorOverride(this.attribute);
            this.updateColors(vEntity);
        }
    }

    private class SetRowColorAction
    extends ColorAction {
        private final DBDAttributeBinding attribute;
        private final Object value;

        SetRowColorAction(DBDAttributeBinding attr, Object value) {
            super("Color by " + attr.getName());
            this.attribute = attr;
            this.value = value;
        }

        public void run() {
            RGB color;
            Shell shell = UIUtils.createCenteredShell((Shell)ResultSetViewer.this.getControl().getShell());
            try {
                ColorDialog cd = new ColorDialog(shell);
                color = cd.open();
                if (color == null) {
                    return;
                }
            }
            finally {
                shell.dispose();
            }
            try {
                DBVEntity vEntity = this.getVirtualEntity(this.attribute);
                vEntity.setColorOverride(this.attribute, this.value, null, StringConverter.asString((RGB)color));
                this.updateColors(vEntity);
            }
            catch (IllegalStateException e) {
                DBUserInterface.getInstance().showError("Row color", "Can't set row color", (Throwable)e);
            }
        }
    }

    private class ShowFiltersAction
    extends Action {
        ShowFiltersAction(boolean context) {
            super(context ? "Customize ..." : "Order/Filter ...", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER));
        }

        public void run() {
            new FilterSettingsDialog(ResultSetViewer.this).open();
        }

        public boolean isEnabled() {
            return ResultSetViewer.this.getModel().hasData();
        }
    }

    private static class SimpleFilterManager
    implements IResultSetFilterManager {
        private final Map<String, List<String>> filterHistory = new HashMap<String, List<String>>();

        private SimpleFilterManager() {
        }

        @NotNull
        public List<String> getQueryFilterHistory(@NotNull String query) {
            List<String> filters = this.filterHistory.get(query);
            if (filters != null) {
                return filters;
            }
            return Collections.emptyList();
        }

        @Override
        public void saveQueryFilterValue(@NotNull String query, @NotNull String filterValue) {
            List<String> filters = this.filterHistory.get(query);
            if (filters == null) {
                filters = new ArrayList<String>();
                this.filterHistory.put(query, filters);
            }
            filters.add(filterValue);
        }

        @Override
        public void deleteQueryFilterValue(@NotNull String query, String filterValue) throws DBException {
            List<String> filters = this.filterHistory.get(query);
            if (filters != null) {
                filters.add(filterValue);
            }
        }
    }

    private class ToggleModeAction
    extends Action {
        ToggleModeAction() {
            super("Record", 2);
            this.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.toggleMode");
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.RS_DETAILS));
        }

        public boolean isChecked() {
            return ResultSetViewer.this.isRecordMode();
        }

        public void run() {
            ResultSetViewer.this.toggleMode();
        }
    }

    private class ToggleServerSideOrderingAction
    extends Action {
        ToggleServerSideOrderingAction() {
            super(CoreMessages.pref_page_database_resultsets_label_server_side_order);
        }

        public int getStyle() {
            return 2;
        }

        public boolean isChecked() {
            return ResultSetViewer.this.getPreferenceStore().getBoolean("resultset.order.serverSide");
        }

        public void run() {
            DBPPreferenceStore preferenceStore;
            preferenceStore.setValue("resultset.order.serverSide", !(preferenceStore = ResultSetViewer.this.getPreferenceStore()).getBoolean("resultset.order.serverSide"));
        }
    }

    private class ToolbarToggleAction
    extends Action {
        private final String toolbarId;

        public ToolbarToggleAction(String toolbarId, String toolbarLabel) {
            super(toolbarLabel, 2);
            this.toolbarId = toolbarId;
        }

        public boolean isChecked() {
            return ResultSetViewer.this.activePanels.containsKey(this.toolbarId);
        }

        public void run() {
        }
    }

    private class TransformComplexTypesToggleAction
    extends Action {
        TransformComplexTypesToggleAction() {
            super("Structurize complex types", 2);
            this.setToolTipText("Visualize complex types (arrays, structures, maps) in results grid as separate columns");
        }

        public boolean isChecked() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type");
        }

        public void run() {
            DBPPreferenceStore preferenceStore;
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            boolean curValue = (preferenceStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.transform.complex.type");
            preferenceStore.setValue("resultset.transform.complex.type", !curValue);
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class TransformerAction
    extends Action {
        private final DBDAttributeBinding attribute;

        TransformerAction(DBDAttributeBinding attr, String text, int style, boolean checked) {
            super(text, style);
            this.attribute = attr;
            this.setChecked(checked);
        }

        @NotNull
        DBVTransformSettings getTransformSettings() {
            DBVTransformSettings settings = DBVUtils.getTransformSettings((DBDAttributeBinding)this.attribute, (boolean)true);
            if (settings == null) {
                throw new IllegalStateException("Can't get/create transformer settings for '" + this.attribute.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
            }
            return settings;
        }

        void saveTransformerSettings() {
            this.attribute.getDataSource().getContainer().persistConfiguration();
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class VirtualKeyEditAction
    extends Action {
        private boolean define;

        VirtualKeyEditAction(boolean define) {
            super(define ? "Define virtual unique key" : "Clear virtual unique key");
            this.define = define;
        }

        public boolean isEnabled() {
            DBDRowIdentifier identifier = ResultSetViewer.this.getVirtualEntityIdentifier();
            return identifier != null && (this.define || !CommonUtils.isEmpty((Collection)identifier.getAttributes()));
        }

        public void run() {
            UIUtils.runUIJob((String)"Edit virtual key", monitor -> {
                try {
                    if (this.define) {
                        ResultSetViewer.this.editEntityIdentifier(monitor);
                    } else {
                        ResultSetViewer.this.clearEntityIdentifier(monitor);
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
    }
}

