/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.AbstractContextDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.utils.CommonUtils;

public class ResultSetPanelDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resultset.panel";
    public static final String TAG_SUPPORTS = "supports";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final boolean showByDefault;
    private final List<IResultSetPresentation.PresentationType> supportedPresentationTypes = new ArrayList<IResultSetPresentation.PresentationType>();
    private final List<String> supportedPresentations = new ArrayList<String>();
    private final List<String> supportedDataSources = new ArrayList<String>();

    protected ResultSetPanelDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.showByDefault = CommonUtils.toBoolean((Object)config.getAttribute("default"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren(TAG_SUPPORTS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement supports = iConfigurationElementArray[n2];
            String type = supports.getAttribute("type");
            if (!CommonUtils.isEmpty((String)type)) {
                this.supportedPresentationTypes.add(IResultSetPresentation.PresentationType.valueOf(type.toUpperCase(Locale.ENGLISH)));
            }
            if (!CommonUtils.isEmpty((String)(id = supports.getAttribute("id")))) {
                this.supportedPresentations.add(id);
            }
            ++n2;
        }
        iConfigurationElementArray = config.getChildren("datasource");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsElement = iConfigurationElementArray[n2];
            String dsId = dsElement.getAttribute("id");
            if (dsId != null) {
                this.supportedDataSources.add(dsId);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isShowByDefault() {
        return this.showByDefault;
    }

    public boolean supportedBy(DBPDataSource dataSource, String presentationId, IResultSetPresentation.PresentationType presentationType) {
        if (!this.supportedDataSources.isEmpty()) {
            if (dataSource == null) {
                return false;
            }
            if (!this.supportedDataSources.contains(dataSource.getContainer().getDriver().getProviderId())) {
                return false;
            }
        }
        if (this.supportedPresentations.isEmpty() && this.supportedPresentationTypes.isEmpty()) {
            return true;
        }
        return presentationId != null && this.supportedPresentations.contains(presentationId) || presentationType != null && this.supportedPresentationTypes.contains((Object)presentationType);
    }

    public IResultSetPanel createInstance() throws DBException {
        return (IResultSetPanel)this.implClass.createInstance(IResultSetPanel.class);
    }

    public String toString() {
        return this.id;
    }
}

