/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.utils.CommonUtils;

public class DataSourceTransactionModeContributor
extends DataSourceMenuContributor {
    private static final Log log = Log.getLog(DataSourceTransactionModeContributor.class);

    @Override
    protected void fillContributionItems(List<IContributionItem> menuItems) {
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IEditorPart activePart = window.getActivePage().getActiveEditor();
        DBPDataSourceContainer container = AbstractDataSourceHandler.getDataSourceContainer((IWorkbenchPart)activePart);
        DBPDataSource dataSource = null;
        if (container != null) {
            dataSource = container.getDataSource();
        }
        if (dataSource == null) {
            return;
        }
        DBPDataSourceInfo dsInfo = dataSource.getInfo();
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)dataSource.getDefaultInstance().getDefaultContext(false));
        if (txnManager != null) {
            menuItems.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)window, (String)"org.jkiss.dbeaver.core.txn.autocommit", (int)32));
            menuItems.add((IContributionItem)new Separator());
            DBPTransactionIsolation txnLevelCurrent = null;
            try {
                txnLevelCurrent = txnManager.getTransactionIsolation();
            }
            catch (DBCException ex) {
                log.warn((Object)"Can't determine current transaction isolation level", (Throwable)ex);
            }
            for (DBPTransactionIsolation txi : CommonUtils.safeCollection((Collection)dsInfo.getSupportedTransactionsIsolation())) {
                if (!txi.isEnabled()) continue;
                menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new TransactionIsolationAction(dataSource, txi, txi.equals(txnLevelCurrent)), (boolean)true));
            }
        }
    }

    private static class TransactionIsolationAction
    extends Action {
        private final DBPDataSource dataSource;
        private final DBPTransactionIsolation level;
        private final boolean checked;

        public TransactionIsolationAction(DBPDataSource dataSource, DBPTransactionIsolation level, boolean checked) {
            this.dataSource = dataSource;
            this.level = level;
            this.checked = checked;
        }

        public int getStyle() {
            return 8;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public String getText() {
            return this.level.getTitle();
        }

        public void run() {
            try {
                this.dataSource.getContainer().setDefaultTransactionsIsolation(this.level);
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Transactions Isolation", "Can't set transaction isolation level to '" + this.level + "'", (Throwable)e);
                return;
            }
            this.dataSource.getContainer().persistConfiguration();
        }
    }
}

