/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.tools.ToolDescriptor;
import org.jkiss.dbeaver.registry.tools.ToolGroupDescriptor;
import org.jkiss.dbeaver.registry.tools.ToolsRegistry;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.common.EmptyListAction;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorActionExecuteTool;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceToolsContributor
extends DataSourceMenuContributor {
    private static final boolean SHOW_GROUPS_AS_SUBMENU = false;

    @Override
    protected void fillContributionItems(List<IContributionItem> menuItems) {
        IEditorInput editorInput;
        IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return;
        }
        DBSObject selectedObject = null;
        ISelectionProvider selectionProvider = activePart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                selectedObject = (DBSObject)RuntimeUtils.getObjectAdapter((Object)((IStructuredSelection)selection).getFirstElement(), DBSObject.class);
                List<ToolDescriptor> tools = ToolsRegistry.getInstance().getTools((IStructuredSelection)selection);
                DataSourceToolsContributor.fillToolsMenu(menuItems, tools, selection);
            }
        } else if (activePart instanceof IEditorPart && (editorInput = ((IEditorPart)activePart).getEditorInput()) instanceof IDatabaseEditorInput) {
            selectedObject = ((IDatabaseEditorInput)editorInput).getDatabaseObject();
        }
        if (selectedObject != null) {
            ArrayList<DBXTreeObject> navigatorObjectEditors = new ArrayList<DBXTreeObject>();
            DBNDatabaseNode dsNode = NavigatorUtils.getNodeByObject((DBSObject)selectedObject.getDataSource());
            if (dsNode != null) {
                HashSet<DBXTreeNode> processedNodes = new HashSet<DBXTreeNode>();
                this.findObjectNodes(dsNode.getMeta(), navigatorObjectEditors, processedNodes);
            }
            if (!navigatorObjectEditors.isEmpty()) {
                DBNDatabaseNode objectNode = dsNode;
                menuItems.add((IContributionItem)new Separator());
                for (DBXTreeObject editorMeta : navigatorObjectEditors) {
                    menuItems.add((IContributionItem)new ActionContributionItem((IAction)new OpenToolsEditorAction(activePage, objectNode, editorMeta)));
                }
            }
        }
    }

    private void findObjectNodes(DBXTreeNode meta, List<DBXTreeObject> editors, Set<DBXTreeNode> processedNodes) {
        if (processedNodes.contains(meta)) {
            return;
        }
        if (meta instanceof DBXTreeObject) {
            editors.add((DBXTreeObject)meta);
        }
        processedNodes.add(meta);
        if (meta.getRecursiveLink() != null) {
            return;
        }
        List children = meta.getChildren(null);
        if (children != null) {
            for (DBXTreeNode child : children) {
                this.findObjectNodes(child, editors, processedNodes);
            }
        }
    }

    private static void fillToolsMenu(List<IContributionItem> menuItems, List<ToolDescriptor> tools, ISelection selection) {
        IWorkbenchPart activePart;
        IWorkbenchWindow workbenchWindow;
        boolean hasTools = false;
        if (!CommonUtils.isEmpty(tools) && (workbenchWindow = UIUtils.getActiveWorkbenchWindow()).getActivePage() != null && (activePart = workbenchWindow.getActivePage().getActivePart()) != null) {
            HashMap groupsMap = new HashMap();
            HashSet<ToolGroupDescriptor> groupSet = new HashSet<ToolGroupDescriptor>();
            for (ToolDescriptor tool : tools) {
                hasTools = true;
                Object parentMenu = null;
                if (tool.getGroup() != null && !groupSet.contains((Object)tool.getGroup())) {
                    groupSet.add(tool.getGroup());
                    menuItems.add((IContributionItem)new Separator(tool.getGroup().getId()));
                }
                IAction action = ActionUtils.makeAction((IActionDelegate)new NavigatorActionExecuteTool(workbenchWindow, tool), (IWorkbenchSite)activePart.getSite(), (ISelection)selection, (String)tool.getLabel(), (ImageDescriptor)(tool.getIcon() == null ? null : DBeaverIcons.getImageDescriptor((DBPImage)tool.getIcon())), (String)tool.getDescription());
                if (parentMenu == null) {
                    menuItems.add((IContributionItem)new ActionContributionItem(action));
                    continue;
                }
                parentMenu.add((IContributionItem)new ActionContributionItem(action));
            }
        }
        if (!hasTools) {
            menuItems.add((IContributionItem)new ActionContributionItem((IAction)new EmptyListAction()));
        }
    }

    private static IMenuManager getGroupMenu(List<IContributionItem> rootItems, Map<ToolGroupDescriptor, IMenuManager> groupsMap, ToolGroupDescriptor group) {
        IMenuManager item = groupsMap.get((Object)group);
        if (item == null) {
            item = new MenuManager(group.getLabel(), null, group.getId());
            if (group.getParent() != null) {
                IMenuManager parentMenu = DataSourceToolsContributor.getGroupMenu(rootItems, groupsMap, group.getParent());
                parentMenu.add((IContributionItem)item);
            } else {
                rootItems.add((IContributionItem)item);
            }
        }
        groupsMap.put(group, item);
        return item;
    }

    private class OpenToolsEditorAction
    extends Action {
        private final IWorkbenchPage workbenchPage;
        private final DBNDatabaseNode databaseNode;
        private final DBXTreeObject editorMeta;

        public OpenToolsEditorAction(IWorkbenchPage workbenchPage, DBNDatabaseNode databaseNode, DBXTreeObject editorMeta) {
            super(editorMeta.getLabel(), editorMeta.getIcon(null) == null ? null : DBeaverIcons.getImageDescriptor((DBPImage)editorMeta.getIcon(null)));
            this.workbenchPage = workbenchPage;
            this.databaseNode = databaseNode;
            this.editorMeta = editorMeta;
        }

        public void run() {
            DatabaseEditorInput<DBNDatabaseNode> objectInput = new DatabaseEditorInput<DBNDatabaseNode>(this.databaseNode){};
            try {
                this.workbenchPage.openEditor((IEditorInput)objectInput, this.editorMeta.getEditorId());
            }
            catch (PartInitException e) {
                DBUserInterface.getInstance().showError("Editor open", "Error opening tool editor '" + this.editorMeta.getEditorId() + "'", e.getStatus());
            }
        }
    }
}

