/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.UIUtils;

public class LoadingJob<RESULT>
extends AbstractJob {
    private static final Log log = Log.getLog(LoadingJob.class);
    public static final Object LOADING_FAMILY = new Object();
    private boolean loadFinished;
    private ILoadService<RESULT> loadingService;
    private ILoadVisualizer<RESULT> visualizer;

    public static <RESULT> LoadingJob<RESULT> createService(ILoadService<RESULT> loadingService, ILoadVisualizer<RESULT> visualizer) {
        return new LoadingJob<RESULT>(loadingService, visualizer);
    }

    public LoadingJob(ILoadService<RESULT> loadingService, ILoadVisualizer<RESULT> visualizer) {
        super(loadingService.getServiceName());
        this.loadingService = loadingService;
        this.visualizer = visualizer;
        this.setUser(false);
    }

    public ILoadService<RESULT> getLoadingService() {
        return this.loadingService;
    }

    public ILoadVisualizer<RESULT> getVisualizer() {
        return this.visualizer;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        return this.run(monitor, true);
    }

    private IStatus run(DBRProgressMonitor monitor, boolean lazy) {
        monitor = this.visualizer.overwriteMonitor(monitor);
        if (this.loadingService instanceof AbstractLoadService) {
            ((AbstractLoadService)this.loadingService).initService(monitor, (AbstractJob)this);
        }
        LoadingUIJob updateUIJob = new LoadingUIJob(this);
        updateUIJob.schedule();
        Throwable error = null;
        Object result = null;
        try {
            try {
                result = this.loadingService.evaluate(monitor);
            }
            catch (InvocationTargetException e) {
                error = e.getTargetException();
                this.loadFinished = true;
                UIUtils.asyncExec((Runnable)new LoadFinisher(result, error));
            }
            catch (InterruptedException e) {
                Status status = new Status(8, "org.jkiss.dbeaver.core", "Loading interrupted");
                this.loadFinished = true;
                UIUtils.asyncExec((Runnable)new LoadFinisher(result, error));
                return status;
            }
        }
        finally {
            this.loadFinished = true;
            UIUtils.asyncExec((Runnable)new LoadFinisher(result, error));
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return family == this.loadingService.getFamily();
    }

    public void syncRun() {
        this.run((DBRProgressMonitor)new VoidProgressMonitor(), false);
    }

    private class LoadFinisher
    implements Runnable {
        private final RESULT innerResult;
        private final Throwable innerError;

        LoadFinisher(RESULT innerResult, Throwable innerError) {
            this.innerResult = innerResult;
            this.innerError = innerError;
        }

        @Override
        public void run() {
            try {
                LoadingJob.this.visualizer.completeLoading(this.innerResult);
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
            if (this.innerError != null) {
                log.debug((Object)this.innerError);
                DBUserInterface.getInstance().showError(LoadingJob.this.getName(), null, this.innerError);
            }
        }
    }

    class LoadingUIJob<RESULT>
    extends AbstractUIJob {
        private static final long DELAY = 200L;
        private ILoadVisualizer<RESULT> visualizer;

        LoadingUIJob(LoadingJob<RESULT> loadingJob2) {
            super(loadingJob2.getName());
            this.visualizer = loadingJob2.getVisualizer();
            this.setSystem(true);
        }

        public IStatus runInUIThread(DBRProgressMonitor monitor) {
            if (!this.visualizer.isCompleted() && !LoadingJob.this.loadFinished) {
                this.visualizer.visualizeLoading();
                this.schedule(200L);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == LOADING_FAMILY;
        }

        protected void canceling() {
            super.canceling();
        }
    }
}

