/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.runtime.sql.SQLQueryParameterRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLQueryParameterBindDialog
extends StatusDialog {
    private static final String DIALOG_ID = "DBeaver.SQLQueryParameterBindDialog";
    private static final String PARAM_HIDE_IF_SET = "PARAM_HIDE_IF_SET";
    private List<SQLQueryParameter> parameters;
    private final Map<String, List<SQLQueryParameter>> dupParameters = new HashMap<String, List<SQLQueryParameter>>();
    private static Map<String, SQLQueryParameterRegistry.ParameterInfo> savedParamValues = new HashMap<String, SQLQueryParameterRegistry.ParameterInfo>();
    private Button hideIfSetCheck;
    private Table paramTable;

    public SQLQueryParameterBindDialog(Shell shell, List<SQLQueryParameter> parameters) {
        super(shell);
        this.parameters = parameters;
        SQLQueryParameterRegistry registry = SQLQueryParameterRegistry.getInstance();
        for (SQLQueryParameter param : this.parameters) {
            SQLQueryParameterRegistry.ParameterInfo paramInfo;
            if (!param.isNamed() || param.getValue() != null || (paramInfo = registry.getParameter(param.getName())) == null) continue;
            param.setValue(paramInfo.value);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_sql_param_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.paramTable = new Table(composite, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        this.paramTable.setLayoutData((Object)gd);
        this.paramTable.setHeaderVisible(true);
        this.paramTable.setLinesVisible(true);
        TableColumn indexColumn = UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)"#");
        indexColumn.setWidth(40);
        TableColumn nameColumn = UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)CoreMessages.dialog_sql_param_column_name);
        nameColumn.setWidth(100);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)CoreMessages.dialog_sql_param_column_value);
        valueColumn.setWidth(200);
        this.fillParameterList(SQLQueryParameterBindDialog.isHideIfSet());
        CustomTableEditor tableEditor = new CustomTableEditor(this.paramTable){
            {
                this.firstTraverseIndex = 2;
                this.lastTraverseIndex = 2;
                this.editOnEnter = false;
            }

            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 2) {
                    return null;
                }
                SQLQueryParameter param = (SQLQueryParameter)item.getData();
                Text editor = new Text((Composite)table, 2048);
                editor.setText(CommonUtils.notEmpty((String)param.getValue()));
                editor.selectAll();
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                List dups;
                SQLQueryParameter param = (SQLQueryParameter)item.getData();
                String newValue = ((Text)control).getText();
                item.setText(2, newValue);
                param.setValue(newValue);
                if (param.isNamed() && (dups = (List)SQLQueryParameterBindDialog.this.dupParameters.get(param.getName())) != null) {
                    for (SQLQueryParameter dup : dups) {
                        dup.setValue(newValue);
                    }
                }
                savedParamValues.put(param.getName().toUpperCase(Locale.ENGLISH), new SQLQueryParameterRegistry.ParameterInfo(param.getName(), newValue));
            }
        };
        if (!this.parameters.isEmpty()) {
            UIUtils.asyncExec(() -> {
                this.paramTable.select(0);
                tableEditor.showEditor(this.paramTable.getItem(0), 2);
            });
        }
        this.hideIfSetCheck = UIUtils.createCheckbox((Composite)composite, (String)CoreMessages.dialog_sql_param_hide_checkbox, (String)CoreMessages.dialog_sql_param_hide_checkbox_tip, (boolean)SQLQueryParameterBindDialog.isHideIfSet(), (int)1);
        this.hideIfSetCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLQueryParameterBindDialog.this.fillParameterList(SQLQueryParameterBindDialog.this.hideIfSetCheck.getSelection());
            }
        });
        this.updateStatus(GeneralUtils.makeInfoStatus((String)CoreMessages.dialog_sql_param_hint));
        return composite;
    }

    private void fillParameterList(boolean hideVariables) {
        this.paramTable.removeAll();
        for (SQLQueryParameter param : this.parameters) {
            if (hideVariables && param.isVariableSet()) continue;
            if (param.getPrevious() != null) {
                List dups = this.dupParameters.computeIfAbsent(param.getName(), k -> new ArrayList());
                dups.add(param);
                continue;
            }
            TableItem item = new TableItem(this.paramTable, 0);
            item.setData((Object)param);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ATTRIBUTE));
            item.setText(0, String.valueOf(param.getOrdinalPosition() + 1));
            item.setText(1, param.getTitle());
            item.setText(2, CommonUtils.notEmpty((String)param.getValue()));
        }
    }

    protected void okPressed() {
        SQLQueryParameterRegistry registry = SQLQueryParameterRegistry.getInstance();
        for (SQLQueryParameterRegistry.ParameterInfo param : savedParamValues.values()) {
            registry.setParameter(param.name, param.value);
        }
        registry.save();
        if (this.hideIfSetCheck != null) {
            this.getDialogBoundsSettings().put(PARAM_HIDE_IF_SET, this.hideIfSetCheck.getSelection());
        }
        super.okPressed();
    }

    public static boolean isHideIfSet() {
        return UIUtils.getDialogSettings((String)DIALOG_ID).getBoolean(PARAM_HIDE_IF_SET);
    }
}

