/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.sql.SQLQueryListener;
import org.jkiss.dbeaver.runtime.sql.SQLQueryParameterBindDialog;
import org.jkiss.dbeaver.runtime.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.runtime.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.runtime.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorJob;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorResponse;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLQueryJob
extends DataSourceJob {
    private static final Log log = Log.getLog(SQLQueryJob.class);
    public static final Object STATS_RESULTS = new Object();
    private final DBSDataContainer dataContainer;
    private final List<SQLScriptElement> queries;
    private final SQLScriptContext scriptContext;
    private final SQLResultsConsumer resultsConsumer;
    private final SQLQueryListener listener;
    private final IWorkbenchPartSite partSite;
    private DBDDataFilter dataFilter;
    private boolean connectionInvalidated = false;
    private SQLScriptCommitType commitType;
    private SQLScriptErrorHandling errorHandling;
    private boolean fetchResultSets;
    private long rsOffset;
    private long rsMaxRows;
    private DBCStatement curStatement;
    private final List<DBCResultSet> curResultSets = new ArrayList<DBCResultSet>();
    private Throwable lastError = null;
    private DBCStatistics statistics;
    private int fetchResultSetNumber;
    private int resultSetNumber;
    private SQLQuery lastGoodQuery;
    private boolean skipConfirmation;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$ui$dialogs$exec$ExecutionQueueErrorResponse;

    public SQLQueryJob(@NotNull IWorkbenchPartSite partSite, @NotNull String name, @NotNull DBCExecutionContext executionContext, @NotNull DBSDataContainer dataContainer, @NotNull List<SQLScriptElement> queries, @NotNull SQLScriptContext scriptContext, @NotNull SQLResultsConsumer resultsConsumer, @Nullable SQLQueryListener listener) {
        super(name, executionContext);
        this.dataContainer = dataContainer;
        this.partSite = partSite;
        this.queries = queries;
        this.scriptContext = scriptContext;
        this.resultsConsumer = resultsConsumer;
        this.listener = listener;
        DBPPreferenceStore preferenceStore = this.getDataSourceContainer().getPreferenceStore();
        this.commitType = SQLScriptCommitType.valueOf(preferenceStore.getString("script.commit.type"));
        this.errorHandling = SQLScriptErrorHandling.valueOf(preferenceStore.getString("script.error.handling"));
        this.fetchResultSets = queries.size() == 1 || preferenceStore.getBoolean("script.fetch.resultset");
        this.rsMaxRows = preferenceStore.getInt("resultset.maxrows");
    }

    public void setFetchResultSets(boolean fetchResultSets) {
        this.fetchResultSets = fetchResultSets;
    }

    public SQLScriptElement getLastQuery() {
        return this.queries.isEmpty() ? null : this.queries.get(0);
    }

    public SQLScriptElement getLastGoodQuery() {
        return this.lastGoodQuery;
    }

    public DBCStatement getCurrentStatement() {
        return this.curStatement;
    }

    private boolean hasLimits() {
        return this.rsOffset >= 0L && this.rsMaxRows > 0L;
    }

    public void setResultSetLimit(long offset, long maxRows) {
        this.rsOffset = offset;
        this.rsMaxRows = maxRows;
    }

    /*
     * Unable to fully structure code
     */
    protected IStatus run(DBRProgressMonitor monitor) {
        RuntimeUtils.setThreadName((String)"SQL script execution");
        this.statistics = new DBCStatistics();
        this.skipConfirmation = false;
        try {
            block45: {
                context = this.getExecutionContext();
                txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                purpose = this.queries.size() > 1 ? DBCExecutionPurpose.USER_SCRIPT : DBCExecutionPurpose.USER;
                var5_6 = null;
                var6_8 = null;
                session = context.openSession(monitor, purpose, "SQL Query");
                try {
                    if (session.isLoggingEnabled()) {
                        QMUtils.getDefaultHandler().handleScriptBegin(session);
                    }
                    oldAutoCommit = txnManager == null || txnManager.isAutoCommit() != false;
                    v0 = newAutoCommit = this.commitType == SQLScriptCommitType.AUTOCOMMIT;
                    if (txnManager != null && !oldAutoCommit && newAutoCommit) {
                        txnManager.setAutoCommit(monitor, true);
                    }
                    monitor.beginTask(this.getName(), this.queries.size());
                    if (this.listener != null) {
                        try {
                            this.listener.onStartScript();
                        }
                        catch (Exception e) {
                            SQLQueryJob.log.error((Object)e);
                        }
                    }
                    this.resultSetNumber = 0;
                    queryNum = 0;
                    block25: while (queryNum < this.queries.size()) {
                        block46: {
                            query = this.queries.get(queryNum);
                            this.fetchResultSetNumber = this.resultSetNumber;
                            runNext = this.executeSingleQuery(session, query, true);
                            if (runNext) break block46;
                            if (this.lastError == null) break;
                            SQLQueryJob.log.error((Object)this.lastError);
                            isQueue = queryNum < this.queries.size() - 1;
                            response = ExecutionQueueErrorJob.showError((String)(isQueue != false ? "SQL script execution" : "SQL query execution"), (Throwable)this.lastError, (boolean)isQueue);
                            stopScript = false;
                            switch (SQLQueryJob.$SWITCH_TABLE$org$jkiss$dbeaver$ui$dialogs$exec$ExecutionQueueErrorResponse()[response.ordinal()]) {
                                case 1: {
                                    stopScript = true;
                                    ** GOTO lbl49
                                }
                                case 2: {
                                    continue block25;
                                }
                                case 3: {
                                    ** GOTO lbl49
                                }
                                case 4: {
                                    this.errorHandling = SQLScriptErrorHandling.IGNORE;
                                }
lbl49:
                                // 4 sources

                                default: {
                                    if (stopScript) break block25;
                                }
                            }
                        }
                        if (monitor.isCanceled()) break;
                        monitor.worked(1);
                        ++queryNum;
                    }
                    if (this.statistics.getStatementsCount() > 0) {
                        this.showExecutionResult(session);
                    }
                    monitor.done();
                    if (txnManager != null && !oldAutoCommit && this.commitType != SQLScriptCommitType.AUTOCOMMIT) {
                        if (this.lastError == null || this.errorHandling == SQLScriptErrorHandling.STOP_COMMIT) {
                            if (this.commitType != SQLScriptCommitType.NO_COMMIT) {
                                monitor.beginTask("Commit data", 1);
                                txnManager.commit(session);
                                monitor.done();
                            }
                        } else if (this.errorHandling == SQLScriptErrorHandling.STOP_ROLLBACK) {
                            monitor.beginTask("Rollback data", 1);
                            txnManager.rollback(session, null);
                            monitor.done();
                        } else {
                            SQLQueryJob.log.info((Object)"Script executed with errors. Changes were not commmitted.");
                        }
                    }
                    if (txnManager != null && !oldAutoCommit && newAutoCommit) {
                        txnManager.setAutoCommit(monitor, false);
                    }
                    if (session.isLoggingEnabled()) {
                        QMUtils.getDefaultHandler().handleScriptEnd(session);
                    }
                    var17_20 = new Status(0, DBeaverCore.getCorePluginID(), "SQL job completed");
                    if (session == null) break block45;
                }
                catch (Throwable var5_7) {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw var5_7;
                    }
                    catch (Throwable var6_9) {
                        try {
                            if (var5_6 == null) {
                                var5_6 = var6_9;
                            } else if (var5_6 != var6_9) {
                                var5_6.addSuppressed(var6_9);
                            }
                            throw var5_6;
                        }
                        catch (Throwable ex) {
                            var17_20 = new Status(4, DBeaverCore.getCorePluginID(), "Error during SQL job execution: " + ex.getMessage());
                            if (this.listener != null) {
                                try {
                                    this.listener.onEndScript(this.statistics, this.lastError != null);
                                }
                                catch (Exception e) {
                                    SQLQueryJob.log.error((Object)e);
                                }
                            }
                            return var17_20;
                        }
                    }
                }
                session.close();
            }
            if (this.listener != null) {
                try {
                    this.listener.onEndScript(this.statistics, this.lastError != null);
                }
                catch (Exception e) {
                    SQLQueryJob.log.error((Object)e);
                }
            }
            return var17_20;
        }
        catch (Throwable var16_24) {
            if (this.listener != null) {
                try {
                    this.listener.onEndScript(this.statistics, this.lastError != null);
                }
                catch (Exception e) {
                    SQLQueryJob.log.error((Object)e);
                }
            }
            throw var16_24;
        }
    }

    private boolean executeSingleQuery(@NotNull DBCSession session, @NotNull SQLScriptElement element, boolean fireEvents) {
        SQLQueryResult curResult;
        SQLQuery originalQuery;
        block34: {
            if (element instanceof SQLControlCommand) {
                try {
                    return this.executeControlCommand((SQLControlCommand)element);
                }
                catch (Throwable e) {
                    if (!(e instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL command", e);
                    }
                    this.lastError = e;
                    return false;
                }
            }
            SQLQuery sqlQuery = (SQLQuery)element;
            this.lastError = null;
            if (!this.skipConfirmation && this.getDataSourceContainer().getConnectionConfiguration().getConnectionType().isConfirmExecute() && !SQLSemanticProcessor.isSelectQuery((String)element.getText())) {
                int confirmResult = this.confirmQueryExecution((SQLQuery)element, this.queries.size() > 1);
                switch (confirmResult) {
                    case 3: {
                        return true;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        this.skipConfirmation = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            DBCExecutionContext executionContext = this.getExecutionContext();
            DBPDataSource dataSource = executionContext.getDataSource();
            originalQuery = sqlQuery;
            long startTime = System.currentTimeMillis();
            boolean startQueryAlerted = false;
            if (!this.prepareStatementParameters(sqlQuery)) {
                return false;
            }
            String queryText = originalQuery.getText();
            if (this.dataFilter != null && this.dataFilter.hasFilters() && dataSource instanceof SQLDataSource) {
                String filteredQueryText = ((SQLDataSource)dataSource).getSQLDialect().addFiltersToQuery(dataSource, queryText, this.dataFilter);
                sqlQuery = new SQLQuery(executionContext.getDataSource(), filteredQueryText, sqlQuery);
            } else {
                sqlQuery = new SQLQuery(executionContext.getDataSource(), queryText, sqlQuery);
            }
            curResult = new SQLQueryResult(sqlQuery);
            if (this.rsOffset > 0L) {
                curResult.setRowOffset(Long.valueOf(this.rsOffset));
            }
            try {
                try {
                    this.closeStatement();
                    if (!this.connectionInvalidated && dataSource.getContainer().getPreferenceStore().getBoolean("statement.invalidate.before.execute")) {
                        executionContext.invalidateContext(session.getProgressMonitor(), true);
                        this.connectionInvalidated = true;
                    }
                    this.statistics.setQueryText(sqlQuery.getText());
                    if (fireEvents && this.listener != null) {
                        try {
                            this.listener.onStartQuery(session, sqlQuery);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                        startQueryAlerted = true;
                    }
                    startTime = System.currentTimeMillis();
                    SQLQuery execStatement = sqlQuery;
                    long execStartTime = startTime;
                    DBUtils.tryExecuteRecover((Object)session, (DBPDataSource)session.getDataSource(), param -> {
                        try {
                            this.executeStatement(session, execStatement, execStartTime, curResult);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (Throwable ex) {
                    if (!(ex instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL", ex);
                    }
                    curResult.setError(ex);
                    this.lastError = ex;
                    curResult.setQueryTime(System.currentTimeMillis() - startTime);
                    if (fireEvents && this.listener != null && startQueryAlerted) {
                        try {
                            this.listener.onEndQuery(session, curResult);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                curResult.setQueryTime(System.currentTimeMillis() - startTime);
                if (fireEvents && this.listener != null && startQueryAlerted) {
                    try {
                        this.listener.onEndQuery(session, curResult);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                throw throwable;
            }
            curResult.setQueryTime(System.currentTimeMillis() - startTime);
            if (fireEvents && this.listener != null && startQueryAlerted) {
                try {
                    this.listener.onEndQuery(session, curResult);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        if (curResult.getError() != null && this.errorHandling != SQLScriptErrorHandling.IGNORE) {
            return false;
        }
        this.lastGoodQuery = originalQuery;
        return true;
    }

    private void executeStatement(@NotNull DBCSession session, SQLQuery sqlQuery, long startTime, SQLQueryResult curResult) throws DBCException {
        DBCStatement dbcStatement;
        AbstractExecutionSource source = new AbstractExecutionSource(this.dataContainer, session.getExecutionContext(), (Object)this.partSite.getPart(), (Object)sqlQuery);
        this.curStatement = dbcStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (SQLQuery)sqlQuery, (long)this.rsOffset, (long)this.rsMaxRows);
        int statementTimeout = this.getDataSourceContainer().getPreferenceStore().getInt("statement.timeout");
        if (statementTimeout > 0) {
            try {
                dbcStatement.setStatementTimeout(statementTimeout);
            }
            catch (Throwable e) {
                log.debug((Object)("Can't set statement timeout:" + e.getMessage()));
            }
        }
        try {
            session.getProgressMonitor().subTask("Execute query");
            boolean hasResultSet = dbcStatement.executeStatement();
            curResult.setHasResultSet(hasResultSet);
            this.statistics.addExecuteTime(System.currentTimeMillis() - startTime);
            this.statistics.addStatementsCount();
            long updateCount = -1L;
            while (hasResultSet || this.resultSetNumber == 0 || updateCount >= 0L) {
                if ((this.fetchResultSetNumber < 0 || this.fetchResultSetNumber == this.resultSetNumber) && hasResultSet && this.fetchResultSets) {
                    DBCResultSet resultSet = dbcStatement.openResultSet();
                    if (resultSet == null) {
                        break;
                    }
                    DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(sqlQuery, this.resultSetNumber);
                    if (dataReceiver != null) {
                        hasResultSet = this.fetchQueryData(session, resultSet, curResult, curResult.addExecuteResult(true), dataReceiver, true);
                    }
                }
                if (!hasResultSet) {
                    try {
                        updateCount = dbcStatement.getUpdateRowCount();
                        if (updateCount >= 0L) {
                            curResult.addExecuteResult(false).setUpdateCount(Long.valueOf(updateCount));
                            this.statistics.addRowsUpdated(updateCount);
                        }
                    }
                    catch (DBCException e) {
                        log.warn((Object)"Can't obtain update count", (Throwable)e);
                    }
                }
                if (hasResultSet && this.fetchResultSets) {
                    this.fetchResultSetNumber = ++this.resultSetNumber;
                }
                if (!hasResultSet && updateCount < 0L) {
                    break;
                }
                if (!session.getDataSource().getInfo().supportsMultipleResults()) break;
                try {
                    hasResultSet = dbcStatement.nextResults();
                }
                catch (DBCException e) {
                    log.error((Object)e);
                    hasResultSet = dbcStatement.nextResults();
                }
                updateCount = hasResultSet ? -1 : 0;
            }
        }
        finally {
            try {
                curResult.addWarnings(dbcStatement.getStatementWarnings());
            }
            catch (Throwable e) {
                log.warn((Object)"Can't read execution warnings", e);
            }
            if (!this.keepStatementOpen()) {
                this.closeStatement();
            }
        }
    }

    private boolean executeControlCommand(SQLControlCommand command) throws DBException {
        if (command.isEmptyCommand()) {
            return true;
        }
        SQLCommandHandlerDescriptor commandHandler = SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId());
        if (commandHandler == null) {
            throw new DBException("Command '" + command.getCommand() + "' not supported");
        }
        return commandHandler.createHandler().handleCommand(command, this.scriptContext);
    }

    private void showExecutionResult(DBCSession session) {
        if (this.statistics.getStatementsCount() > 1 || this.resultSetNumber == 0) {
            SQLQuery query = new SQLQuery(session.getDataSource(), "", -1, -1);
            if (this.queries.size() == 1) {
                query.setText(this.queries.get(0).getText());
            }
            query.setData(STATS_RESULTS);
            DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(query, this.resultSetNumber);
            if (dataReceiver != null) {
                try {
                    this.fetchExecutionResult(session, dataReceiver, query);
                }
                catch (DBCException e) {
                    log.error((Object)"Error generating execution result stats", (Throwable)e);
                }
            }
        }
    }

    private void fetchExecutionResult(@NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @NotNull SQLQuery query) throws DBCException {
        StatResultSet fakeResultSet = new StatResultSet(session, this.curStatement);
        SQLQueryResult resultInfo = new SQLQueryResult(query);
        SQLQueryResult.ExecuteResult executeResult = resultInfo.addExecuteResult(true);
        if (this.statistics.getStatementsCount() > 1) {
            fakeResultSet.addColumn("Queries", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Execute time", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Fetch time", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Total time", DBPDataKind.NUMERIC);
            fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
            fakeResultSet.addRow(new Object[]{this.statistics.getStatementsCount(), this.statistics.getRowsUpdated(), this.statistics.getExecuteTime(), this.statistics.getFetchTime(), this.statistics.getTotalTime(), new Date()});
            executeResult.setResultSetName("Statistics");
        } else {
            long updateCount = this.statistics.getRowsUpdated();
            if (updateCount >= 0L) {
                fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Query", DBPDataKind.STRING);
                fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
                fakeResultSet.addRow(new Object[]{updateCount, query.getText(), new Date()});
            } else {
                fakeResultSet.addColumn("Result", DBPDataKind.NUMERIC);
            }
            executeResult.setResultSetName("Result");
        }
        this.fetchQueryData(session, (DBCResultSet)fakeResultSet, resultInfo, executeResult, dataReceiver, false);
    }

    private boolean prepareStatementParameters(SQLQuery sqlStatement) {
        List parameters = sqlStatement.getParameters();
        if (CommonUtils.isEmpty((Collection)parameters)) {
            return true;
        }
        if (!this.fillStatementParameters(parameters)) {
            return false;
        }
        String query = sqlStatement.getText();
        int i = parameters.size();
        while (i > 0) {
            SQLQueryParameter parameter = (SQLQueryParameter)parameters.get(i - 1);
            String paramValue = parameter.getValue();
            if (paramValue == null || paramValue.isEmpty()) {
                paramValue = "NULL";
            }
            query = String.valueOf(query.substring(0, parameter.getTokenOffset())) + paramValue + query.substring(parameter.getTokenOffset() + parameter.getTokenLength());
            --i;
        }
        sqlStatement.setText(query);
        return true;
    }

    private boolean fillStatementParameters(final List<SQLQueryParameter> parameters) {
        String strValue;
        for (SQLQueryParameter param : parameters) {
            String paramName = param.getTitle();
            if (this.scriptContext.hasVariable(paramName)) {
                Object varValue = this.scriptContext.getVariable(paramName);
                strValue = varValue == null ? null : varValue.toString();
                param.setValue(strValue);
                param.setVariableSet(true);
                continue;
            }
            param.setVariableSet(false);
        }
        boolean allSet = true;
        for (SQLQueryParameter param : parameters) {
            if (param.isVariableSet()) continue;
            allSet = false;
        }
        if (allSet) {
            return true;
        }
        boolean okPressed = (Boolean)new UIConfirmation(){

            public Boolean runTask() {
                SQLQueryParameterBindDialog dialog = new SQLQueryParameterBindDialog(SQLQueryJob.this.partSite.getShell(), parameters);
                if (dialog.open() == 0) {
                    return true;
                }
                return false;
            }
        }.execute();
        if (okPressed) {
            for (SQLQueryParameter param : parameters) {
                if (!param.isNamed() || !this.scriptContext.hasVariable(param.getTitle())) continue;
                strValue = param.getValue();
                this.scriptContext.setVariable(param.getTitle(), (Object)strValue);
            }
        }
        return okPressed;
    }

    private boolean fetchQueryData(DBCSession session, DBCResultSet resultSet, SQLQueryResult result, SQLQueryResult.ExecuteResult executeResult, DBDDataReceiver dataReceiver, boolean updateStatistics) throws DBCException {
        if (dataReceiver == null) {
            return false;
        }
        if (resultSet == null) {
            return false;
        }
        boolean keepCursor = this.keepStatementOpen();
        if (keepCursor) {
            this.curResultSets.add(resultSet);
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Fetch result set");
        long rowCount = 0L;
        dataReceiver.fetchStart(session, resultSet, this.rsOffset, this.rsMaxRows);
        try {
            String sourceName = null;
            if (result != null) {
                String queryTitle = result.getStatement().getQueryTitle();
                if (!CommonUtils.isEmpty((String)queryTitle)) {
                    sourceName = queryTitle;
                } else {
                    DBCResultSetMetaData rsMeta = resultSet.getMeta();
                    for (DBCAttributeMetaData attr : rsMeta.getAttributes()) {
                        String entityName = attr.getEntityName();
                        if (CommonUtils.isEmpty((String)entityName)) continue;
                        if (sourceName == null) {
                            sourceName = entityName;
                            continue;
                        }
                        if (sourceName.equals(entityName)) continue;
                        sourceName = String.valueOf(sourceName) + "(+)";
                        break;
                    }
                    if (CommonUtils.isEmpty((String)sourceName)) {
                        try {
                            sourceName = resultSet.getResultSetName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (CommonUtils.isEmpty((String)sourceName)) {
                    sourceName = "Result";
                }
                executeResult.setResultSetName(sourceName);
            }
            long fetchStartTime = System.currentTimeMillis();
            while ((!this.hasLimits() || rowCount < this.rsMaxRows) && resultSet.nextRow()) {
                if (monitor.isCanceled()) break;
                if (++rowCount > 0L && rowCount % 100L == 0L) {
                    monitor.subTask(String.valueOf(rowCount) + " rows fetched");
                    monitor.worked(100);
                }
                dataReceiver.fetchRow(session, resultSet);
            }
            if (updateStatistics) {
                this.statistics.addFetchTime(System.currentTimeMillis() - fetchStartTime);
            }
        }
        finally {
            if (!keepCursor) {
                try {
                    resultSet.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Error while closing resultset", e);
                }
            }
            try {
                dataReceiver.fetchEnd(session, resultSet);
            }
            catch (Throwable e) {
                log.error((Object)"Error while handling end of result set fetch", e);
            }
            dataReceiver.close();
        }
        if (result != null) {
            executeResult.setRowCount(Long.valueOf(rowCount));
        }
        if (updateStatistics) {
            this.statistics.setRowsFetched(rowCount);
        }
        monitor.subTask(String.valueOf(rowCount) + " rows fetched");
        return true;
    }

    private boolean keepStatementOpen() {
        return this.queries.size() == 1 && this.getDataSourceContainer().getPreferenceStore().getBoolean("keep.statement.open");
    }

    private void closeStatement() {
        if (this.curStatement != null) {
            try {
                for (DBCResultSet resultSet : this.curResultSets) {
                    resultSet.close();
                }
            }
            finally {
                block15: {
                    this.curResultSets.clear();
                    try {
                        try {
                            this.curStatement.close();
                        }
                        catch (Throwable e) {
                            log.error((Object)"Error closing statement", e);
                            this.curStatement = null;
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        this.curStatement = null;
                        throw throwable;
                    }
                    this.curStatement = null;
                }
            }
        }
    }

    public void extractData(@NotNull DBCSession session, @NotNull SQLScriptElement query, int resultNumber) throws DBCException {
        query.reset();
        this.statistics = new DBCStatistics();
        this.resultSetNumber = resultNumber;
        session.getProgressMonitor().beginTask(CommonUtils.truncateString((String)query.getText(), (int)512), 1);
        try {
            boolean result = this.executeSingleQuery(session, query, true);
            if (!result && this.lastError != null) {
                if (this.lastError instanceof DBCException) {
                    throw (DBCException)this.lastError;
                }
                throw new DBCException(this.lastError, this.getExecutionContext().getDataSource());
            }
            if (result && this.statistics.getStatementsCount() > 0) {
                this.showExecutionResult(session);
            }
        }
        finally {
            session.getProgressMonitor().done();
        }
    }

    public void setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setFetchResultSetNumber(int fetchResultSetNumber) {
        this.fetchResultSetNumber = fetchResultSetNumber;
    }

    public void closeJob() {
        this.closeStatement();
    }

    private int confirmQueryExecution(final @NotNull SQLQuery query, final boolean scriptMode) {
        final DBPConnectionType connectionType = this.getDataSourceContainer().getConnectionConfiguration().getConnectionType();
        return (Integer)new UITask<Integer>(){

            protected Integer runTask() {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(UIUtils.getActiveWorkbenchShell(), "Confirm query execution", null, "You are in '" + connectionType.getName() + "' connection.\nDo you confirm query execution?", 4, ConfirmationDialog.getButtonLabels(6), 0, "Do not ask for " + connectionType.getName() + " connections", false){

                    protected boolean isResizable() {
                        return true;
                    }

                    protected IDialogSettings getDialogBoundsSettings() {
                        return UIUtils.getDialogSettings((String)"DBeaver.SQLQueryConfirmDialog");
                    }

                    protected void createDialogAndButtonArea(Composite parent) {
                        this.dialogArea = this.createDialogArea(parent);
                        if (this.dialogArea.getLayoutData() instanceof GridData) {
                            ((GridData)this.dialogArea.getLayoutData()).grabExcessVerticalSpace = false;
                        }
                        Text messageText = new Text(parent, 2634);
                        messageText.setText(query.getText());
                        GridData gd = new GridData(1808);
                        gd.heightHint = UIUtils.getFontHeight((Control)messageText) * 4 + 10;
                        gd.horizontalSpan = 2;
                        messageText.setLayoutData((Object)gd);
                        this.buttonBar = this.createButtonBar(parent);
                        1.applyDialogFont((Control)parent);
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
                        if (scriptMode) {
                            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
                            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                        }
                    }
                };
                int result = dialog.open();
                if (dialog.getToggleState()) {
                    connectionType.setConfirmExecute(false);
                    DataSourceProviderRegistry.getInstance().saveConnectionTypes();
                }
                return result;
            }
        }.execute();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$ui$dialogs$exec$ExecutionQueueErrorResponse() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$ui$dialogs$exec$ExecutionQueueErrorResponse != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$ui$dialogs$exec$ExecutionQueueErrorResponse;
        }
        int[] nArray = new int[ExecutionQueueErrorResponse.values().length];
        try {
            nArray[ExecutionQueueErrorResponse.IGNORE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExecutionQueueErrorResponse.IGNORE_ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExecutionQueueErrorResponse.RETRY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExecutionQueueErrorResponse.STOP.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$ui$dialogs$exec$ExecutionQueueErrorResponse = nArray;
        return nArray;
    }
}

