/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.functions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.aggregate.IAggregateFunction;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.AbstractContextDescriptor;
import org.jkiss.utils.CommonUtils;

public class AggregateFunctionDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.aggregateFunction";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final String type;
    private final boolean isDefault;

    public AggregateFunctionDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.type = config.getAttribute("type");
        this.isDefault = CommonUtils.toBoolean((Object)config.getAttribute("default"));
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public IAggregateFunction createFunction() throws DBException {
        return (IAggregateFunction)this.implClass.createInstance(IAggregateFunction.class);
    }
}

