/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.editor;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.AbstractContextDescriptor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInputFactory;
import org.jkiss.dbeaver.ui.editors.entity.properties.ObjectPropertiesEditor;
import org.jkiss.dbeaver.ui.editors.entity.properties.ObjectPropertiesEditorInputFactory;
import org.jkiss.utils.CommonUtils;

public class EntityEditorDescriptor
extends AbstractContextDescriptor {
    private static final Log log = Log.getLog(EntityEditorDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.databaseEditor";
    public static final String DEFAULT_OBJECT_EDITOR_ID = "default.object.editor";
    public static final String POSITION_PROPS = "additions_props";
    public static final String POSITION_START = "additions_start";
    public static final String POSITION_MIDDLE = "additions_middle";
    public static final String POSITION_END = "additions_end";
    private String id;
    private AbstractDescriptor.ObjectType editorType;
    private AbstractDescriptor.ObjectType contributorType;
    private AbstractDescriptor.ObjectType inputFactoryType;
    private boolean main;
    private String name;
    private String description;
    private String position;
    private DBPImage icon;
    private Type type;
    private boolean embeddable;

    EntityEditorDescriptor() {
        super(null);
        this.id = DEFAULT_OBJECT_EDITOR_ID;
        this.editorType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, ObjectPropertiesEditor.class.getName());
        this.contributorType = null;
        this.inputFactoryType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, ObjectPropertiesEditorInputFactory.class.getName());
        this.main = true;
        this.name = CoreMessages.registry_entity_editor_descriptor_name;
        this.description = CoreMessages.registry_entity_editor_descriptor_description;
        this.position = null;
        this.icon = DBIcon.TREE_DATABASE;
        this.type = Type.editor;
    }

    public EntityEditorDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.editorType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.contributorType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("contributor"));
        this.inputFactoryType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("inputFactory"));
        this.main = CommonUtils.getBoolean((String)config.getAttribute("main"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.position = config.getAttribute("position");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        String typeName = config.getAttribute("type");
        this.type = !CommonUtils.isEmpty((String)typeName) ? Type.valueOf(typeName) : Type.editor;
        this.embeddable = CommonUtils.toBoolean((Object)config.getAttribute("embeddable"));
    }

    public String getId() {
        return this.id;
    }

    public boolean isMain() {
        return this.main;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPosition() {
        return this.position;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public Class<? extends IEditorActionBarContributor> getContributorClass() {
        return this.contributorType == null || this.contributorType.getImplName() == null ? null : this.contributorType.getObjectClass(IEditorActionBarContributor.class);
    }

    public IEditorInput getNestedEditorInput(IDatabaseEditorInput mainInput) {
        if (this.inputFactoryType == null || this.inputFactoryType.getImplName() == null) {
            return mainInput;
        }
        try {
            IDatabaseEditorInputFactory instance = (IDatabaseEditorInputFactory)this.inputFactoryType.createInstance(IDatabaseEditorInputFactory.class);
            if (instance != null) {
                return instance.createNestedEditorInput(mainInput);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error instantiating input factory", (Throwable)e);
        }
        return mainInput;
    }

    public IEditorPart createEditor() {
        try {
            return (IEditorPart)this.editorType.createInstance(IEditorPart.class);
        }
        catch (Exception ex) {
            log.error((Object)("Error instantiating entity editor '" + this.editorType.getImplName() + "'"), (Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return this.id;
    }

    public static enum Type {
        editor,
        folder;

    }
}

