/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.exec;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.dbeaver.ee.cassandra.exec.CasResultSet;
import com.dbeaver.ee.cassandra.exec.CasSession;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class CasBaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(CasBaseStatement.class);
    protected final CasSession session;
    protected final String query;
    protected DBCExecutionSource source;
    protected ResultSet result;
    protected Throwable executeError;
    protected long offset;
    protected long limit;
    protected int updateCount = -1;
    protected int statementTimeout;
    protected volatile ResultSetFuture resultSetFuture;

    protected CasBaseStatement(CasSession casSession, String string) {
        this.session = casSession;
        this.query = string;
        if (casSession.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @NotNull
    public CasSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource dBCExecutionSource) {
        this.source = dBCExecutionSource;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public CasResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new CasResultSet(this, this.result);
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return this.updateCount;
    }

    public boolean nextResults() {
        return false;
    }

    public void close() {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    public void setLimit(long l, long l2) throws DBCException {
        this.offset = l;
        this.limit = l2;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        ExecutionInfo executionInfo;
        if (this.result != null && (executionInfo = this.result.getExecutionInfo()) != null && !CommonUtils.isEmpty((Collection)executionInfo.getWarnings())) {
            List list = executionInfo.getWarnings();
            Throwable[] throwableArray = new Throwable[list.size()];
            int n = 0;
            while (n < list.size()) {
                String string = (String)list.get(n);
                throwableArray[n] = new Exception(string);
                ++n;
            }
            return throwableArray;
        }
        return null;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable Thread thread) throws DBException {
        ResultSetFuture resultSetFuture = this.resultSetFuture;
        if (resultSetFuture != null) {
            if (!resultSetFuture.cancel(true)) {
                throw new DBException("Can't cancel future result set");
            }
        } else if (thread != null) {
            thread.interrupt();
        } else {
            throw new DBException("Can't cancel - no future result set");
        }
    }

    public void setStatementTimeout(int n) throws DBCException {
        this.statementTimeout = n;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public abstract Statement getStatementImpl();

    protected DBCException handleExecuteError(Throwable throwable) {
        this.executeError = throwable;
        if (throwable instanceof DBCException) {
            return (DBCException)throwable;
        }
        return new DBCException(throwable, (DBPDataSource)this.session.getDataSource());
    }

    public void startBlock(String string) {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, "Execute prepared statement");
    }

    public void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }
}

