/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data.handlers;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.data.handlers.CasBaseValueHandler;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasNumberValueHandler
extends CasBaseValueHandler {
    private static final Log log = Log.getLog(CasNumberValueHandler.class);
    private DataType.Name typeName;
    private DBDDataFormatter formatter;

    public CasNumberValueHandler(DBSTypedObject dBSTypedObject, DataType.Name name, DBDDataFormatterProfile dBDDataFormatterProfile) {
        this.typeName = name;
        try {
            this.formatter = dBDDataFormatterProfile.createFormatter("number", dBSTypedObject);
        }
        catch (Exception exception) {
            log.error((Object)"Can't create formatter for number value handler", (Throwable)exception);
            this.formatter = DefaultDataFormatter.INSTANCE;
        }
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject dBSTypedObject, @Nullable Object object, @NotNull DBDDisplayFormat dBDDisplayFormat) {
        if (object == null) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)dBDDisplayFormat);
        }
        if (dBDDisplayFormat == DBDDisplayFormat.NATIVE || dBDDisplayFormat == DBDDisplayFormat.EDIT) {
            if (object instanceof Number) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)object));
            }
            return object.toString();
        }
        return this.formatter.formatValue(object);
    }

    @NotNull
    public Class<? extends Number> getValueObjectType(@NotNull DBSTypedObject dBSTypedObject) {
        return this.getNumberType(dBSTypedObject);
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession dBCSession, @NotNull DBSTypedObject dBSTypedObject, Object object, boolean bl) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object;
        }
        return DBValueFormatting.convertStringToNumber((String)object.toString(), this.getNumberType(dBSTypedObject), (DBDDataFormatter)this.formatter);
    }

    public Class<? extends Number> getNumberType(DBSTypedObject dBSTypedObject) {
        switch (this.typeName) {
            case SMALLINT: {
                return Short.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case INT: {
                return Integer.class;
            }
            case BIGINT: 
            case COUNTER: {
                return Long.class;
            }
            case VARINT: {
                return BigInteger.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
        }
        return Long.class;
    }

    @Override
    protected void bindParameter(CasSession casSession, CasPreparedStatement casPreparedStatement, DBSTypedObject dBSTypedObject, int n, Object object) throws DBCException {
        BoundStatement boundStatement = casPreparedStatement.getBoundStatement();
        if (!(object instanceof Number)) {
            boundStatement.setToNull(n);
        } else {
            switch (this.typeName) {
                case SMALLINT: {
                    boundStatement.setShort(n, ((Number)object).shortValue());
                    break;
                }
                case TINYINT: {
                    boundStatement.setByte(n, ((Number)object).byteValue());
                    break;
                }
                case INT: {
                    boundStatement.setInt(n, ((Number)object).intValue());
                    break;
                }
                case BIGINT: 
                case COUNTER: {
                    boundStatement.setLong(n, ((Number)object).longValue());
                    break;
                }
                case VARINT: {
                    boundStatement.setVarint(n, object instanceof BigInteger ? (BigInteger)object : BigInteger.valueOf(((Number)object).longValue()));
                    break;
                }
                case DECIMAL: {
                    boundStatement.setDecimal(n, object instanceof BigDecimal ? (BigDecimal)object : BigDecimal.valueOf(((Number)object).longValue()));
                    break;
                }
                case FLOAT: {
                    boundStatement.setFloat(n, ((Number)object).floatValue());
                    break;
                }
                case DOUBLE: {
                    boundStatement.setDouble(n, ((Number)object).doubleValue());
                    break;
                }
                default: {
                    boundStatement.setLong(n, ((Number)object).longValue());
                }
            }
        }
    }
}

