/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import com.dbeaver.ee.cassandra.data.CasAbstractValue;
import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.CasListValue;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.CasSetValue;
import com.dbeaver.ee.cassandra.exec.CasResultSet;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasUserType;
import com.dbeaver.ee.cassandra.model.CasUserTypeAttribute;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CasUDTValue
extends CasAbstractValue
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasUDTValue.class);
    @Nullable
    private UDTValue rawValue;
    @Nullable
    private CasUserType userType;

    public CasUDTValue(@NotNull CasDataSource casDataSource, @NotNull String string, @Nullable UDTValue uDTValue) throws DBCException {
        super(casDataSource, string);
        this.rawValue = uDTValue;
        if (uDTValue == null) {
            this.userType = null;
        } else {
            String string2 = uDTValue.getType().getKeyspace();
            CasKeyspace casKeyspace = casDataSource.getKeyspace(string2);
            if (casKeyspace == null) {
                throw new DBCException("UDT keyspace '" + string2 + "' not found");
            }
            try {
                this.userType = casKeyspace.getUserType((DBRProgressMonitor)new VoidProgressMonitor(), (DataType)uDTValue.getType());
            }
            catch (DBException dBException) {
                throw new DBCException("Error reading user type for UDT", (Throwable)dBException);
            }
            if (this.userType == null) {
                throw new DBCException("Can't find user type for UDT value: " + uDTValue.getType());
            }
        }
    }

    public CasUDTValue(CasUDTValue casUDTValue) {
        super(casUDTValue);
        this.rawValue = casUDTValue.rawValue;
        this.userType = casUDTValue.userType;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor dBRProgressMonitor) {
        return new CasUDTValue(this);
    }

    public UDTValue getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.rawValue = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.rawValue.toString();
    }

    public CasUserType getDataType() {
        return this.userType;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.userType == null) {
            return new DBSAttributeBase[0];
        }
        try {
            Collection collection = this.userType.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            if (collection == null) {
                return new DBSAttributeBase[0];
            }
            DBSAttributeBase[] dBSAttributeBaseArray = new DBSAttributeBase[collection.size()];
            collection.toArray(dBSAttributeBaseArray);
            return dBSAttributeBaseArray;
        }
        catch (DBException dBException) {
            log.error((Object)dBException);
            return new DBSAttributeBase[0];
        }
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase dBSAttributeBase) throws DBCException {
        if (this.rawValue == null) {
            return null;
        }
        int n = dBSAttributeBase.getOrdinalPosition() - 1;
        DataType dataType = ((CasUserTypeAttribute)dBSAttributeBase).getCasDataType();
        switch (dataType.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.rawValue.getString(n);
            }
            case TINYINT: {
                return this.rawValue.getByte(n);
            }
            case SMALLINT: {
                return this.rawValue.getShort(n);
            }
            case INT: {
                return this.rawValue.getInt(n);
            }
            case BIGINT: {
                return this.rawValue.getLong(n);
            }
            case COUNTER: {
                return this.rawValue.getLong(n);
            }
            case VARINT: {
                return this.rawValue.getVarint(n);
            }
            case DECIMAL: {
                return this.rawValue.getDecimal(n);
            }
            case FLOAT: {
                return Float.valueOf(this.rawValue.getFloat(n));
            }
            case DOUBLE: {
                return this.rawValue.getDouble(n);
            }
            case BOOLEAN: {
                return this.rawValue.getBool(n);
            }
            case DATE: {
                return this.rawValue.getDate(n);
            }
            case TIME: {
                return this.rawValue.getTime(n);
            }
            case TIMESTAMP: {
                return this.rawValue.getTimestamp(n);
            }
            case UUID: 
            case TIMEUUID: {
                return this.rawValue.getUUID(n);
            }
            case INET: {
                return this.rawValue.getInet(n);
            }
            case MAP: {
                return new CasMapValue(this.dataSource, this.keyspace, this.rawValue.getMap(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(1))), dataType);
            }
            case LIST: {
                return new CasListValue((DBRProgressMonitor)new VoidProgressMonitor(), this.dataSource, this.keyspace, this.rawValue.getList(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0))), dataType);
            }
            case SET: {
                return new CasSetValue(this.dataSource, this.keyspace, this.rawValue.getSet(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0))), dataType);
            }
            case TUPLE: {
                return this.rawValue.getTupleValue(n);
            }
            case UDT: {
                return new CasUDTValue(this.dataSource, this.keyspace, this.rawValue.getUDTValue(n));
            }
        }
        return new CasContentBytes(this.dataSource, this.rawValue.getBytes(n));
    }

    public void setAttributeValue(@NotNull DBSAttributeBase dBSAttributeBase, @Nullable Object object) {
        log.error((Object)"UDT value set not implemented yet");
    }
}

