/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data;

import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.data.CasAbstractValue;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasSetValue
extends CasAbstractValue
implements DBDCollection,
DBDValueCloneable {
    private List<Object> contents;
    @NotNull
    private DataType type;
    @NotNull
    private CasDataType componentType;
    private boolean modified;

    public CasSetValue(@NotNull CasDataSource casDataSource, String string, Collection<Object> collection, @NotNull DataType dataType) throws DBCException {
        super(casDataSource, string);
        Object object2;
        if (collection != null) {
            this.contents = new ArrayList<Object>(collection.size());
            for (Object object2 : collection) {
                this.contents.add(CasUtils.wrapValue(casDataSource, string, object2));
            }
        }
        this.type = dataType;
        object2 = dataType.getTypeArguments();
        this.componentType = object2.size() == 1 ? casDataSource.getLocalDataType(((DataType)object2.get(0)).getName().toString()) : casDataSource.getLocalDataType(dataType.getName().toString());
    }

    public CasSetValue(@NotNull CasSetValue casSetValue) throws DBCException {
        this(casSetValue.dataSource, casSetValue.keyspace, casSetValue.contents, casSetValue.type);
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.componentType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.componentType);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor dBRProgressMonitor) throws DBCException {
        return new CasSetValue(this.dataSource, this.keyspace, this.contents, this.type);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        DBDValueHandler dBDValueHandler = this.getComponentValueHandler();
        StringBuilder stringBuilder = new StringBuilder(this.contents.size() * 32);
        stringBuilder.append("{");
        int n = 0;
        while (n < this.contents.size()) {
            Object object = this.contents.get(n);
            if (n > 0) {
                stringBuilder.append(',');
            }
            String string = dBDValueHandler.getValueDisplayString((DBSTypedObject)this.componentType, object, DBDDisplayFormat.NATIVE);
            SQLUtils.appendValue((StringBuilder)stringBuilder, (DBSTypedObject)this.componentType, (Object)string);
            ++n;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public Object getItem(int n) {
        return this.contents.get(n);
    }

    public void setItem(int n, Object object) {
        this.contents.set(n, object);
        this.modified = true;
    }

    public void setContents(Object[] objectArray) {
        if (this.contents == null) {
            this.contents = new ArrayList<Object>();
        } else {
            this.contents.clear();
        }
        Collections.addAll(this.contents, objectArray);
        this.modified = true;
    }

    public Set<Object> makeSet() {
        if (this.contents == null) {
            return null;
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(this.contents.size());
        for (Object object : this.contents) {
            linkedHashSet.add(CasUtils.unwrapValue(this.dataSource, object));
        }
        return linkedHashSet;
    }
}

