/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.data.AbstractContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CasContentBytes
extends AbstractContent
implements DBDValueCloneable,
DBDContentStorage,
DBDContentCached {
    private static final Log log = Log.getLog(CasContentBytes.class);
    private ByteBuffer originalData;
    private ByteBuffer data;

    public CasContentBytes(DBPDataSource dBPDataSource) {
        super(dBPDataSource);
        this.originalData = null;
        this.data = null;
    }

    public CasContentBytes(DBPDataSource dBPDataSource, ByteBuffer byteBuffer) {
        super(dBPDataSource);
        this.data = this.originalData = byteBuffer;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public InputStream getContentStream() throws IOException {
        if (this.data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.data.array(), this.data.position(), this.data.limit() - this.data.position());
    }

    public Reader getContentReader() throws IOException {
        return new InputStreamReader(this.getContentStream());
    }

    public long getContentLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.limit() - this.data.position();
    }

    public String getCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)this.dataSource);
    }

    public CasContentBytes cloneStorage(DBRProgressMonitor dBRProgressMonitor) throws IOException {
        return this.cloneValue(dBRProgressMonitor);
    }

    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    public DBDContentStorage getContents(DBRProgressMonitor dBRProgressMonitor) throws DBCException {
        return this;
    }

    public boolean updateContents(DBRProgressMonitor dBRProgressMonitor, DBDContentStorage dBDContentStorage) throws DBException {
        if (dBDContentStorage == null) {
            this.data = null;
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream inputStream = dBDContentStorage.getContentStream();){
                    byte[] byArray = new byte[(int)dBDContentStorage.getContentLength()];
                    int n = inputStream.read(byArray);
                    if (n != byArray.length) {
                        log.warn((Object)("Actual content length (" + n + ") is less than declared (" + byArray.length + ")"));
                    }
                    this.data = ByteBuffer.wrap(byArray);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw new DBCException("IO error while reading content", (Throwable)iOException);
            }
        }
        this.modified = true;
        return false;
    }

    public void resetContents() {
        this.data = this.originalData;
        this.modified = false;
    }

    public Object getRawValue() {
        return this.data;
    }

    public boolean isNull() {
        return this.data == null;
    }

    public void release() {
        this.data = this.originalData;
    }

    public String getDisplayString(DBDDisplayFormat dBDDisplayFormat) {
        int n;
        if (this.data == null) {
            return null;
        }
        DBDBinaryFormatter dBDBinaryFormatter = DBValueFormatting.getBinaryPresentation((DBPDataSource)this.dataSource);
        int n2 = this.dataSource.getContainer().getPreferenceStore().getInt("resultset.binary.stringMaxLength");
        int n3 = n = this.data.limit() - this.data.position();
        if (dBDDisplayFormat == DBDDisplayFormat.UI && n3 > n2) {
            n3 = n2;
        }
        String string = dBDBinaryFormatter.toString(this.data.array(), this.data.position(), n);
        if (n3 == n) {
            return string;
        }
        return String.valueOf(string) + "..." + " [" + n + "]";
    }

    public CasContentBytes cloneValue(DBRProgressMonitor dBRProgressMonitor) {
        return new CasContentBytes(this.dataSource, this.data);
    }

    public Object getCachedValue() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CasContentBytes) {
            return CommonUtils.equalObjects((Object)this.data, (Object)((CasContentBytes)((Object)object)).data);
        }
        return false;
    }

    public String toString() {
        return this.getDisplayString(DBDDisplayFormat.NATIVE);
    }
}

