/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.CasSetValue;
import com.dbeaver.ee.cassandra.data.CasTupleValue;
import com.dbeaver.ee.cassandra.data.CasUDTValue;
import com.dbeaver.ee.cassandra.model.CasAbstractDataType;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class CasUtils {
    private static final Log log = Log.getLog(CasUtils.class);
    private static Field typeProtocolField;

    static {
        try {
            typeProtocolField = DataType.Name.class.getDeclaredField("protocolId");
            typeProtocolField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            log.debug((Object)noSuchFieldException);
        }
    }

    public static int getTypeNameID(DataType dataType) {
        return CasUtils.getTypeNameID(dataType.getName());
    }

    public static int getTypeNameID(DataType.Name name) {
        if (typeProtocolField != null) {
            try {
                return (Integer)typeProtocolField.get(name);
            }
            catch (Exception exception) {
                log.debug((Object)"Error reading type ID", (Throwable)exception);
            }
        }
        return name.ordinal();
    }

    public static DBPDataKind getDataKind(DataType dataType) {
        return CasUtils.getDataKind(dataType.getName());
    }

    public static DBPDataKind getDataKind(DataType.Name name) {
        switch (name) {
            case BOOLEAN: {
                return DBPDataKind.BOOLEAN;
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return DBPDataKind.STRING;
            }
            case BIGINT: 
            case COUNTER: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case VARINT: 
            case SMALLINT: 
            case TINYINT: {
                return DBPDataKind.NUMERIC;
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return DBPDataKind.DATETIME;
            }
            case CUSTOM: 
            case UUID: 
            case TIMEUUID: 
            case INET: 
            case TUPLE: {
                return DBPDataKind.OBJECT;
            }
            case UDT: {
                return DBPDataKind.STRUCT;
            }
            case MAP: {
                return DBPDataKind.ARRAY;
            }
            case LIST: 
            case SET: {
                return DBPDataKind.ARRAY;
            }
        }
        return DBPDataKind.BINARY;
    }

    public static String transformCQL(CasDataSource casDataSource, String string, DBDDataFilter dBDDataFilter) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (dBDDataFilter != null && dBDDataFilter.hasConditions()) {
            stringBuilder.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)dBDDataFilter, (DBPDataSource)casDataSource, null, (StringBuilder)stringBuilder, (boolean)true);
        }
        if (dBDDataFilter != null && dBDDataFilter.hasOrdering()) {
            stringBuilder.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)dBDDataFilter, (DBPDataSource)casDataSource, null, (StringBuilder)stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static Object wrapValue(CasDataSource casDataSource, String string, Object object) throws DBCException {
        if (object instanceof ByteBuffer) {
            return new CasContentBytes(casDataSource, (ByteBuffer)object);
        }
        return object;
    }

    public static Object unwrapValue(CasDataSource casDataSource, Object object) {
        if (object instanceof CasContentBytes) {
            return ((CasContentBytes)((Object)object)).getData();
        }
        if (object instanceof CasSetValue) {
            return ((CasSetValue)object).makeSet();
        }
        if (object instanceof CasMapValue) {
            return ((CasMapValue)object).makeMap();
        }
        if (object instanceof CasUDTValue) {
            return ((CasUDTValue)object).getRawValue();
        }
        if (object instanceof CasTupleValue) {
            return ((CasTupleValue)object).getRawValue();
        }
        return object;
    }

    @NotNull
    public static LocalDate toLocalDate(Date date) {
        return LocalDate.fromMillisSinceEpoch((long)(date.getTime() + (long)TimeZone.getDefault().getRawOffset()));
    }

    public static long toCasTime(Date date) {
        return (date.getTime() + (long)TimeZone.getDefault().getRawOffset()) * 1000000L;
    }

    public static CasAbstractDataType resolveDataType(DBRProgressMonitor dBRProgressMonitor, CasDataSource casDataSource, String string, DataType dataType) throws DBException {
        if (dataType instanceof TupleType) {
            return casDataSource.getCachedTupleType((TupleType)dataType);
        }
        if (dataType instanceof UserType) {
            return casDataSource.getKeyspace(string).getUserType(dBRProgressMonitor, dataType);
        }
        return casDataSource.getLocalDataType(dataType.toString());
    }
}

