/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.model;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisBaseResultSet;
import com.dbeaver.ee.redis.exec.RedisKeySizeStatement;
import com.dbeaver.ee.redis.exec.RedisKeyStatement;
import com.dbeaver.ee.redis.exec.RedisSession;
import com.dbeaver.ee.redis.model.RedisDataSource;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisKeyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class RedisKey
implements DBSObject,
DBSDataContainer,
DBPSaveableObject,
DBPQualifiedObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedisKey.class);
    private static final List<RedisKey> EMPTY_SUB_KEYS = Collections.emptyList();
    private final RedisDatabase database;
    private final RedisKey parentKey;
    private final String keyName;
    private RedisKeyType keyType;
    private Long ttl;
    private long keySize = -1L;
    private boolean isFolder;
    private boolean persisted;
    private List<RedisKey> subKeys;

    public RedisKey(@NotNull RedisDatabase database, @Nullable RedisKey parentKey, @NotNull String keyName, boolean isFolder) {
        this.database = database;
        this.parentKey = parentKey;
        this.keyName = keyName;
        this.isFolder = isFolder;
        this.persisted = true;
    }

    @Association
    @Nullable
    public RedisKey getParentKey() {
        return this.parentKey;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.keyName;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public RedisKeyType getKeyType(DBRProgressMonitor monitor) {
        if (this.keyType == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Read key [" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "] type"));){
                    this.keyType = RedisKeyType.valueOf(session.getJedis().type(this.getFullyQualifiedName(DBPEvaluationContext.DML)));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error getting key type", e);
                this.keyType = RedisKeyType.string;
            }
        }
        return this.keyType;
    }

    @Property(viewable=false, order=3)
    public long getTTL(DBRProgressMonitor monitor) {
        if (this.ttl == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Read key [" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "] TTL"));){
                    this.ttl = session.getJedis().ttl(this.getFullyQualifiedName(DBPEvaluationContext.DML));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            if (this.ttl == null) {
                this.ttl = -1L;
            }
        }
        return this.ttl;
    }

    @Property(viewable=false, order=4)
    public long getKeySize(DBRProgressMonitor monitor) throws DBCException {
        if (this.keySize < 0L) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Count key size");){
                this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, DBUtils.getDefaultContext((DBSObject)this, (boolean)true), (Object)this), (DBCSession)session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.keySize;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.parentKey != null ? this.parentKey : this.getDataSource().getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    @Association
    public List<RedisKey> getKeys(DBRProgressMonitor monitor) throws DBCException {
        if (this.subKeys == null) {
            this.subKeys = RedisUtils.getKeys(monitor, this.database, this, null, true);
        }
        return this.subKeys;
    }

    public void setSubKeys(List<String> keys, String divider) {
        if (keys == null) {
            return;
        }
        if (keys.isEmpty()) {
            if (this.subKeys == null) {
                this.subKeys = EMPTY_SUB_KEYS;
            }
            return;
        }
        for (String key : keys) {
            this.addSubKey(key, divider);
        }
    }

    private void addSubKey(String key, String divider) {
        String keyName;
        String subKey;
        int divPos;
        if (this.subKeys == null) {
            this.subKeys = new ArrayList<RedisKey>();
        }
        if ((divPos = key.indexOf(divider)) != -1) {
            subKey = key.substring(divPos + 1);
            keyName = key.substring(0, divPos);
        } else {
            keyName = key;
            subKey = null;
        }
        RedisKey child = null;
        for (RedisKey k : this.subKeys) {
            if (!k.keyName.equals(keyName)) continue;
            child = k;
            break;
        }
        if (child == null) {
            child = new RedisKey(this.database, this, keyName, subKey != null);
            this.subKeys.add(child);
        }
        if (subKey != null) {
            super.addSubKey(subKey, divider);
        }
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.parentKey == null) {
            return this.getName();
        }
        String keyDivider = this.getDataSource().getKeyDivider();
        StringBuilder fqn = new StringBuilder();
        RedisKey key = this;
        while (key != null) {
            if (fqn.length() > 0) {
                fqn.insert(0, keyDivider);
            }
            fqn.insert(0, key.keyName);
            key = key.parentKey;
        }
        return fqn.toString();
    }

    public int getSupportedFeatures() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags) throws DBCException {
        if (firstRow > 0L) {
            return new DBCStatistics();
        }
        try {
            Throwable throwable = null;
            Object var12_10 = null;
            try {
                RedisKeyStatement keyStatement = new RedisKeyStatement((RedisSession)session, this.getFullyQualifiedName(DBPEvaluationContext.DML), this.getKeyType(session.getProgressMonitor()), firstRow, maxRows);
                try {
                    keyStatement.executeStatement();
                    Throwable throwable2 = null;
                    Object var15_15 = null;
                    try {
                        DBCStatistics dBCStatistics;
                        RedisBaseResultSet resultSet = keyStatement.openResultSet();
                        dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
                        DBCStatistics statistics = new DBCStatistics();
                        int rowFetched = 0;
                        long startTime = System.currentTimeMillis();
                        while (true) {
                            if (!resultSet.nextRow()) {
                                statistics.setFetchTime(System.currentTimeMillis() - startTime);
                                statistics.setRowsFetched((long)rowFetched);
                                statistics.setStatementsCount(1);
                                dBCStatistics = statistics;
                                break;
                            }
                            dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                            ++rowFetched;
                        }
                        if (keyStatement != null) {
                            keyStatement.close();
                        }
                        dataReceiver.close();
                        return dBCStatistics;
                        {
                            finally {
                                dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (keyStatement == null) throw throwable4;
                    keyStatement.close();
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            dataReceiver.close();
            throw throwable;
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        if (this.keySize < 0L) {
            Throwable throwable = null;
            Object var7_7 = null;
            try (RedisKeySizeStatement keyStatement = new RedisKeySizeStatement((RedisSession)session, this.getFullyQualifiedName(DBPEvaluationContext.DML), this.getKeyType(session.getProgressMonitor()));){
                keyStatement.executeStatement();
                this.keySize = keyStatement.getKeySize();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.keySize;
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.keyType = null;
        this.ttl = null;
        this.keySize = -1L;
        this.subKeys = null;
        return this;
    }
}

