/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ExasolCurrentUserPrivileges {
    private static final Log LOG = Log.getLog(ExasolCurrentUserPrivileges.class);
    private static final String C_QUERY_DICTIONARY = "SELECT CONNECTION_NAME FROM sys.EXA_DBA_CONNECTIONS WHERE false";
    private static final String C_MAJOR_VERSION = "select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMajorVersion'";
    private static final String C_MINOR_VERSION = "select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMinorVersion'";
    private final Boolean userHasDictionaryAccess;
    private final Integer majorVersion;
    private final Integer minorVersion;

    public ExasolCurrentUserPrivileges(DBRProgressMonitor monitor, JDBCSession session, ExasolDataSource exasolDataSource) {
        this.userHasDictionaryAccess = ExasolCurrentUserPrivileges.verifyPriv(C_QUERY_DICTIONARY, session);
        this.majorVersion = ExasolCurrentUserPrivileges.queryVersion(C_MAJOR_VERSION, session);
        this.minorVersion = ExasolCurrentUserPrivileges.queryVersion(C_MINOR_VERSION, session);
    }

    public int getExasolVersion() {
        return this.majorVersion;
    }

    public Boolean getatLeastV5() {
        if (this.majorVersion >= 5) {
            return true;
        }
        return false;
    }

    public Boolean getatLeastV6() {
        if (this.majorVersion >= 6) {
            return true;
        }
        return false;
    }

    public Boolean getUserHasDictionaryAccess() {
        return this.userHasDictionaryAccess;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public String getTablePrefix(ExasolSysTablePrefix fallback) {
        if (this.userHasDictionaryAccess.booleanValue()) {
            return ExasolSysTablePrefix.DBA.toString();
        }
        return fallback.toString();
    }

    /*
     * Exception decompiling
     */
    private static Integer queryVersion(String sql, JDBCSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Boolean verifyPriv(String sql, JDBCSession session) {
        Boolean hasPriv;
        try {
            Throwable throwable = null;
            Object var4_4 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                Throwable throwable2 = null;
                Object var7_8 = null;
                try {
                    JDBCResultSet rs = dbStat.executeQuery();
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            hasPriv = true;
        }
        catch (Exception exception) {
            hasPriv = false;
        }
        return hasPriv;
    }
}

