/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui;

import com.dbeaver.ee.runtime.core.DBeaverEnterpriseLM;
import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import com.dbeaver.lm.ui.LicenseImportDialog;
import com.dbeaver.lm.ui.LicenseInfoDialog;
import com.dbeaver.lm.ui.LicenseManagementDialog;
import com.dbeaver.lm.ui.LicenseMissingDialog;
import com.dbeaver.lm.ui.LicenseRenewsDialog;
import com.dbeaver.lm.ui.LicenseTrialDialog;
import com.dbeaver.lm.ui.LicenseUIUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMValidateException;

public class DBeaverEnterpriseUI {
    public static boolean checkLicense(Shell shell) {
        return DBeaverEnterpriseUI.checkLicense(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkLicense(Shell shell, LMLicenseManager lMLicenseManager, LMProduct lMProduct) {
        boolean bl = false;
        LMLicense lMLicense = null;
        while (true) {
            try {
                lMLicense = lMLicenseManager.getValidProductLicense(LicenseUIUtils.getClientId(), lMProduct);
                if (lMLicense != null) {
                    break;
                }
            }
            catch (LMValidateException lMValidateException) {}
            if (LMLicenseManager.getLicenseCustomPath() != null) {
                DBUserInterface.getInstance().showError(UiMessages.DBeaverEnterpriseUI_license_info_title, "No valid license found in " + LMLicenseManager.getLicenseCustomPath().getName());
                return false;
            }
            LicenseMissingDialog licenseMissingDialog = new LicenseMissingDialog(shell, lMLicenseManager, lMProduct);
            int n = licenseMissingDialog.open();
            try {
                switch (n) {
                    case 1: {
                        return false;
                    }
                    case 1000: {
                        if (!DBeaverEnterpriseUI.importLicense(shell)) break;
                        UIUtils.showMessageBox((Shell)shell, (String)UiMessages.DBeaverEnterpriseUI_license_accepted_title, (String)UiMessages.DBeaverEnterpriseUI_license_accepted_message, (int)2);
                        break;
                    }
                    case 1001: {
                        if (!DBeaverEnterpriseUI.createTrialLicense(shell)) break;
                        UIUtils.showMessageBox((Shell)shell, (String)UiMessages.DBeaverEnterpriseUI_trial_accepted_title, (String)UiMessages.DBeaverEnterpriseUI_trial_accepted_message, (int)2);
                        break;
                    }
                    case 1002: {
                        LicenseManagementDialog licenseManagementDialog = new LicenseManagementDialog(shell, lMLicenseManager, lMProduct);
                        licenseManagementDialog.open();
                    }
                }
            }
            catch (Throwable throwable) {
                DBUserInterface.getInstance().showError(UiMessages.DBeaverEnterpriseUI_e_lm_internal_title, UiMessages.DBeaverEnterpriseUI_e_lm_internal_message, throwable);
            }
            bl = true;
        }
        if (lMLicense == null) {
            return false;
        }
        if (bl) {
            DBeaverEnterpriseUI.showLicenseInfoDialog();
        }
        DBeaverEnterpriseUI.showLicenseExpireNotify(lMLicenseManager, lMProduct, lMLicense);
        return true;
    }

    private static boolean createTrialLicense(Shell shell) {
        LicenseTrialDialog licenseTrialDialog = new LicenseTrialDialog(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
        int n = licenseTrialDialog.open();
        return n == 0;
    }

    private static boolean importLicense(Shell shell) {
        LicenseImportDialog licenseImportDialog = new LicenseImportDialog(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
        int n = licenseImportDialog.open();
        return n == 0;
    }

    public static void showLicenseInfoDialog() {
        try {
            LicenseInfoDialog licenseInfoDialog = new LicenseInfoDialog(UIUtils.getActiveWorkbenchShell(), DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
            licenseInfoDialog.open();
        }
        catch (Exception exception) {
            DBeaverUI.getInstance().showError(UiMessages.DBeaverEnterpriseUI_license_info_title, UiMessages.DBeaverEnterpriseUI_license_info_message, (Throwable)exception);
        }
    }

    private static void showLicenseExpireNotify(LMLicenseManager lMLicenseManager, LMProduct lMProduct, LMLicense lMLicense) {
        LocalDateTime localDateTime;
        String string = String.valueOf(lMProduct.getId()) + "-" + GeneralUtils.getMajorVersion();
        if (LicenseRenewsDialog.isSuppressedFor((String)string)) {
            return;
        }
        LocalDateTime localDateTime2 = LocalDateTime.now();
        boolean bl = false;
        if (lMLicense.getLicenseEndTime() != null) {
            localDateTime = lMLicense.getLicenseEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (localDateTime.isBefore(localDateTime2)) {
                return;
            }
            long l = ChronoUnit.DAYS.between(localDateTime, localDateTime2);
            if (lMLicense.isSubscription()) {
                if (l == 1L) {
                    LicenseRenewsDialog licenseRenewsDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), "Extend your subscription", "Your subscription will expire after " + l + " day(s)." + ".\nWould you like to continue to use DBeaver?", string, lMLicense);
                    bl = licenseRenewsDialog.open() == 0;
                }
            } else if (l == 14L || l == 7L || l == 1L) {
                LicenseRenewsDialog licenseRenewsDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), "Extend your license", "Your license will expire at " + localDateTime.toLocalDate() + ".\nWould you like to continue to use DBeaver?", string, lMLicense);
                bl = licenseRenewsDialog.open() == 0;
            }
        } else {
            long l;
            localDateTime = lMLicense.getSupportEndDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (localDateTime.isBefore(localDateTime2) && ((l = ChronoUnit.DAYS.between(localDateTime, localDateTime2)) == 1L || l == 7L || l == 14L)) {
                LicenseRenewsDialog licenseRenewsDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), "Extend your license", "Free DBeaver version upgrade was ended at " + localDateTime.toLocalDate() + ".\n\nIt is just a reminder that you can renew your license with discount before " + localDateTime.plusMonths(1L).toLocalDate(), string, lMLicense);
                boolean bl2 = bl = licenseRenewsDialog.open() == 0;
            }
        }
        if (bl) {
            localDateTime = new LicenseManagementDialog(UIUtils.getActiveWorkbenchShell(), lMLicenseManager, lMProduct);
            localDateTime.open();
        }
    }
}

