/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.json;

import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.TextRenderer;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.json.JSONUtils;

public class JSONRenderer
extends TextRenderer {
    private Color colorDefault;
    private Color colorKey;
    private Color colorString;
    private Color colorValue;
    private DecimalFormat decimalFormat = new DecimalFormat("0");

    public JSONRenderer(IDocumentFrame iDocumentFrame) {
        super(iDocumentFrame);
        this.decimalFormat.setMaximumFractionDigits(340);
    }

    @Override
    public void paintDocument(@NotNull GC gC, @NotNull Canvas canvas, @NotNull Rectangle rectangle) {
        ColorRegistry colorRegistry = this.documentFrame.getController().getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorKey = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        this.colorString = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        this.colorValue = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.number.foreground");
        this.colorDefault = canvas.getForeground();
        super.paintDocument(gC, canvas, rectangle);
    }

    @Override
    protected void renderNode(TextRenderer.TextProcessor textProcessor, Object object, int n, int n2) {
        this.renderJsonNode(textProcessor, object, n, n2, 1, false, true);
    }

    private int renderJsonNode(TextRenderer.TextProcessor textProcessor, Object object, int n, int n2, int n3, boolean bl, boolean bl2) {
        String string;
        Color color;
        if (textProcessor.isOutOfRange(n2)) {
            return 0;
        }
        if (object instanceof Map || object instanceof Collection) {
            int n4;
            boolean bl3;
            boolean bl4 = this.isNodeCollapsed(object);
            if (n3 > 1 && !bl) {
                textProcessor.drawState(object, bl4 ? TextRenderer.NodeState.collapsed : TextRenderer.NodeState.expanded, (n3 - 1) * 4 - 2, n2);
            }
            textProcessor.drawText((bl3 = object instanceof Collection) ? "[" : "{", n, n2, this.colorDefault);
            int n5 = 0;
            if (bl4) {
                textProcessor.drawText("...", n + 2, n2, this.colorDefault);
                n4 = n + 4 + 6;
            } else {
                n4 = n3 * 4;
                if (bl3) {
                    Collection collection = (Collection)object;
                    n5 = collection.isEmpty() ? 0 : 1;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        int n6 = n2 + n5;
                        n5 += this.renderJsonNode(textProcessor, e, n4, n6, n3 + 1, true, !iterator.hasNext());
                    }
                } else {
                    Map map = (Map)object;
                    n5 = map.isEmpty() ? 0 : 1;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string2 = (String)entry.getKey();
                        int n7 = n2 + n5;
                        textProcessor.drawText(string2, n4, n7, this.colorKey);
                        textProcessor.drawText(":", n4 + string2.length(), n7, this.colorDefault);
                        n5 += this.renderJsonNode(textProcessor, entry.getValue(), n4 + string2.length() + 2, n7, n3 + 1, false, !iterator.hasNext());
                    }
                }
                if (n5 == 0) {
                    n4 = n + 4 + 1;
                }
            }
            textProcessor.drawText(String.valueOf(bl3 ? "]" : "}") + (bl2 ? "" : ","), n4 - 4, n2 + n5, this.colorDefault);
            return ++n5;
        }
        if (object == null || object instanceof Number || object instanceof Boolean) {
            color = this.colorValue;
            string = object instanceof Double || object instanceof Float ? this.decimalFormat.format(object) : String.valueOf(object);
        } else if (object instanceof Date) {
            string = JSONUtils.formatISODate((Date)((Date)object));
            color = this.colorValue;
        } else {
            string = "\"" + object + "\"";
            color = this.colorString;
        }
        return this.renderText(textProcessor, n, n2, string, color, bl2);
    }

    private int renderText(TextRenderer.TextProcessor textProcessor, int n, int n2, String string, Color color, boolean bl) {
        int n3 = string.indexOf(10);
        int n4 = 0;
        int n5 = 0;
        if (n3 == -1) {
            textProcessor.drawText(string, n, n2, color);
            n4 = 1;
            n5 = string.length();
        } else {
            int n6 = 0;
            do {
                textProcessor.drawText(string.substring(n6, n3), n, n2 + n4, color);
                ++n4;
            } while ((n3 = string.indexOf(10, n6 = n3 + 1)) >= 0);
            textProcessor.drawText(string.substring(n6, string.length()), n, n2 + n4, color);
            n5 = string.length() - n6;
            ++n4;
        }
        if (!bl) {
            textProcessor.drawText(",", n + n5, n2 + n4 - 1, this.colorDefault);
        }
        return n4;
    }
}

