/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.security.Key;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicenseFormat;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMProductRelease;
import org.jkiss.lm.LMSerializable;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.CommonUtils;

public class LMLicense
implements LMSerializable {
    private static final Logger log = Logger.getLogger("LMLicense");
    private static final long DAY_MS = 86400000L;
    public static final long FLAG_NONE = 0L;
    public static final long FLAG_TEST = 1L;
    public static final long FLAG_CANCELED = 2L;
    public static final long FLAG_RESELLER = 4L;
    public static final long FLAG_SUBSCRIPTION = 8L;
    public static final long FLAG_LIMITED = 16L;
    public static final long FLAG_LIMITED_VERSION = 32L;
    private byte[] encoded;
    private String licenseId;
    private LMLicenseType licenseType;
    private Date licenseIssueTime;
    private Date licenseStartTime;
    private Date licenseEndTime;
    private long flags;
    private String productId;
    private String productVersion;
    private String ownerId;
    private String ownerCompany;
    private String ownerName;
    private String ownerEmail;
    private byte yearsNumber;
    private byte reserved1;
    private short usersNumber;
    private LMLicenseFormat licenseFormat;

    public LMLicense(@NotNull byte[] encryptedData, @NotNull Key key) throws LMException {
        this.encoded = encryptedData;
        byte[] data = LMEncryption.decrypt(encryptedData, key);
        int offset = 0;
        this.licenseFormat = LMLicenseFormat.STANDARD;
        try {
            this.licenseFormat = LMLicenseFormat.valueOf(data[offset]);
        }
        catch (Exception e) {
            log.warning("Unsupported license format: " + data[offset]);
        }
        ++offset;
        if (data.length != this.licenseFormat.getEncryptedLength()) {
            throw new LMException("Bad " + this.licenseFormat + " license length (" + data.length + ")");
        }
        this.licenseId = new String(data, offset, 16).trim();
        this.licenseType = LMLicenseType.valueOf(data[offset += 16]);
        this.licenseIssueTime = LMUtils.getDateFromBytes(data, ++offset);
        this.licenseStartTime = LMUtils.getDateFromBytes(data, offset += 8);
        this.licenseEndTime = LMUtils.getDateFromBytes(data, offset += 8);
        this.flags = LMUtils.bytesToLong(data, offset += 8);
        this.productId = new String(data, offset += 8, 16).trim();
        this.productVersion = new String(data, offset += 16, 8).trim();
        this.ownerId = new String(data, offset += 8, 16).trim();
        this.ownerCompany = new String(data, offset += 16, 64).trim();
        offset += 64;
        if (this.licenseFormat == LMLicenseFormat.STANDARD) {
            this.ownerName = new String(data, offset, 64).trim();
            offset += 64;
        } else {
            this.ownerName = new String(data, offset, 32).trim();
            this.ownerEmail = new String(data, offset += 32, 48).trim();
            offset += 48;
            this.yearsNumber = data[offset++];
            if (this.yearsNumber <= 0) {
                this.yearsNumber = 1;
            }
            this.reserved1 = data[offset++];
            this.usersNumber = LMUtils.bytesToShort(data, offset);
            if (this.usersNumber <= 0) {
                this.usersNumber = 1;
            }
            offset += 2;
        }
    }

    public LMLicense(@NotNull String licenseId, @NotNull LMLicenseType licenseType, Date licenseIssueTime, Date licenseStartTime, Date licenseEndTime, long flags, String productId, String productVersion, String ownerId, String ownerCompany, String ownerName, String ownerEmail) {
        this.licenseFormat = LMLicenseFormat.EXTENDED;
        this.licenseId = licenseId;
        this.licenseType = licenseType;
        this.licenseIssueTime = licenseIssueTime;
        this.licenseStartTime = licenseStartTime;
        this.licenseEndTime = licenseEndTime;
        this.flags = flags;
        this.productId = productId;
        this.productVersion = productVersion;
        this.ownerId = ownerId;
        this.ownerCompany = ownerCompany;
        this.ownerName = ownerName;
        this.ownerEmail = ownerEmail;
        this.yearsNumber = 1;
        this.reserved1 = 0;
        this.usersNumber = 1;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    @Override
    @NotNull
    public LMLicenseFormat getFormat() {
        return this.licenseFormat;
    }

    public void setLicenseFormat(LMLicenseFormat licenseFormat) {
        this.licenseFormat = licenseFormat;
    }

    @NotNull
    public String getLicenseId() {
        return this.licenseId;
    }

    @NotNull
    public LMLicenseType getLicenseType() {
        return this.licenseType;
    }

    @NotNull
    public Date getLicenseIssueTime() {
        return this.licenseIssueTime;
    }

    @NotNull
    public Date getLicenseStartTime() {
        return this.licenseStartTime;
    }

    @Nullable
    public Date getLicenseEndTime() {
        if (this.licenseEndTime == null && this.licenseType == LMLicenseType.ACADEMIC) {
            return new Date(this.licenseStartTime.getTime() + 31536000000L);
        }
        return this.licenseEndTime;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    @NotNull
    public String getProductId() {
        return this.productId;
    }

    @NotNull
    public String getProductVersion() {
        return this.productVersion;
    }

    @NotNull
    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @NotNull
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public byte getYearsNumber() {
        return this.yearsNumber;
    }

    public void setYearsNumber(byte yearsNumber) {
        this.yearsNumber = yearsNumber;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public short getUsersNumber() {
        return this.usersNumber;
    }

    public void setUsersNumber(short usersNumber) {
        this.usersNumber = usersNumber;
    }

    public String getOwnerFull() {
        String licensedTo = this.ownerName;
        if (!CommonUtils.isEmpty((String)this.ownerCompany)) {
            licensedTo = String.valueOf(this.ownerCompany) + " / " + licensedTo;
        }
        return licensedTo;
    }

    @Override
    @NotNull
    public byte[] getData() {
        byte[] data = new byte[this.licenseFormat.getEncryptedLength()];
        int offset = 0;
        data[offset] = this.licenseFormat.getId();
        LMUtils.copyStringBytes(data, ++offset, this.licenseId, 16);
        offset += 16;
        data[offset++] = this.licenseType.getId();
        LMUtils.copyDateBytes(data, offset, this.licenseIssueTime);
        LMUtils.copyDateBytes(data, offset += 8, this.licenseStartTime);
        LMUtils.copyDateBytes(data, offset += 8, this.licenseEndTime);
        System.arraycopy(LMUtils.longToBytes(this.flags), 0, data, offset += 8, 8);
        LMUtils.copyStringBytes(data, offset += 8, this.productId, 16);
        LMUtils.copyStringBytes(data, offset += 16, this.productVersion, 8);
        LMUtils.copyStringBytes(data, offset += 8, this.ownerId, 16);
        LMUtils.copyStringBytes(data, offset += 16, this.ownerCompany, 64);
        offset += 64;
        switch (this.licenseFormat) {
            case STANDARD: {
                LMUtils.copyStringBytes(data, offset, this.ownerName, 64);
                offset += 64;
                break;
            }
            case EXTENDED: {
                LMUtils.copyStringBytes(data, offset, this.ownerName, 32);
                LMUtils.copyStringBytes(data, offset += 32, this.ownerEmail, 48);
                offset += 48;
                data[offset++] = this.yearsNumber;
                data[offset++] = this.reserved1;
                System.arraycopy(LMUtils.shortToBytes(this.usersNumber), 0, data, offset, 2);
                offset += 2;
                break;
            }
        }
        return data;
    }

    public String toString() {
        return "licenseId=" + this.licenseId + "\nlicenseType=" + (Object)((Object)this.licenseType) + "\nlicenseIssueTime=" + this.licenseIssueTime + "\nlicenseStartTime=" + this.licenseStartTime + "\nlicenseEndTime=" + this.licenseEndTime + "\nflags=" + this.flags + "\nproductId=" + this.productId + "\nproductVersion=" + this.productVersion + "\nownerId=" + this.ownerId + "\nownerCompany=" + this.ownerCompany + "\nownerName=" + this.ownerName + "\nownerEmail=" + this.ownerEmail + "\nyearsNumber=" + this.yearsNumber + "\nusersNumber=" + this.usersNumber;
    }

    public boolean isSubscription() {
        return (this.flags & 8L) == 8L;
    }

    public boolean isValidFor(LMProduct product, LMProductRelease productRelease, boolean checkExpired) {
        Date licenseEndTime;
        if (!this.productId.equals(product.getId())) {
            return false;
        }
        if (this.isSubscription()) {
            return true;
        }
        if ((this.flags & 0x20L) == 32L && !CommonUtils.equalObjects((Object)this.getProductVersion(), (Object)product.getVersion())) {
            return false;
        }
        if (this.getLicenseType() == LMLicenseType.ULTIMATE) {
            return true;
        }
        if (checkExpired) {
            Date curDate = new Date();
            licenseEndTime = this.getLicenseEndTime();
            switch (this.getLicenseType()) {
                case TRIAL: 
                case ACADEMIC: {
                    if (licenseEndTime != null) break;
                    licenseEndTime = new Date(this.licenseStartTime.getTime() + 31536000000L);
                }
            }
            if (licenseEndTime != null && licenseEndTime.compareTo(curDate) < 0) {
                return false;
            }
        }
        Date releaseDate = productRelease == null ? product.getReleaseDate() : productRelease.getReleaseDate();
        licenseEndTime = this.getSupportEndDate();
        return licenseEndTime.compareTo(releaseDate) >= 0;
    }

    @NotNull
    public Date getSupportEndDate() {
        if (this.licenseEndTime != null) {
            return this.licenseEndTime;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.getLicenseIssueTime());
        byte yearsNumber = this.getYearsNumber();
        if (yearsNumber <= 0) {
            yearsNumber = 1;
        }
        cl.add(1, yearsNumber);
        return cl.getTime();
    }

    public String getLicenseTypeFull() {
        if (this.isSubscription()) {
            return "Subscription";
        }
        return this.licenseType.getDisplayName();
    }
}

