/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetColumn;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferSession;

public class StreamTransferResultSet
implements DBCResultSet {
    private final StreamTransferSession session;
    private final DBCStatement statement;
    private StreamProducerSettings.EntityMapping entityMapping;
    private List<DBCAttributeMetaData> metaAttrs;
    private Object[] streamRow;
    private final List<StreamProducerSettings.AttributeMapping> attributeMappings;
    private final int[] targetToSourceMap;

    public StreamTransferResultSet(StreamTransferSession session, DBCStatement statement, StreamProducerSettings.EntityMapping entityMapping) {
        this.session = session;
        this.statement = statement;
        this.entityMapping = entityMapping;
        this.attributeMappings = this.entityMapping.getAttributeMappings();
        this.metaAttrs = new ArrayList<DBCAttributeMetaData>(this.attributeMappings.size());
        this.targetToSourceMap = new int[this.entityMapping.getValuableAttributeMappings().size()];
        int mapIndex = 0;
        int i = 0;
        while (i < this.attributeMappings.size()) {
            StreamProducerSettings.AttributeMapping attr = this.attributeMappings.get(i);
            if (attr.isValuable()) {
                this.metaAttrs.add((DBCAttributeMetaData)new LocalResultSetColumn((DBCResultSet)this, i, attr.getTargetAttributeName(), DBPDataKind.STRING));
                this.targetToSourceMap[mapIndex++] = i;
            }
            ++i;
        }
    }

    public void setStreamRow(Object[] streamRow) {
        this.streamRow = streamRow;
    }

    public DBCSession getSession() {
        return this.session;
    }

    public DBCStatement getSourceStatement() {
        return this.statement;
    }

    public Object getAttributeValue(int index) throws DBCException {
        int sourceIndex = this.targetToSourceMap[index];
        StreamProducerSettings.AttributeMapping attr = this.attributeMappings.get(sourceIndex);
        if (attr.getMappingType() == StreamProducerSettings.AttributeMapping.MappingType.DEFAULT_VALUE) {
            return attr.getDefaultValue();
        }
        return this.streamRow[attr.getSourceAttributeIndex()];
    }

    public Object getAttributeValue(String name) throws DBCException {
        return null;
    }

    public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    public boolean nextRow() throws DBCException {
        return false;
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    public DBCResultSetMetaData getMeta() throws DBCException {
        return new LocalResultSetMeta(this.metaAttrs);
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public void close() {
    }
}

