/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database.page;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBWorkbench;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseProducerPageInputObjects
extends ActiveWizardPage<DataTransferWizard> {
    private Table mappingTable;
    private DBNDatabaseNode lastSelection;

    public DatabaseProducerPageInputObjects() {
        super("Input objects");
        this.setTitle("Select input objects");
        this.setDescription("Choose database objects to import");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        Group tablesGroup = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.data_transfer_wizard_mappings_name, (int)3, (int)1808, (int)0);
        this.mappingTable = new Table((Composite)tablesGroup, 67588);
        this.mappingTable.setLayoutData((Object)new GridData(1808));
        this.mappingTable.setHeaderVisible(true);
        this.mappingTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.mappingTable, (int)16384, (String)DTMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.mappingTable, (int)16384, (String)DTMessages.data_transfer_wizard_final_column_target);
        for (DataTransferPipe pipe : settings.getDataPipes()) {
            TableItem item = new TableItem(this.mappingTable, 0);
            item.setData((Object)pipe);
            this.updateItemData(item, pipe);
        }
        this.mappingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseProducerPageInputObjects.this.mappingTable.getSelectionIndex() < 0) {
                    return;
                }
                TableItem item = DatabaseProducerPageInputObjects.this.mappingTable.getItem(DatabaseProducerPageInputObjects.this.mappingTable.getSelectionIndex());
                DataTransferPipe pipe = (DataTransferPipe)item.getData();
                if (DatabaseProducerPageInputObjects.this.chooseEntity(pipe)) {
                    DatabaseProducerPageInputObjects.this.updateItemData(item, pipe);
                    DatabaseProducerPageInputObjects.this.updatePageCompletion();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.mappingTable, (boolean)true));
        this.setControl((Control)composite);
    }

    private void updateItemData(TableItem item, DataTransferPipe pipe) {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        if (pipe.getProducer() == null || pipe.getProducer().getDatabaseObject() == null) {
            item.setImage(0, null);
            item.setText(0, "<none>");
        } else {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)settings.getProducer().getIcon()));
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)pipe.getProducer().getDatabaseObject(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        }
        if (pipe.getConsumer() == null || pipe.getConsumer().getObjectName() == null) {
            item.setImage(1, null);
            item.setText(1, "<none>");
        } else {
            item.setImage(1, DBeaverIcons.getImage((DBPImage)settings.getConsumer().getIcon()));
            item.setText(1, pipe.getConsumer().getObjectName());
        }
    }

    public void activatePage() {
        DatabaseProducerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        this.updatePageCompletion();
    }

    protected boolean determinePageCompletion() {
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            if (pipe.getConsumer() != null && pipe.getProducer() != null && pipe.getProducer().getDatabaseObject() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean chooseEntity(DataTransferPipe pipe) {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        DBNRoot rootNode = DBWorkbench.getPlatform().getLiveProjects().size() == 1 ? navigatorModel.getRoot().getProject(DBWorkbench.getPlatform().getProjectManager().getActiveProject()) : navigatorModel.getRoot();
        boolean chooseConsumer = settings.isConsumerOptional();
        DBNNode node = DBUserInterface.getInstance().selectObject((Object)UIUtils.getActiveWorkbenchShell(), chooseConsumer ? "Select target entity for '" + pipe.getProducer().getDatabaseObject().getName() + "'" : "Select source container for '" + pipe.getConsumer().getObjectName() + "'", (DBNNode)rootNode, (DBNNode)this.lastSelection, new Class[]{DBSObjectContainer.class, DBSDataContainer.class}, new Class[]{chooseConsumer ? DBSDataManipulator.class : DBSDataContainer.class}, null);
        if (node instanceof DBNDatabaseNode) {
            this.lastSelection = (DBNDatabaseNode)node;
            DBSObject object = ((DBNDatabaseNode)node).getObject();
            if (chooseConsumer) {
                if (object instanceof DBSDataManipulator) {
                    pipe.setConsumer(new DatabaseTransferConsumer((DBSDataManipulator)object));
                }
            } else if (object instanceof DBSDataContainer) {
                pipe.setProducer(new DatabaseTransferProducer((DBSDataContainer)object));
            }
            return true;
        }
        return false;
    }
}

