/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.utils.CommonUtils;

public class DatabaseMappingContainer
implements DatabaseMappingObject {
    private DatabaseConsumerSettings settings;
    private DBSDataContainer source;
    private DBSDataManipulator target;
    private String targetName;
    private DatabaseMappingType mappingType;
    private List<DatabaseMappingAttribute> attributeMappings = new ArrayList<DatabaseMappingAttribute>();

    public DatabaseMappingContainer(DatabaseConsumerSettings settings, DBSDataContainer source) {
        this.settings = settings;
        this.source = source;
        this.mappingType = DatabaseMappingType.unspecified;
    }

    public DatabaseMappingContainer(IRunnableContext context, DatabaseConsumerSettings settings, DBSDataContainer sourceObject, DBSDataManipulator targetObject) throws DBException {
        this.settings = settings;
        this.source = sourceObject;
        this.target = targetObject;
        this.refreshMappingType(context, DatabaseMappingType.existing);
    }

    public DatabaseConsumerSettings getSettings() {
        return this.settings;
    }

    public DBSDataManipulator getTarget() {
        return this.target;
    }

    public void setTarget(DBSDataManipulator target) {
        this.target = target;
    }

    @Override
    public DatabaseMappingType getMappingType() {
        return this.mappingType;
    }

    public void refreshMappingType(IRunnableContext context, DatabaseMappingType mappingType) throws DBException {
        this.mappingType = mappingType;
        Collection<DatabaseMappingAttribute> mappings = this.getAttributeMappings(context);
        if (!CommonUtils.isEmpty(mappings)) {
            for (DatabaseMappingAttribute attr : mappings) {
                attr.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor());
            }
        }
    }

    void setMappingType(DatabaseMappingType mappingType) {
        this.mappingType = mappingType;
    }

    public boolean isCompleted() {
        if (this.mappingType == DatabaseMappingType.skip) {
            return true;
        }
        for (DatabaseMappingAttribute attr : this.attributeMappings) {
            if (attr.getMappingType() != DatabaseMappingType.unspecified) continue;
            return false;
        }
        return true;
    }

    @Override
    public DBPImage getIcon() {
        return DBIcon.TREE_TABLE;
    }

    public DBSDataContainer getSource() {
        return this.source;
    }

    @Override
    public String getTargetName() {
        switch (this.mappingType) {
            case existing: {
                return this.target.getName();
            }
            case create: {
                return this.targetName;
            }
            case skip: {
                return "[skip]";
            }
        }
        return "?";
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public DatabaseMappingAttribute getAttributeMapping(DBSAttributeBase sourceAttr) {
        for (DatabaseMappingAttribute attr : this.attributeMappings) {
            if (!attr.getSource().getName().equalsIgnoreCase(sourceAttr.getName())) continue;
            return attr;
        }
        return null;
    }

    public Collection<DatabaseMappingAttribute> getAttributeMappings(IRunnableContext runnableContext) {
        if (this.attributeMappings.isEmpty()) {
            try {
                this.readAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Attributes read failed", "Can't get attributes from " + DBUtils.getObjectFullName((DBPNamedObject)this.source, (DBPEvaluationContext)DBPEvaluationContext.UI), (Throwable)e);
            }
        }
        return this.attributeMappings;
    }

    public Collection<DatabaseMappingAttribute> getAttributeMappings(DBRProgressMonitor monitor) {
        if (this.attributeMappings.isEmpty()) {
            try {
                this.readAttributes(monitor);
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Attributes read failed", "Can't get attributes from " + DBUtils.getObjectFullName((DBPNamedObject)this.source, (DBPEvaluationContext)DBPEvaluationContext.UI), (Throwable)e);
            }
        }
        return this.attributeMappings;
    }

    private void readAttributes(DBRProgressMonitor monitor) throws DBException {
        if (this.source instanceof DBSEntity) {
            for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)((DBSEntity)this.source).getAttributes(monitor))) {
                if (DBUtils.isHiddenObject((Object)attr)) continue;
                this.addAttributeMapping(monitor, (DBSAttributeBase)attr);
            }
        } else {
            DBPDataSource dataSource = this.source.getDataSource();
            assert (dataSource != null);
            Throwable throwable = null;
            Object var4_7 = null;
            try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this.source, (String)"Read query meta data");){
                MetadataReceiver receiver = new MetadataReceiver();
                this.source.readData((DBCExecutionSource)new AbstractExecutionSource(this.source, session.getExecutionContext(), (Object)this), session, (DBDDataReceiver)receiver, null, 0L, 1L, 0L);
                for (DBCAttributeMetaData attr : receiver.attributes) {
                    if (DBUtils.isHiddenObject((Object)attr)) continue;
                    this.addAttributeMapping(monitor, (DBSAttributeBase)attr);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void addAttributeMapping(DBRProgressMonitor monitor, DBSAttributeBase attr) throws DBException {
        DatabaseMappingAttribute mapping = new DatabaseMappingAttribute(this, attr);
        mapping.updateMappingType(monitor);
        this.attributeMappings.add(mapping);
    }

    private static class MetadataReceiver
    implements DBDDataReceiver {
        private List<DBCAttributeMetaData> attributes;

        private MetadataReceiver() {
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.attributes = resultSet.getMeta().getAttributes();
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void close() {
        }
    }
}

