/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringConverter {
    public static final String COLUMN_NAME = "@STRINGCONVERTER";
    private String dateFormat;
    private SimpleDateFormat simpleTimeFormat;
    private String timeFormat;
    private GregorianCalendar calendar;
    private Pattern timestampPattern;
    private SimpleDateFormat timestampFormat;
    private SimpleDateFormat simpleDateFormat;
    private int currentYear;
    private static Map<String, Class<?>> forSQLNameMap = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = -3037117163532338893L;
        {
            this.put("string", String.class);
            this.put("boolean", Boolean.class);
            this.put("byte", Byte.class);
            this.put("short", Short.class);
            this.put("int", Integer.class);
            this.put("integer", Integer.class);
            this.put("long", Long.class);
            this.put("float", Float.class);
            this.put("double", Double.class);
            this.put("bigdecimal", BigDecimal.class);
            this.put("date", Date.class);
            this.put("time", Time.class);
            this.put("timestamp", Timestamp.class);
            this.put("asciistream", InputStream.class);
        }
    };

    public StringConverter(String dateformat, String timeformat, String timestampformat, String timeZoneName) {
        this.init(dateformat, timeformat, timestampformat, timeZoneName, null);
    }

    public StringConverter(String dateformat, String timeformat, String timestampformat, String timeZoneName, Locale locale) {
        this.init(dateformat, timeformat, timestampformat, timeZoneName, locale);
    }

    private void init(String dateformat, String timeformat, String timestampformat, String timeZoneName, Locale locale) {
        this.dateFormat = dateformat;
        if (dateformat != null) {
            String upper = dateformat.toUpperCase(Locale.US);
            boolean useSimpleDateFormat = false;
            if (upper.contains("MMM")) {
                useSimpleDateFormat = true;
            } else {
                for (int i = 0; i < upper.length(); ++i) {
                    char c = upper.charAt(i);
                    if (!Character.isLetter(c) || c == 'D' || c == 'M' || c == 'Y') continue;
                    useSimpleDateFormat = true;
                }
            }
            if (useSimpleDateFormat) {
                if (locale != null) {
                    DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
                    this.simpleDateFormat = new SimpleDateFormat(dateformat, symbols);
                } else {
                    this.simpleDateFormat = new SimpleDateFormat(dateformat);
                }
            }
        }
        this.timeFormat = timeformat;
        if (locale != null) {
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
            this.simpleTimeFormat = new SimpleDateFormat(timeformat, symbols);
        } else {
            this.simpleTimeFormat = new SimpleDateFormat(timeformat);
        }
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneName);
        this.calendar = new GregorianCalendar();
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.currentYear = this.calendar.get(1);
        this.calendar.clear();
        this.calendar.setTimeZone(timeZone);
        if (timestampformat != null && timestampformat.length() > 0) {
            if (locale != null) {
                DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
                this.timestampFormat = new SimpleDateFormat(timestampformat, symbols);
            } else {
                this.timestampFormat = new SimpleDateFormat(timestampformat);
            }
            this.timestampFormat.setTimeZone(timeZone);
        } else {
            this.timestampPattern = Pattern.compile("([0-9][0-9][0-9][0-9])-([0-9]?[0-9])-([0-9]?[0-9])[ T]([0-9]?[0-9]):([0-9]?[0-9]):([0-9]?[0-9]).*");
        }
    }

    public String parseString(String str) {
        return str;
    }

    public Boolean parseBoolean(String str) {
        boolean retval = str != null && str.equals("1") ? true : (str != null && str.equals("0") ? false : Boolean.valueOf(str));
        return retval;
    }

    public Byte parseByte(String str) {
        try {
            Byte b = str == null || str.length() == 0 ? null : Byte.valueOf(Byte.parseByte(str));
            return b;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Short parseShort(String str) {
        try {
            Short s = str == null || str.length() == 0 ? null : Short.valueOf(Short.parseShort(str));
            return s;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer parseInt(String str) {
        try {
            Integer i = str == null || str.length() == 0 ? null : Integer.valueOf(Integer.parseInt(str));
            return i;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long parseLong(String str) {
        try {
            Long l = str == null || str.length() == 0 ? null : Long.valueOf(Long.parseLong(str));
            return l;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Float parseFloat(String str) {
        try {
            Float f;
            if (str == null || str.length() == 0) {
                f = null;
            } else {
                str = str.replace(",", ".");
                f = Float.valueOf(Float.parseFloat(str));
            }
            return f;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Double parseDouble(String str) {
        try {
            Double d;
            if (str == null || str.length() == 0) {
                d = null;
            } else {
                str = str.replace(",", ".");
                d = Double.parseDouble(str);
            }
            return d;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public byte[] parseBytes(String str) {
        try {
            byte[] b = str == null ? null : str.getBytes();
            return b;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public BigDecimal parseBigDecimal(String str) {
        try {
            BigDecimal bd = str == null || str.length() == 0 ? null : new BigDecimal(str);
            return bd;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String makeISODate(String date, String format) {
        Pattern pattern;
        format = format.toLowerCase(Locale.US);
        int dpos = format.indexOf(100);
        int mpos = format.indexOf(109);
        int ypos = format.indexOf(121);
        int ylen = 4;
        int day = 1;
        int month = 1;
        int year = 1;
        if (dpos > mpos) {
            ++day;
        } else {
            ++month;
        }
        if (dpos > ypos) {
            ++day;
        } else {
            ++year;
        }
        if (mpos > ypos) {
            ++month;
        } else {
            ++year;
        }
        Pattern part = Pattern.compile("d+");
        Matcher m = part.matcher(format);
        if (m.find()) {
            format = format.replace(m.group(), "([0-9]{" + (m.end() - m.start()) + ",2})");
        }
        if ((m = (part = Pattern.compile("m+")).matcher(format)).find()) {
            format = format.replace(m.group(), "([0-9]{" + (m.end() - m.start()) + ",2})");
        }
        if ((m = (part = Pattern.compile("y+")).matcher(format)).find()) {
            ylen = m.end() - m.start();
            format = format.replace(m.group(), "([0-9]{" + (m.end() - m.start()) + ",4})");
        }
        if ((m = (pattern = Pattern.compile(format = format + ".*")).matcher(date)).matches()) {
            String dayGroup;
            String monthGroup;
            String yearGroup = m.group(year);
            if (yearGroup.length() == 2 && ylen == 2) {
                int century = this.currentYear / 100;
                int proposedYear = century * 100 + Integer.parseInt(yearGroup);
                if (proposedYear - this.currentYear > 20) {
                    proposedYear -= 100;
                }
                if (this.currentYear - proposedYear > 80) {
                    proposedYear += 100;
                }
                yearGroup = String.format("%04d", proposedYear);
            }
            if ((monthGroup = m.group(month)).length() < 2) {
                monthGroup = "0" + monthGroup;
            }
            if ((dayGroup = m.group(day)).length() < 2) {
                dayGroup = "0" + dayGroup;
            }
            String retval = yearGroup + "-" + monthGroup + "-" + dayGroup;
            return retval;
        }
        return null;
    }

    public Date parseDate(String str) {
        try {
            Date sqlResult = null;
            if (str != null && str.length() > 0) {
                if (this.simpleDateFormat != null) {
                    java.util.Date parsedDate = this.simpleDateFormat.parse(str);
                    long millis = parsedDate.getTime();
                    sqlResult = new Date(millis);
                    return sqlResult;
                }
                String isoDate = this.makeISODate(str, this.dateFormat);
                if (isoDate != null) {
                    sqlResult = Date.valueOf(isoDate);
                }
            }
            return sqlResult;
        }
        catch (ParseException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String formatDate(Date d) {
        String formatted = null;
        if (d != null) {
            if (this.simpleDateFormat != null) {
                formatted = this.simpleDateFormat.format(d);
            } else {
                int patternLength;
                formatted = this.dateFormat.toLowerCase(Locale.US);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(d);
                Pattern part = Pattern.compile("d+");
                Matcher m = part.matcher(formatted);
                if (m.find()) {
                    patternLength = m.end() - m.start();
                    String dayOfMonth = Integer.toString(gregorianCalendar.get(5));
                    while (dayOfMonth.length() < patternLength) {
                        dayOfMonth = "0" + dayOfMonth;
                    }
                    formatted = formatted.replace(m.group(), dayOfMonth);
                }
                if ((m = (part = Pattern.compile("m+")).matcher(formatted)).find()) {
                    patternLength = m.end() - m.start();
                    String month = Integer.toString(gregorianCalendar.get(2) + 1);
                    while (month.length() < patternLength) {
                        month = "0" + month;
                    }
                    formatted = formatted.replace(m.group(), month);
                }
                if ((m = (part = Pattern.compile("y+")).matcher(formatted)).find()) {
                    patternLength = m.end() - m.start();
                    int fullYear = gregorianCalendar.get(1);
                    if (patternLength == 2) {
                        fullYear %= 100;
                    }
                    String year = Integer.toString(fullYear);
                    while (year.length() < patternLength) {
                        year = "0" + year;
                    }
                    formatted = formatted.replace(m.group(), year);
                }
            }
        }
        return formatted;
    }

    public Time parseTime(String str) {
        try {
            Time sqlResult = null;
            if (str != null && str.length() > 0) {
                str = str.trim();
                while (str.length() < this.timeFormat.length()) {
                    str = "0" + str;
                }
                java.util.Date parsedDate = this.simpleTimeFormat.parse(str);
                long millis = parsedDate.getTime();
                sqlResult = new Time(millis);
            }
            return sqlResult;
        }
        catch (ParseException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String formatTime(Time t) {
        String formatted = null;
        if (t != null) {
            formatted = this.simpleTimeFormat.format(t);
        }
        return formatted;
    }

    public Timestamp parseTimestamp(String str) {
        Timestamp result = null;
        try {
            if (str != null && str.length() > 0) {
                if (this.timestampFormat != null) {
                    java.util.Date date = this.timestampFormat.parse(str);
                    result = new Timestamp(date.getTime());
                } else {
                    Matcher matcher = this.timestampPattern.matcher(str);
                    if (matcher.matches()) {
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2)) - 1;
                        int date = Integer.parseInt(matcher.group(3));
                        int hours = Integer.parseInt(matcher.group(4));
                        int minutes = Integer.parseInt(matcher.group(5));
                        int seconds = Integer.parseInt(matcher.group(6));
                        this.calendar.set(year, month, date, hours, minutes, seconds);
                        result = new Timestamp(this.calendar.getTimeInMillis());
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public String formatTimestamp(Timestamp timestamp) {
        String formatted = null;
        if (timestamp != null) {
            if (this.timestampFormat != null) {
                formatted = this.timestampFormat.format(timestamp);
            } else {
                this.calendar.setTime(timestamp);
                int year = this.calendar.get(1);
                int month = this.calendar.get(2) + 1;
                int dayOfMonth = this.calendar.get(5);
                int hourOfDay = this.calendar.get(11);
                int minutes = this.calendar.get(12);
                int seconds = this.calendar.get(13);
                formatted = String.format("%04d-%02d-%02d %02d:%02d:%02d", year, month, dayOfMonth, hourOfDay, minutes, seconds);
            }
        }
        return formatted;
    }

    public InputStream parseAsciiStream(String str) {
        return str == null ? null : new ByteArrayInputStream(str.getBytes());
    }

    public Object convert(String sqlTypeName, String stringRepresentation) {
        if (sqlTypeName == null) {
            return stringRepresentation;
        }
        if (sqlTypeName.equalsIgnoreCase("string")) {
            return stringRepresentation;
        }
        if (sqlTypeName.equalsIgnoreCase("boolean")) {
            return this.parseBoolean(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("byte")) {
            return this.parseByte(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("short")) {
            return this.parseShort(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("int") || sqlTypeName.equalsIgnoreCase("integer")) {
            return this.parseInt(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("long")) {
            return this.parseLong(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("float")) {
            return this.parseFloat(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("double")) {
            return this.parseDouble(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("bigdecimal")) {
            return this.parseBigDecimal(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("date")) {
            return this.parseDate(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("time")) {
            return this.parseTime(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("timestamp")) {
            return this.parseTimestamp(stringRepresentation);
        }
        if (sqlTypeName.equalsIgnoreCase("asciistream")) {
            return this.parseAsciiStream(stringRepresentation);
        }
        return stringRepresentation;
    }

    public Class<?> forSQLName(String sqlTypeName) {
        sqlTypeName = sqlTypeName.toLowerCase(Locale.US);
        return forSQLNameMap.get(sqlTypeName);
    }

    public static Object getLiteralForTypeName(String sqlTypeName) {
        Object retval = null;
        if ((sqlTypeName = sqlTypeName.toLowerCase(Locale.US)).equals("string")) {
            retval = "";
        } else if (sqlTypeName.equals("boolean")) {
            retval = Boolean.FALSE;
        } else if (sqlTypeName.equals("byte")) {
            retval = (byte)1;
        } else if (sqlTypeName.equals("short")) {
            retval = (short)1;
        } else if (sqlTypeName.equals("int") || sqlTypeName.equals("integer")) {
            retval = 1;
        } else if (sqlTypeName.equals("long")) {
            retval = 1L;
        } else if (sqlTypeName.equals("float")) {
            retval = Float.valueOf(1.0f);
        } else if (sqlTypeName.equals("double")) {
            retval = 1.0;
        } else if (sqlTypeName.equals("bigdecimal")) {
            retval = BigDecimal.valueOf(1L);
        } else if (sqlTypeName.equals("date")) {
            retval = Date.valueOf("1970-01-01");
        } else if (sqlTypeName.equals("time")) {
            retval = Time.valueOf("00:00:00");
        } else if (sqlTypeName.equals("timestamp")) {
            retval = Timestamp.valueOf("1970-01-01 00:00:00");
        } else if (sqlTypeName.equals("asciistream")) {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public static String getTypeNameForLiteral(Object literal) {
        String retval = null;
        if (literal instanceof String) {
            retval = "String";
        } else if (literal instanceof Boolean) {
            retval = "Boolean";
        } else if (literal instanceof Byte) {
            retval = "Byte";
        } else if (literal instanceof Short) {
            retval = "Short";
        } else if (literal instanceof Integer) {
            retval = "Int";
        } else if (literal instanceof Long) {
            retval = "Long";
        } else if (literal instanceof Float) {
            retval = "Float";
        } else if (literal instanceof Double) {
            retval = "Double";
        } else if (literal instanceof BigDecimal) {
            retval = "BigDecimal";
        } else if (literal instanceof Date) {
            retval = "Date";
        } else if (literal instanceof Time) {
            retval = "Time";
        } else if (literal instanceof Timestamp) {
            retval = "Timestamp";
        } else if (literal instanceof InputStream) {
            retval = "AsciiStream";
        }
        return retval;
    }

    public static List<Object[]> getTypeInfo() {
        Integer intZero = 0;
        Short shortZero = 0;
        Short shortMax = Short.MAX_VALUE;
        Short searchable = 3;
        Short nullable = 1;
        ArrayList<Object[]> retval = new ArrayList<Object[]>();
        retval.add(new Object[]{"String", 12, shortMax, "'", "'", null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Boolean", 16, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Byte", -6, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Short", 5, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Integer", 4, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Long", -5, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Float", 6, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Double", 8, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"BigDecimal", 3, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Date", 91, shortMax, "'", "'", null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Time", 92, shortMax, "'", "'", null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Timestamp", 93, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        retval.add(new Object[]{"Asciistream", 2005, shortMax, null, null, null, nullable, Boolean.TRUE, searchable, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, shortZero, shortMax, intZero, intZero, intZero});
        return retval;
    }

    public static String removeQuotes(String string) {
        return string.replace("\"", "");
    }
}

