/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MGCollection;
import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.utils.CommonUtils;

public class MongoCustomStatement
extends MongoBaseStatement {
    private SQLQueryType queryType = SQLQueryType.UNKNOWN;
    private DBObject expression;
    private DBObject values;
    private DBObject order;
    private DBObject groupBy;
    private boolean count;
    private Statement ddlStatement;
    private String collectionName;

    public MongoCustomStatement(MongoSession session, String query) {
        super(session, query);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            this.makeQueryFromString(this.getQueryString());
            if (this.queryType == SQLQueryType.DDL) {
                boolean bl = this.processDDL();
                return bl;
            }
            if (this.collection == null) {
                throw new DBCException("Can't evaluate Mongo collection from query");
            }
            DBCollection dbCollection = this.collection.getCollection();
            switch (this.queryType) {
                case SELECT: {
                    if (this.count) {
                        long countValue = dbCollection.count(this.expression);
                        this.resultList = new ArrayList(1);
                        this.resultList.add(new BasicDBObject("count", (Object)countValue));
                        return true;
                    }
                    this.result = dbCollection.find(this.expression, this.values);
                    if (this.order == null) return true;
                    this.result.sort(this.order);
                    return true;
                }
                case UPDATE: {
                    this.setExecutionResult(dbCollection.update(this.expression, this.values, false, false));
                    return true;
                }
                case INSERT: {
                    this.setExecutionResult(dbCollection.insert(new DBObject[]{this.values}));
                    return true;
                }
                case DELETE: {
                    this.setExecutionResult(dbCollection.remove(this.expression));
                    return true;
                }
                default: {
                    throw new DBCException("Query type '" + this.queryType + "' not supported");
                }
            }
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private boolean processDDL() throws DBException {
        DB db = this.session.getDataSource().getDefaultObject().getDB();
        if (this.ddlStatement instanceof CreateTable) {
            BasicDBObject colOptions = new BasicDBObject();
            db.createCollection(this.collectionName, (DBObject)colOptions);
        } else if (this.ddlStatement instanceof Drop) {
            if (!db.collectionExists(this.collectionName)) {
                throw new DBException("Collection '" + this.collectionName + "' does not exist");
            }
            DBCollection collection = db.getCollection(this.collectionName);
            collection.drop();
        } else {
            boolean cfr_ignored_0 = this.ddlStatement instanceof Alter;
        }
        return false;
    }

    private void makeQueryFromString(String queryString) throws JSQLParserException, DBException {
        Statement statement = CCJSqlParserUtil.parse((String)queryString);
        if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            this.parseSelect(select);
            this.queryType = SQLQueryType.SELECT;
        } else if (statement instanceof Update) {
            this.parseUpdate((Update)statement);
            this.queryType = SQLQueryType.UPDATE;
        } else if (statement instanceof CreateTable) {
            this.parseCreateTable((CreateTable)statement);
            this.queryType = SQLQueryType.DDL;
        } else if (statement instanceof Drop) {
            this.parseDropTable((Drop)statement);
            this.queryType = SQLQueryType.DDL;
        } else if (statement instanceof Alter) {
            this.parseAlterTable((Alter)statement);
            this.queryType = SQLQueryType.DDL;
        } else {
            throw new DBCException("Statement " + statement.getClass() + " not supported");
        }
    }

    private void parseCreateTable(CreateTable statement) {
        this.ddlStatement = statement;
        this.collectionName = statement.getTable().getName();
    }

    private void parseDropTable(Drop statement) {
        this.ddlStatement = statement;
        this.collectionName = statement.getName().getName();
    }

    private void parseAlterTable(Alter statement) {
        this.ddlStatement = statement;
        this.collectionName = statement.getTable().getName();
    }

    private void parseSelect(PlainSelect select) throws DBException {
        List gbe;
        Limit sLimit;
        Expression where;
        if (!(select.getFromItem() instanceof Table)) {
            throw new DBCException("FROM keyword missing");
        }
        if (!CommonUtils.isEmpty((Collection)select.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (select.getHaving() != null) {
            throw new DBCException("HAVING not supported");
        }
        Table sourceTable = (Table)select.getFromItem();
        this.collection = this.getCollectionFromTable(sourceTable);
        List selectItems = select.getSelectItems();
        if (!CommonUtils.isEmpty((Collection)selectItems)) {
            this.values = new BasicDBObject();
            for (SelectItem item : selectItems) {
                if (item instanceof AllColumns || item instanceof AllTableColumns) {
                    this.values = null;
                    break;
                }
                if (!(item instanceof SelectExpressionItem)) continue;
                SelectExpressionItem sei = (SelectExpressionItem)item;
                Expression expr = sei.getExpression();
                if (expr instanceof Column) {
                    String attrName = DBUtils.getUnQuotedIdentifier((String)((Column)expr).getFullyQualifiedName(), (String)"\"");
                    this.values.put(attrName, (Object)1);
                    continue;
                }
                if (expr instanceof Function && ((Function)expr).getName().equals("count")) {
                    this.count = true;
                    continue;
                }
                throw new DBCException("Unsupported select expression: " + expr);
            }
        }
        if ((where = select.getWhere()) != null) {
            this.expression = MongoUtils.convertExpressionToObject(where);
        }
        if ((sLimit = select.getLimit()) != null) {
            try {
                if (sLimit.getOffset() != null) {
                    this.offset = Long.parseLong(sLimit.getOffset().toString());
                }
                if (sLimit.getRowCount() != null) {
                    this.limit = Long.parseLong(sLimit.getRowCount().toString());
                }
            }
            catch (NumberFormatException e) {
                throw new DBCException("Bad LIMIT clause", (Throwable)e);
            }
        }
        if (!CommonUtils.isEmpty((Collection)(gbe = select.getGroupByColumnReferences()))) {
            throw new DBCException("GROUP BY is not supported yet");
        }
        List orderByElements = select.getOrderByElements();
        if (!CommonUtils.isEmpty((Collection)orderByElements)) {
            this.order = new BasicDBObject();
            for (OrderByElement element : orderByElements) {
                Expression expr = element.getExpression();
                if (expr instanceof Column) {
                    this.order.put(MongoUtils.unquote(((Column)expr).getFullyQualifiedName()), (Object)(element.isAsc() ? 1 : -1));
                    continue;
                }
                throw new DBCException("Bad order element: " + expr);
            }
        }
    }

    private void parseUpdate(Update update) throws DBException {
        if (update.getTables() == null || update.getTables().size() != 1) {
            throw new DBCException("Can update only one table");
        }
        if (!CommonUtils.isEmpty((Collection)update.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (update.getSelect() != null) {
            throw new DBCException("SELECT in UPDATE not supported");
        }
        this.collection = this.getCollectionFromTable((Table)update.getTables().get(0));
        List columns = update.getColumns();
        List valueExpressions = update.getExpressions();
        if (CommonUtils.isEmpty((Collection)columns) || CommonUtils.isEmpty((Collection)valueExpressions)) {
            throw new DBCException("Empty columns/values");
        }
        if (columns.size() != valueExpressions.size()) {
            throw new DBCException("Column set doesn't match value set");
        }
        this.values = new BasicDBObject();
        int i = 0;
        while (i < columns.size()) {
            Column item = (Column)columns.get(i);
            Object value = MongoUtils.convertValueExpressionToObject((Expression)valueExpressions.get(i));
            this.values.put("$set", (Object)new BasicDBObject(item.getFullyQualifiedName(), value));
            ++i;
        }
        Expression where = update.getWhere();
        if (where != null) {
            this.expression = MongoUtils.convertExpressionToObject(where);
        }
    }

    private MGCollection getCollectionFromTable(Table sourceTable) throws DBException {
        MGCollection col;
        MGDatabase database;
        Database dbObject = sourceTable.getDatabase();
        String schemaName = sourceTable.getSchemaName();
        if (schemaName == null) {
            schemaName = this.session.getDataSource().getSelectedDatabase();
        }
        schemaName = MongoUtils.unquote(schemaName);
        String colName = sourceTable.getName();
        if (colName == null) {
            throw new DBCException("Collection not specified in SELECT statement");
        }
        colName = MongoUtils.unquote(colName);
        if (dbObject != null && !CommonUtils.isEmpty((String)dbObject.getDatabaseName())) {
            colName = String.valueOf(schemaName) + "." + colName;
            schemaName = dbObject.getDatabaseName();
        }
        if (schemaName == null) {
            database = this.session.getDataSource().getDefaultObject();
            if (database == null) {
                throw new DBCException("No active database and query doesn't contain explicit database reference");
            }
        } else {
            database = this.session.getDataSource().getDatabase(schemaName);
            if (database == null) {
                throw new DBCException("Database '" + schemaName + "' not found");
            }
        }
        if ((col = database.getChild(this.session.getProgressMonitor(), colName)) == null) {
            throw new DBCException("Collection '" + colName + "' not found in database '" + database.getName() + "'");
        }
        return col;
    }
}

