/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.exec.MongoResultSet;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MGCollection;
import com.dbeaver.ee.mongodb.model.MGCollectionAttribute;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.AttributeMetaDataProxy;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class MongoBaseStatement
implements DBCStatement {
    protected final MongoSession session;
    protected final String query;
    protected DBCExecutionSource source;
    protected MGCollection collection;
    protected DBCursor result;
    protected List<DBObject> resultList;
    protected WriteResult writeResult;
    protected Throwable executeError;
    protected long offset;
    protected long limit;

    protected MongoBaseStatement(MongoSession session, String query) {
        this.session = session;
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @NotNull
    public MongoSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public MongoResultSet openResultSet() throws DBCException {
        if (this.resultList != null) {
            return new MongoResultSet(this, this.resultList);
        }
        if (this.result == null) {
            return null;
        }
        return new MongoResultSet(this, this.result);
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return this.writeResult == null ? -1 : this.writeResult.getN();
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
        this.result = null;
        this.resultList = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBPDataSource)this.session.getDataSource());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, (long)this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, null);
    }

    protected void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }

    @NotNull
    public DBCResultSetMetaData createMetadata() {
        ArrayList<Object> attrs = new ArrayList<Object>(1);
        if (this.collection != null) {
            attrs.add((Object)new AttributeMeta(this.collection.getDocumentAttribute()));
        } else {
            attrs.add(new DynamicDocumentAttribute());
        }
        return new LocalResultSetMeta(attrs);
    }

    protected void setExecutionResult(CommandResult commandResult) {
        Object retval = commandResult.get("retval");
        if (retval instanceof DBCursor) {
            this.result = (DBCursor)retval;
        } else {
            this.resultList = new ArrayList<DBObject>(1);
            if (retval == null) {
                this.resultList.add((DBObject)commandResult);
            } else if (retval instanceof Collection) {
                boolean objects = true;
                for (Object obj : (Collection)retval) {
                    if (obj instanceof DBObject) continue;
                    objects = false;
                    break;
                }
                if (objects) {
                    this.resultList.addAll((Collection)retval);
                } else {
                    this.resultList.add((DBObject)retval);
                }
            } else if (retval instanceof DBObject) {
                this.resultList.add((DBObject)retval);
            } else {
                this.resultList.add((DBObject)new BasicDBObject("retval", retval));
            }
        }
    }

    protected void setExecutionResult(WriteResult writeResult) {
        this.writeResult = writeResult;
    }

    public abstract class AbstractDocumentAttribute
    implements DBCAttributeMetaData {
        public String getFullTypeName() {
            return this.getTypeName();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public boolean isReadOnly() {
            return true;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return null;
        }
    }

    private class AttributeMeta
    extends AttributeMetaDataProxy {
        private AttributeMeta(MGCollectionAttribute attribute) {
            super((DBSAttributeBase)attribute);
        }

        public DBSObject getSource() {
            return MongoBaseStatement.this.collection;
        }

        public String getEntityName() {
            return MongoBaseStatement.this.collection.getName();
        }
    }

    public class DynamicDocumentAttribute
    extends AbstractDocumentAttribute {
        public String getName() {
            return "document";
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 2;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        public Object getSource() {
            return MongoBaseStatement.this;
        }

        public String getLabel() {
            return "document";
        }

        public String getEntityName() {
            return null;
        }
    }
}

