/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DiagramObjectCollector {
    private static final Log log = Log.getLog(DiagramObjectCollector.class);
    private final EntityDiagram diagram;
    private final List<ERDEntity> erdEntities = new ArrayList<ERDEntity>();

    public DiagramObjectCollector(EntityDiagram diagram) {
        this.diagram = diagram;
    }

    public static Collection<DBSEntity> collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots) throws DBException {
        LinkedHashSet<DBSEntity> tables = new LinkedHashSet<DBSEntity>();
        DiagramObjectCollector.collectTables(monitor, roots, tables);
        return tables;
    }

    /*
     * WARNING - void declaration
     */
    private static void collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, Set<DBSEntity> tables) throws DBException {
        for (DBSObject dBSObject : roots) {
            void var3_4;
            if (monitor.isCanceled()) break;
            if (dBSObject instanceof DBSAlias) {
                DBSObject dBSObject2 = ((DBSAlias)dBSObject).getTargetObject(monitor);
            }
            if (var3_4 instanceof DBSFolder) {
                DiagramObjectCollector.collectTables(monitor, ((DBSFolder)var3_4).getChildrenObjects(monitor), tables);
            } else if (var3_4 instanceof DBSEntity) {
                tables.add((DBSEntity)var3_4);
            }
            if (!(var3_4 instanceof DBSObjectContainer)) continue;
            DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)var3_4, tables);
        }
    }

    private static void collectTables(DBRProgressMonitor monitor, DBSObjectContainer container, Set<DBSEntity> tables) throws DBException {
        if (monitor.isCanceled()) {
            return;
        }
        container.cacheStructure(monitor, 7);
        Collection children = container.getChildren(monitor);
        if (!CommonUtils.isEmpty((Collection)children)) {
            Class childType = container.getChildType(monitor);
            DBSObjectFilter objectFilter = container.getDataSource().getContainer().getObjectFilter(childType, (DBSObject)container, true);
            for (DBSObject entity : children) {
                if (monitor.isCanceled()) break;
                if (objectFilter != null && !objectFilter.matches(entity.getName())) continue;
                if (entity instanceof DBSEntity) {
                    tables.add((DBSEntity)entity);
                    continue;
                }
                if (!(entity instanceof DBSObjectContainer)) continue;
                DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)entity, tables);
            }
        }
    }

    public void generateDiagramObjects(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots) throws DBException {
        boolean showViews = ERDActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.show.views");
        Collection<DBSEntity> tables = DiagramObjectCollector.collectTables(monitor, roots);
        for (DBSEntity table : tables) {
            if (DBUtils.isHiddenObject((Object)table) || !showViews && table instanceof DBSTable && ((DBSTable)table).isView()) continue;
            this.addDiagramEntity(monitor, table);
        }
        for (ERDEntity erdEntity : this.erdEntities) {
            erdEntity.addModelRelations(monitor, this.diagram, true, false);
        }
    }

    private void addDiagramEntity(DBRProgressMonitor monitor, DBSEntity table) {
        if (this.diagram.containsTable(table) && !this.diagram.getDecorator().allowEntityDuplicates()) {
            return;
        }
        ERDEntity erdEntity = ERDUtils.makeEntityFromObject(monitor, this.diagram, table, null);
        if (erdEntity != null) {
            this.erdEntities.add(erdEntity);
        }
    }

    public List<ERDEntity> getDiagramEntities() {
        return this.erdEntities;
    }

    public static List<ERDEntity> generateEntityList(EntityDiagram diagram, Collection<DBPNamedObject> objects) {
        ArrayList<DBSObject> roots = new ArrayList<DBSObject>();
        for (DBPNamedObject object : objects) {
            if (!(object instanceof DBSObject)) continue;
            roots.add((DBSObject)object);
        }
        ArrayList<ERDEntity> entities = new ArrayList<ERDEntity>();
        try {
            UIUtils.runInProgressService(monitor -> {
                DiagramObjectCollector collector = new DiagramObjectCollector(diagram);
                try {
                    collector.generateDiagramObjects(monitor, roots);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                entities.addAll(collector.getDiagramEntities());
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return entities;
    }
}

