/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import com.dbeaver.ee.cassandra.model.CasAbstractDataType;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasTypedObject;
import com.dbeaver.ee.cassandra.model.CasUserTypeAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;

public class CasUserType
extends CasAbstractDataType
implements CasTypedObject,
DBSEntity,
DBPScriptObject {
    private final CasKeyspace keyspace;
    private final UserType metadata;
    private final List<CasUserTypeAttribute> attributes = new ArrayList<CasUserTypeAttribute>();

    public CasUserType(CasKeyspace casKeyspace, UserType userType) {
        super(casKeyspace.getDataSource());
        this.keyspace = casKeyspace;
        this.metadata = userType;
        int n = 1;
        for (String string : userType.getFieldNames()) {
            CasUserTypeAttribute casUserTypeAttribute = new CasUserTypeAttribute(this, n++, string, userType.getFieldType(string));
            this.attributes.add(casUserTypeAttribute);
        }
    }

    @Nullable
    public CasKeyspace getParentObject() {
        return this.keyspace;
    }

    @Property(viewable=true)
    public String getTypeName() {
        return this.metadata.getTypeName();
    }

    public int getTypeID() {
        return this.metadata.hashCode();
    }

    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @Nullable
    public List<CasUserTypeAttribute> getAttributes(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.attributes;
    }

    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return (DBSEntityAttribute)DBUtils.findObject(this.attributes, (String)string);
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return null;
    }

    @Override
    @NotNull
    public DataType getCasDataType() {
        return this.metadata;
    }

    public String getObjectDefinitionText(DBRProgressMonitor dBRProgressMonitor, Map<String, Object> map) throws DBException {
        return this.metadata.exportAsString();
    }
}

