/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.exec;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.CasListValue;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.CasSetValue;
import com.dbeaver.ee.cassandra.data.CasTupleValue;
import com.dbeaver.ee.cassandra.data.CasUDTValue;
import com.dbeaver.ee.cassandra.exec.CasBaseStatement;
import com.dbeaver.ee.cassandra.exec.CasQueryTrace;
import com.dbeaver.ee.cassandra.model.CasResultSetMetaData;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetTrace;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasResultSet
implements DBCResultSet,
DBCResultSetTrace {
    private final CasBaseStatement statement;
    private final ResultSet resultSet;
    private final Iterator<Row> rowIterator;
    private CasResultSetMetaData metaData;
    private Row curRow;
    private ColumnDefinitions columnDefinitions;
    private long rowCount = 0L;

    public CasResultSet(CasBaseStatement casBaseStatement, ResultSet resultSet) {
        ExecutionInfo executionInfo;
        this.statement = casBaseStatement;
        this.resultSet = resultSet;
        this.rowIterator = resultSet.iterator();
        long l = casBaseStatement.getOffset();
        if (l > 0L) {
            int n = 0;
            while ((long)n < l && this.rowIterator.hasNext()) {
                this.rowIterator.next();
                ++n;
            }
        }
        if ((executionInfo = resultSet.getExecutionInfo()) != null && !CommonUtils.isEmpty((Collection)executionInfo.getWarnings())) {
            Iterator iterator = executionInfo.getWarnings().iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
            }
        }
        if (casBaseStatement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
    }

    public DBCSession getSession() {
        return this.statement.getSession();
    }

    public CasBaseStatement getSourceStatement() {
        return this.statement;
    }

    public Object getAttributeValue(int n) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(n)) {
            return null;
        }
        DataType dataType = this.columnDefinitions.getType(n);
        switch (dataType.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.curRow.getString(n);
            }
            case TINYINT: {
                return this.curRow.getByte(n);
            }
            case SMALLINT: {
                return this.curRow.getShort(n);
            }
            case INT: {
                return this.curRow.getInt(n);
            }
            case BIGINT: {
                return this.curRow.getLong(n);
            }
            case COUNTER: {
                return this.curRow.getLong(n);
            }
            case VARINT: {
                return this.curRow.getVarint(n);
            }
            case DECIMAL: {
                return this.curRow.getDecimal(n);
            }
            case FLOAT: {
                return Float.valueOf(this.curRow.getFloat(n));
            }
            case DOUBLE: {
                return this.curRow.getDouble(n);
            }
            case BOOLEAN: {
                return this.curRow.getBool(n);
            }
            case DATE: {
                return this.curRow.getDate(n);
            }
            case TIME: {
                return this.curRow.getTime(n);
            }
            case TIMESTAMP: {
                return this.curRow.getTimestamp(n);
            }
            case UUID: 
            case TIMEUUID: {
                return this.curRow.getUUID(n);
            }
            case INET: {
                return this.curRow.getInet(n);
            }
            case MAP: {
                return new CasMapValue(this.statement.getSession().getDataSource(), this.columnDefinitions.getKeyspace(n), this.curRow.getMap(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(1))), dataType);
            }
            case LIST: {
                return new CasListValue(this.statement.getSession().getProgressMonitor(), this.statement.getSession().getDataSource(), this.columnDefinitions.getKeyspace(n), this.curRow.getList(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0))), dataType);
            }
            case SET: {
                return new CasSetValue(this.statement.getSession().getDataSource(), this.columnDefinitions.getKeyspace(n), this.curRow.getSet(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0))), dataType);
            }
            case TUPLE: {
                return new CasTupleValue(this.statement.getSession().getDataSource(), this.columnDefinitions.getKeyspace(n), this.curRow.getTupleValue(n));
            }
            case UDT: {
                return new CasUDTValue(this.statement.getSession().getDataSource(), this.columnDefinitions.getKeyspace(n), this.curRow.getUDTValue(n));
            }
        }
        return new CasContentBytes(this.statement.getSession().getDataSource(), this.curRow.getBytes(n));
    }

    public static TypeToken<Object> getClassFromType(DataType dataType) {
        TypeCodec typeCodec = CodecRegistry.DEFAULT_INSTANCE.codecFor(dataType);
        if (typeCodec == null) {
            return TypeToken.of(Object.class);
        }
        return typeCodec.getJavaType();
    }

    public Object getAttributeValue(String string) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(string)) {
            return null;
        }
        DataType dataType = this.columnDefinitions.getType(string);
        switch (dataType.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.curRow.getString(string);
            }
            case TINYINT: {
                return this.curRow.getByte(string);
            }
            case SMALLINT: {
                return this.curRow.getShort(string);
            }
            case INT: {
                return this.curRow.getInt(string);
            }
            case BIGINT: {
                return this.curRow.getLong(string);
            }
            case COUNTER: {
                return this.curRow.getLong(string);
            }
            case VARINT: {
                return this.curRow.getVarint(string);
            }
            case DECIMAL: {
                return this.curRow.getDecimal(string);
            }
            case FLOAT: {
                return Float.valueOf(this.curRow.getFloat(string));
            }
            case DOUBLE: {
                return this.curRow.getDouble(string);
            }
            case BOOLEAN: {
                return this.curRow.getBool(string);
            }
            case TIME: {
                return this.curRow.getTime(string);
            }
            case DATE: {
                return this.curRow.getDate(string);
            }
            case TIMESTAMP: {
                return this.curRow.getTimestamp(string);
            }
            case UUID: 
            case TIMEUUID: {
                return this.curRow.getUUID(string);
            }
            case INET: {
                return this.curRow.getInet(string);
            }
            case MAP: {
                return this.curRow.getMap(string, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(1)));
            }
            case LIST: {
                return this.curRow.getList(string, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0)));
            }
            case SET: {
                return this.curRow.getSet(string, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0)));
            }
            case TUPLE: {
                return this.curRow.getTupleValue(string);
            }
            case UDT: {
                return this.curRow.getUDTValue(string);
            }
        }
        return this.curRow.getBytes(string);
    }

    public DBDValueMeta getAttributeValueMeta(int n) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        return null;
    }

    public boolean nextRow() throws DBCException {
        if (!this.rowIterator.hasNext()) {
            this.curRow = null;
            this.columnDefinitions = null;
            return false;
        }
        this.curRow = this.rowIterator.next();
        this.columnDefinitions = this.curRow.getColumnDefinitions();
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int n) throws DBCException {
        return false;
    }

    @NotNull
    public CasResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new CasResultSetMetaData(this.statement, this.resultSet);
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public void close() {
        if (this.statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, this.rowCount);
        }
    }

    public DBCTrace getExecutionTrace() {
        return new CasQueryTrace(this.resultSet.getExecutionInfo());
    }
}

