/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data.handlers;

import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.handlers.CasBaseValueHandler;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import java.nio.ByteBuffer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasContentValueHandler
extends CasBaseValueHandler {
    public static final CasContentValueHandler INSTANCE = new CasContentValueHandler();

    @NotNull
    public Class<DBDContent> getValueObjectType(@NotNull DBSTypedObject dBSTypedObject) {
        return DBDContent.class;
    }

    @Override
    public Object fetchValueObject(@NotNull DBCSession dBCSession, @NotNull DBCResultSet dBCResultSet, @NotNull DBSTypedObject dBSTypedObject, int n) throws DBCException {
        Object object = super.fetchValueObject(dBCSession, dBCResultSet, dBSTypedObject, n);
        return this.getValueFromObject(dBCSession, dBSTypedObject, object, false);
    }

    public CasContentBytes getValueFromObject(@NotNull DBCSession dBCSession, @NotNull DBSTypedObject dBSTypedObject, Object object, boolean bl) throws DBCException {
        CasSession casSession = (CasSession)dBCSession;
        if (object == null) {
            return new CasContentBytes(casSession.getDataSource());
        }
        if (object instanceof CasContentBytes) {
            CasContentBytes casContentBytes = (CasContentBytes)((Object)object);
            return bl ? new CasContentBytes(casSession.getDataSource(), casContentBytes.getData()) : casContentBytes;
        }
        if (object instanceof ByteBuffer) {
            return new CasContentBytes(casSession.getDataSource(), (ByteBuffer)object);
        }
        if (object instanceof byte[]) {
            return new CasContentBytes(casSession.getDataSource(), ByteBuffer.wrap((byte[])object));
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession casSession, CasPreparedStatement casPreparedStatement, DBSTypedObject dBSTypedObject, int n, Object object) throws DBCException {
        casPreparedStatement.getBoundStatement().setBytes(n, ((CasContentBytes)((Object)object)).getData());
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject dBSTypedObject, Object object, @NotNull DBDDisplayFormat dBDDisplayFormat) {
        if (object instanceof DBDContent) {
            String string = ((DBDContent)object).getDisplayString(dBDDisplayFormat);
            if (string == null) {
                return super.getValueDisplayString(dBSTypedObject, null, dBDDisplayFormat);
            }
            return string;
        }
        return super.getValueDisplayString(dBSTypedObject, object, dBDDisplayFormat);
    }
}

